/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pwpolicy;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.pwpolicy.PasswordPolicyRule;

public class PasswordPolicyUpperCaseRuleImpl
implements PasswordPolicyRule {
    public static final String placeholder = "UPPERCASE";
    private int minUpperCase;

    public PasswordPolicyUpperCaseRuleImpl(int minUpperCase) {
        this.minUpperCase = minUpperCase;
    }

    @Override
    public String getPlaceholder() {
        return placeholder;
    }

    @Override
    public Map<String, String> getParameter() {
        HashMap<String, String> parameter = new HashMap<String, String>();
        parameter.put("minUpperCase", "" + this.minUpperCase);
        return parameter;
    }

    @Override
    public boolean execute(String password) {
        int lowerCaseCount = 0;
        char[] cArray = password.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (Character.isUpperCase(c.charValue())) {
                ++lowerCaseCount;
            }
            if (lowerCaseCount < this.minUpperCase) continue;
            return true;
        }
        return false;
    }
}

