/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application.impl.deployment;

import java.util.List;
import java.util.Map;
import org.camunda.bpm.application.impl.EmbeddedProcessApplication;
import org.camunda.bpm.engine.impl.test.ResourceProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessApplicationDeployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class CmmnDisabledTest
extends ResourceProcessEngineTestCase {
    protected EmbeddedProcessApplication processApplication;

    public CmmnDisabledTest() {
        super("org/camunda/bpm/application/impl/deployment/cmmn.disabled.camunda.cfg.xml");
    }

    protected void setUp() throws Exception {
        this.processApplication = new EmbeddedProcessApplication();
        super.setUp();
    }

    public void testCmmnDisabled() {
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").deploy();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        CmmnDisabledTest.assertNotNull((Object)processDefinition);
        CmmnDisabledTest.assertEquals((int)1, (int)processDefinition.getVersion());
        try {
            this.repositoryService.createCaseDefinitionQuery().singleResult();
            CmmnDisabledTest.fail((String)"Cmmn Disabled: It should not be possible to query for a case definition.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    public void testVariableInstanceQuery() {
        ProcessApplicationDeployment deployment = this.repositoryService.createDeployment(this.processApplication.getReference()).addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").deploy();
        VariableMap variables = Variables.createVariables().putValue("my-variable", (Object)"a-value");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)variables);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CmmnDisabledTest.assertEquals((int)1, (int)result.size());
        VariableInstance variableInstance = (VariableInstance)result.get(0);
        CmmnDisabledTest.assertEquals((String)"my-variable", (String)variableInstance.getName());
        CmmnDisabledTest.assertNotNull((Object)this.runtimeService.getVariable(processInstance.getId(), "my-variable"));
        CmmnDisabledTest.assertNotNull((Object)this.runtimeService.getVariableLocal(processInstance.getId(), "my-variable"));
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }
}

