/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.container.impl.deployment.scanning.ClassPathProcessApplicationScanner;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ClassPathScannerTest {
    private final String url;
    private static ClassPathProcessApplicationScanner scanner;

    @Parameterized.Parameters
    public static List<Object[]> data() {
        return Arrays.asList({"file:src/test/resources/org/camunda/bpm/container/impl/jmx/deployment/util/ClassPathScannerTest.testScanClassPathWithFiles/"}, {"file:src/test/resources/org/camunda/bpm/container/impl/jmx/deployment/util/ClassPathScannerTest.testScanClassPathWithFilesRecursive/"}, {"file:src/test/resources/org/camunda/bpm/container/impl/jmx/deployment/util/ClassPathScannerTest.testScanClassPathWithFilesRecursiveTwoDirectories/"}, {"file:src/test/resources/org/camunda/bpm/container/impl/jmx/deployment/util/ClassPathScannerTest.testScanClassPathWithAdditionalResourceSuffixes/"}, {"file:src/test/resources/org/camunda/bpm/container/impl/jmx/deployment/util/ClassPathScannerTest.testScanClassPath.jar"}, {"file:src/test/resources/org/camunda/bpm/container/impl/jmx/deployment/util/ClassPathScannerTest.testScanClassPathRecursive.jar"}, {"file:src/test/resources/org/camunda/bpm/container/impl/jmx/deployment/util/ClassPathScannerTest.testScanClassPathRecursiveTwoDirectories.jar"});
    }

    public ClassPathScannerTest(String url) {
        this.url = url;
    }

    @BeforeClass
    public static void setup() {
        scanner = new ClassPathProcessApplicationScanner();
    }

    @Test
    public void testScanClassPath() throws MalformedURLException {
        URLClassLoader classLoader = this.getClassloader();
        HashMap<String, byte[]> scanResult = new HashMap<String, byte[]>();
        scanner.scanPaResourceRootPath((ClassLoader)classLoader, new URL(this.url + "/META-INF/processes.xml"), null, scanResult);
        Assert.assertTrue((String)"'testDeployProcessArchive.bpmn20.xml' not found", (boolean)this.contains(scanResult, "testDeployProcessArchive.bpmn20.xml"));
        Assert.assertTrue((String)"'testDeployProcessArchive.png' not found", (boolean)this.contains(scanResult, "testDeployProcessArchive.png"));
        if (this.url.contains("TwoDirectories")) {
            Assert.assertEquals((long)4L, (long)scanResult.size());
        } else {
            Assert.assertEquals((long)2L, (long)scanResult.size());
        }
    }

    @Test
    public void testScanClassPathWithNonExistingRootPath_relativeToPa() throws MalformedURLException {
        URLClassLoader classLoader = this.getClassloader();
        HashMap<String, byte[]> scanResult = new HashMap<String, byte[]>();
        scanner.scanPaResourceRootPath((ClassLoader)classLoader, new URL(this.url + "/META-INF/processes.xml"), "pa:nonexisting", scanResult);
        Assert.assertFalse((String)"'testDeployProcessArchive.bpmn20.xml' found", (boolean)this.contains(scanResult, "testDeployProcessArchive.bpmn20.xml"));
        Assert.assertFalse((String)"'testDeployProcessArchive.png' found", (boolean)this.contains(scanResult, "testDeployProcessArchive.png"));
        Assert.assertEquals((long)0L, (long)scanResult.size());
    }

    @Test
    public void testScanClassPathWithNonExistingRootPath_nonRelativeToPa() throws MalformedURLException {
        URLClassLoader classLoader = this.getClassloader();
        HashMap<String, byte[]> scanResult = new HashMap<String, byte[]>();
        scanner.scanPaResourceRootPath((ClassLoader)classLoader, null, "nonexisting", scanResult);
        Assert.assertFalse((String)"'testDeployProcessArchive.bpmn20.xml' found", (boolean)this.contains(scanResult, "testDeployProcessArchive.bpmn20.xml"));
        Assert.assertFalse((String)"'testDeployProcessArchive.png' found", (boolean)this.contains(scanResult, "testDeployProcessArchive.png"));
        Assert.assertEquals((long)0L, (long)scanResult.size());
    }

    @Test
    public void testScanClassPathWithExistingRootPath_relativeToPa() throws MalformedURLException {
        URLClassLoader classLoader = this.getClassloader();
        HashMap<String, byte[]> scanResult = new HashMap<String, byte[]>();
        scanner.scanPaResourceRootPath((ClassLoader)classLoader, new URL(this.url + "/META-INF/processes.xml"), "pa:directory/", scanResult);
        if (this.url.contains("Recursive")) {
            Assert.assertTrue((String)"'testDeployProcessArchive.bpmn20.xml' not found", (boolean)this.contains(scanResult, "testDeployProcessArchive.bpmn20.xml"));
            Assert.assertTrue((String)"'testDeployProcessArchive.png' not found", (boolean)this.contains(scanResult, "testDeployProcessArchive.png"));
            Assert.assertEquals((long)2L, (long)scanResult.size());
        } else {
            Assert.assertFalse((String)"'testDeployProcessArchive.bpmn20.xml' found", (boolean)this.contains(scanResult, "testDeployProcessArchive.bpmn20.xml"));
            Assert.assertFalse((String)"'testDeployProcessArchive.png' found", (boolean)this.contains(scanResult, "testDeployProcessArchive.png"));
            Assert.assertEquals((long)0L, (long)scanResult.size());
        }
    }

    @Test
    public void testScanClassPathWithExistingRootPath_nonRelativeToPa() throws MalformedURLException {
        URLClassLoader classLoader = this.getClassloader();
        HashMap<String, byte[]> scanResult = new HashMap<String, byte[]>();
        scanner.scanPaResourceRootPath((ClassLoader)classLoader, null, "directory/", scanResult);
        if (this.url.contains("Recursive")) {
            Assert.assertTrue((String)"'testDeployProcessArchive.bpmn20.xml' not found", (boolean)this.contains(scanResult, "testDeployProcessArchive.bpmn20.xml"));
            Assert.assertTrue((String)"'testDeployProcessArchive.png' not found", (boolean)this.contains(scanResult, "testDeployProcessArchive.png"));
            Assert.assertEquals((long)2L, (long)scanResult.size());
        } else {
            Assert.assertFalse((String)"'testDeployProcessArchive.bpmn20.xml' found", (boolean)this.contains(scanResult, "testDeployProcessArchive.bpmn20.xml"));
            Assert.assertFalse((String)"'testDeployProcessArchive.png' found", (boolean)this.contains(scanResult, "testDeployProcessArchive.png"));
            Assert.assertEquals((long)0L, (long)scanResult.size());
        }
    }

    @Test
    public void testScanClassPathWithAdditionalResourceSuffixes() throws MalformedURLException {
        URLClassLoader classLoader = this.getClassloader();
        String[] additionalResourceSuffixes = new String[]{"py", "rb", "groovy"};
        Map scanResult = scanner.findResources((ClassLoader)classLoader, null, new URL(this.url + "/META-INF/processes.xml"), additionalResourceSuffixes);
        if (this.url.contains("AdditionalResourceSuffixes")) {
            Assert.assertEquals((long)5L, (long)scanResult.size());
        }
    }

    private URLClassLoader getClassloader() throws MalformedURLException {
        return new URLClassLoader(new URL[]{new URL(this.url)});
    }

    private boolean contains(Map<String, byte[]> scanResult, String suffix) {
        for (String string : scanResult.keySet()) {
            if (!string.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }
}

