/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import java.util.List;
import org.camunda.bpm.engine.impl.batch.BatchConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.BatchUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class BatchUtilTest {
    private ProcessEngineConfigurationImpl engineConfiguration;
    private BatchConfiguration batchConfiguration;
    private List<String> ids;

    @Before
    public void setUp() {
        this.batchConfiguration = (BatchConfiguration)Mockito.mock(BatchConfiguration.class);
        this.engineConfiguration = (ProcessEngineConfigurationImpl)Mockito.mock(ProcessEngineConfigurationImpl.class);
        this.ids = (List)Mockito.mock(List.class);
        Mockito.when((Object)this.batchConfiguration.getIds()).thenReturn(this.ids);
    }

    @Test
    public void shouldReturnCorrectSizeUneven() {
        Mockito.when((Object)this.ids.size()).thenReturn((Object)5);
        Mockito.when((Object)this.engineConfiguration.getInvocationsPerBatchJob()).thenReturn((Object)2);
        this.testConfiguration(this.engineConfiguration, this.batchConfiguration, 3);
    }

    @Test
    public void shouldReturnCorrectSizeZeroBatchSize() {
        Mockito.when((Object)this.ids.size()).thenReturn((Object)2);
        Mockito.when((Object)this.engineConfiguration.getInvocationsPerBatchJob()).thenReturn((Object)0);
        this.testConfiguration(this.engineConfiguration, this.batchConfiguration, 0);
    }

    @Test
    public void shouldReturnCorrectSizeEven() {
        Mockito.when((Object)this.ids.size()).thenReturn((Object)4);
        Mockito.when((Object)this.engineConfiguration.getInvocationsPerBatchJob()).thenReturn((Object)2);
        this.testConfiguration(this.engineConfiguration, this.batchConfiguration, 2);
    }

    @Test
    public void shouldReturnCorrectSizeZeroInstances() {
        Mockito.when((Object)this.ids.size()).thenReturn((Object)0);
        Mockito.when((Object)this.engineConfiguration.getInvocationsPerBatchJob()).thenReturn((Object)2);
        this.testConfiguration(this.engineConfiguration, this.batchConfiguration, 0);
    }

    @Test
    public void shouldReturnCorrectSizeZeroInstancesZeroBatchSize() {
        Mockito.when((Object)this.ids.size()).thenReturn((Object)0);
        Mockito.when((Object)this.engineConfiguration.getInvocationsPerBatchJob()).thenReturn((Object)0);
        this.testConfiguration(this.engineConfiguration, this.batchConfiguration, 0);
    }

    private void testConfiguration(ProcessEngineConfigurationImpl engineConfiguration, BatchConfiguration batchConfiguration, int expectedResult) {
        Assert.assertEquals((long)expectedResult, (long)BatchUtil.calculateBatchSize((ProcessEngineConfigurationImpl)engineConfiguration, (BatchConfiguration)batchConfiguration));
    }
}

