/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.AbstractQuery;
import org.camunda.bpm.engine.management.ActivityStatistics;
import org.camunda.bpm.engine.management.ActivityStatisticsQuery;
import org.camunda.bpm.engine.management.IncidentStatistics;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;

public class ActivityStatisticsAuthorizationTest
extends AuthorizationTest {
    protected static final String ONE_INCIDENT_PROCESS_KEY = "process";
    protected String deploymentId;

    @Override
    public void setUp() throws Exception {
        this.deploymentId = this.createDeployment(null, "org/camunda/bpm/engine/test/api/authorization/oneIncidentProcess.bpmn20.xml").getId();
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        this.startProcessAndExecuteJob(ONE_INCIDENT_PROCESS_KEY);
        super.setUp();
    }

    @Override
    public void tearDown() {
        super.tearDown();
        this.deleteDeployment(this.deploymentId);
    }

    public void testQueryWithoutAuthorizations() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        try {
            this.managementService.createActivityStatisticsQuery(processDefinitionId).list();
            ActivityStatisticsAuthorizationTest.fail((String)"Exception expected: It should not be possible to execute the activity statistics query");
        }
        catch (AuthorizationException e) {
            String message = e.getMessage();
            this.assertTextPresent(this.userId, message);
            this.assertTextPresent(Permissions.READ.getName(), message);
            this.assertTextPresent(ONE_INCIDENT_PROCESS_KEY, message);
            this.assertTextPresent(Resources.PROCESS_DEFINITION.resourceName(), message);
        }
    }

    public void testQueryIncludingInstancesWithoutAuthorizationOnProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ActivityStatisticsQuery query = this.managementService.createActivityStatisticsQuery(processDefinitionId);
        this.verifyQueryResults(query, 0);
    }

    public void testQueryIncludingInstancesWithReadPermissionOnOneProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.disableAuthorization();
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().list().get(0)).getId();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).singleResult();
        ActivityStatisticsAuthorizationTest.assertNotNull((Object)statistics);
        ActivityStatisticsAuthorizationTest.assertEquals((String)"scriptTask", (String)statistics.getId());
        ActivityStatisticsAuthorizationTest.assertEquals((int)1, (int)statistics.getInstances());
        ActivityStatisticsAuthorizationTest.assertEquals((int)0, (int)statistics.getFailedJobs());
        ActivityStatisticsAuthorizationTest.assertTrue((boolean)statistics.getIncidentStatistics().isEmpty());
    }

    public void testQueryIncludingInstancesWithMany() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.disableAuthorization();
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().list().get(0)).getId();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).singleResult();
        ActivityStatisticsAuthorizationTest.assertNotNull((Object)statistics);
        ActivityStatisticsAuthorizationTest.assertEquals((String)"scriptTask", (String)statistics.getId());
        ActivityStatisticsAuthorizationTest.assertEquals((int)1, (int)statistics.getInstances());
        ActivityStatisticsAuthorizationTest.assertEquals((int)0, (int)statistics.getFailedJobs());
        ActivityStatisticsAuthorizationTest.assertTrue((boolean)statistics.getIncidentStatistics().isEmpty());
    }

    public void testQueryIncludingInstancesWithReadPermissionOnAnyProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).singleResult();
        ActivityStatisticsAuthorizationTest.assertNotNull((Object)statistics);
        ActivityStatisticsAuthorizationTest.assertEquals((String)"scriptTask", (String)statistics.getId());
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)statistics.getInstances());
        ActivityStatisticsAuthorizationTest.assertEquals((int)0, (int)statistics.getFailedJobs());
        ActivityStatisticsAuthorizationTest.assertTrue((boolean)statistics.getIncidentStatistics().isEmpty());
    }

    public void testQueryIncludingInstancesWithReadInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).singleResult();
        ActivityStatisticsAuthorizationTest.assertNotNull((Object)statistics);
        ActivityStatisticsAuthorizationTest.assertEquals((String)"scriptTask", (String)statistics.getId());
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)statistics.getInstances());
        ActivityStatisticsAuthorizationTest.assertEquals((int)0, (int)statistics.getFailedJobs());
        ActivityStatisticsAuthorizationTest.assertTrue((boolean)statistics.getIncidentStatistics().isEmpty());
    }

    public void testQueryIncludingFailedJobsWithoutAuthorizationOnProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeFailedJobs().singleResult();
        ActivityStatisticsAuthorizationTest.assertNull((Object)statistics);
    }

    public void testQueryIncludingFailedJobsWithReadPermissionOnOneProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.disableAuthorization();
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().list().get(0)).getId();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeFailedJobs().singleResult();
        ActivityStatisticsAuthorizationTest.assertNotNull((Object)statistics);
        ActivityStatisticsAuthorizationTest.assertEquals((String)"scriptTask", (String)statistics.getId());
        ActivityStatisticsAuthorizationTest.assertEquals((int)1, (int)statistics.getInstances());
        ActivityStatisticsAuthorizationTest.assertEquals((int)1, (int)statistics.getFailedJobs());
        ActivityStatisticsAuthorizationTest.assertTrue((boolean)statistics.getIncidentStatistics().isEmpty());
    }

    public void testQueryIncludingFailedJobsWithReadPermissionOnAnyProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeFailedJobs().singleResult();
        ActivityStatisticsAuthorizationTest.assertNotNull((Object)statistics);
        ActivityStatisticsAuthorizationTest.assertEquals((String)"scriptTask", (String)statistics.getId());
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)statistics.getInstances());
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)statistics.getFailedJobs());
        ActivityStatisticsAuthorizationTest.assertTrue((boolean)statistics.getIncidentStatistics().isEmpty());
    }

    public void testQueryIncludingFailedJobsWithReadInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeFailedJobs().singleResult();
        ActivityStatisticsAuthorizationTest.assertNotNull((Object)statistics);
        ActivityStatisticsAuthorizationTest.assertEquals((String)"scriptTask", (String)statistics.getId());
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)statistics.getInstances());
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)statistics.getFailedJobs());
        ActivityStatisticsAuthorizationTest.assertTrue((boolean)statistics.getIncidentStatistics().isEmpty());
    }

    public void testQueryIncludingIncidentsWithoutAuthorizationOnProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeIncidents().singleResult();
        ActivityStatisticsAuthorizationTest.assertNull((Object)statistics);
    }

    public void testQueryIncludingIncidentsWithReadPermissionOnOneProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.disableAuthorization();
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().list().get(0)).getId();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeIncidents().singleResult();
        ActivityStatisticsAuthorizationTest.assertNotNull((Object)statistics);
        ActivityStatisticsAuthorizationTest.assertEquals((String)"scriptTask", (String)statistics.getId());
        ActivityStatisticsAuthorizationTest.assertEquals((int)1, (int)statistics.getInstances());
        ActivityStatisticsAuthorizationTest.assertEquals((int)0, (int)statistics.getFailedJobs());
        ActivityStatisticsAuthorizationTest.assertFalse((boolean)statistics.getIncidentStatistics().isEmpty());
        IncidentStatistics incidentStatistics = (IncidentStatistics)statistics.getIncidentStatistics().get(0);
        ActivityStatisticsAuthorizationTest.assertEquals((int)1, (int)incidentStatistics.getIncidentCount());
    }

    public void testQueryIncludingIncidentsWithReadPermissionOnAnyProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeIncidents().singleResult();
        ActivityStatisticsAuthorizationTest.assertNotNull((Object)statistics);
        ActivityStatisticsAuthorizationTest.assertEquals((String)"scriptTask", (String)statistics.getId());
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)statistics.getInstances());
        ActivityStatisticsAuthorizationTest.assertEquals((int)0, (int)statistics.getFailedJobs());
        ActivityStatisticsAuthorizationTest.assertFalse((boolean)statistics.getIncidentStatistics().isEmpty());
        IncidentStatistics incidentStatistics = (IncidentStatistics)statistics.getIncidentStatistics().get(0);
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)incidentStatistics.getIncidentCount());
    }

    public void testQueryIncludingIncidentsWithReadInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeIncidents().singleResult();
        ActivityStatisticsAuthorizationTest.assertNotNull((Object)statistics);
        ActivityStatisticsAuthorizationTest.assertEquals((String)"scriptTask", (String)statistics.getId());
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)statistics.getInstances());
        ActivityStatisticsAuthorizationTest.assertEquals((int)0, (int)statistics.getFailedJobs());
        ActivityStatisticsAuthorizationTest.assertFalse((boolean)statistics.getIncidentStatistics().isEmpty());
        IncidentStatistics incidentStatistics = (IncidentStatistics)statistics.getIncidentStatistics().get(0);
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)incidentStatistics.getIncidentCount());
    }

    public void testQueryIncludingIncidentsAndFailedJobsWithoutAuthorizationOnProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeIncidents().includeFailedJobs().singleResult();
        ActivityStatisticsAuthorizationTest.assertNull((Object)statistics);
    }

    public void testQueryIncludingIncidentsAndFailedJobsWithReadPermissionOnOneProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.disableAuthorization();
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().list().get(0)).getId();
        this.enableAuthorization();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, processInstanceId, this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeIncidents().includeFailedJobs().singleResult();
        ActivityStatisticsAuthorizationTest.assertNotNull((Object)statistics);
        ActivityStatisticsAuthorizationTest.assertEquals((String)"scriptTask", (String)statistics.getId());
        ActivityStatisticsAuthorizationTest.assertEquals((int)1, (int)statistics.getInstances());
        ActivityStatisticsAuthorizationTest.assertEquals((int)1, (int)statistics.getFailedJobs());
        ActivityStatisticsAuthorizationTest.assertFalse((boolean)statistics.getIncidentStatistics().isEmpty());
        IncidentStatistics incidentStatistics = (IncidentStatistics)statistics.getIncidentStatistics().get(0);
        ActivityStatisticsAuthorizationTest.assertEquals((int)1, (int)incidentStatistics.getIncidentCount());
    }

    public void testQueryIncludingIncidentsAndFailedJobsWithReadPermissionOnAnyProcessInstance() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeIncidents().includeFailedJobs().singleResult();
        ActivityStatisticsAuthorizationTest.assertNotNull((Object)statistics);
        ActivityStatisticsAuthorizationTest.assertEquals((String)"scriptTask", (String)statistics.getId());
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)statistics.getInstances());
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)statistics.getFailedJobs());
        ActivityStatisticsAuthorizationTest.assertFalse((boolean)statistics.getIncidentStatistics().isEmpty());
        IncidentStatistics incidentStatistics = (IncidentStatistics)statistics.getIncidentStatistics().get(0);
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)incidentStatistics.getIncidentCount());
    }

    public void testQueryIncludingIncidentsAndFailedJobsWithReadInstancePermissionOnProcessDefinition() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        ActivityStatistics statistics = (ActivityStatistics)this.managementService.createActivityStatisticsQuery(processDefinitionId).includeIncidents().includeFailedJobs().singleResult();
        ActivityStatisticsAuthorizationTest.assertNotNull((Object)statistics);
        ActivityStatisticsAuthorizationTest.assertEquals((String)"scriptTask", (String)statistics.getId());
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)statistics.getInstances());
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)statistics.getFailedJobs());
        ActivityStatisticsAuthorizationTest.assertFalse((boolean)statistics.getIncidentStatistics().isEmpty());
        IncidentStatistics incidentStatistics = (IncidentStatistics)statistics.getIncidentStatistics().get(0);
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)incidentStatistics.getIncidentCount());
    }

    public void testManyAuthorizationsActivityStatisticsQueryIncludingFailedJobsAndIncidents() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        this.createGrantAuthorizationGroup((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.groupId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        List statistics = this.managementService.createActivityStatisticsQuery(processDefinitionId).includeFailedJobs().includeIncidents().list();
        ActivityStatisticsAuthorizationTest.assertEquals((int)1, (int)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)activityResult.getInstances());
        ActivityStatisticsAuthorizationTest.assertEquals((String)"scriptTask", (String)activityResult.getId());
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)activityResult.getFailedJobs());
        ActivityStatisticsAuthorizationTest.assertFalse((boolean)activityResult.getIncidentStatistics().isEmpty());
        IncidentStatistics incidentStatistics = (IncidentStatistics)activityResult.getIncidentStatistics().get(0);
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)incidentStatistics.getIncidentCount());
    }

    public void testManyAuthorizationsActivityStatisticsQuery() {
        String processDefinitionId = this.selectProcessDefinitionByKey(ONE_INCIDENT_PROCESS_KEY).getId();
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.userId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        this.createGrantAuthorizationGroup((Resource)Resources.PROCESS_DEFINITION, ONE_INCIDENT_PROCESS_KEY, this.groupId, new Permission[]{Permissions.READ, Permissions.READ_INSTANCE});
        List statistics = this.managementService.createActivityStatisticsQuery(processDefinitionId).list();
        ActivityStatisticsAuthorizationTest.assertEquals((int)1, (int)statistics.size());
        ActivityStatistics activityResult = (ActivityStatistics)statistics.get(0);
        ActivityStatisticsAuthorizationTest.assertEquals((int)3, (int)activityResult.getInstances());
        ActivityStatisticsAuthorizationTest.assertEquals((String)"scriptTask", (String)activityResult.getId());
        ActivityStatisticsAuthorizationTest.assertEquals((int)0, (int)activityResult.getFailedJobs());
        ActivityStatisticsAuthorizationTest.assertTrue((boolean)activityResult.getIncidentStatistics().isEmpty());
    }

    protected void verifyQueryResults(ActivityStatisticsQuery query, int countExpected) {
        this.verifyQueryResults((Query<?, ?>)((AbstractQuery)query), countExpected);
    }
}

