/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.history;

import java.util.Arrays;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.ProcessDefinitionPermissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.cfg.auth.DefaultPermissionProvider;
import org.camunda.bpm.engine.impl.cfg.auth.PermissionProvider;
import org.camunda.bpm.engine.impl.util.StringUtil;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.engine.test.api.identity.TestPermissions;
import org.camunda.bpm.engine.test.api.identity.TestResource;

@RequiredHistoryLevel(value="full")
public class AuthorizationUserOperationLogTest
extends AuthorizationTest {
    public void testLogCreatedOnAuthorizationCreation() {
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        AuthorizationUserOperationLogTest.assertEquals((long)0L, (long)query.count());
        this.createGrantAuthorizationGroup((Resource)Resources.PROCESS_DEFINITION, "*", "testGroupId", new Permission[]{ProcessDefinitionPermissions.DELETE});
        AuthorizationUserOperationLogTest.assertEquals((long)6L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("permissionBits").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Create", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)String.valueOf(ProcessDefinitionPermissions.DELETE.getValue()), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("permissions").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Create", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)ProcessDefinitionPermissions.DELETE.getName(), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("type").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Create", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)String.valueOf(1), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("resource").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Create", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)Resources.PROCESS_DEFINITION.resourceName(), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("resourceId").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Create", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)"*", (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("groupId").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Create", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)"testGroupId", (String)entry.getNewValue());
    }

    public void testLogCreatedOnAuthorizationUpdate() {
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.identityService.clearAuthentication();
        Authorization authorization = this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", "testUserId", new Permission[]{ProcessDefinitionPermissions.DELETE});
        AuthorizationUserOperationLogTest.assertEquals((long)0L, (long)query.count());
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        authorization.addPermission((Permission)ProcessDefinitionPermissions.READ);
        this.saveAuthorization(authorization);
        AuthorizationUserOperationLogTest.assertEquals((long)6L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("permissionBits").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Update", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)String.valueOf(ProcessDefinitionPermissions.DELETE.getValue() | ProcessDefinitionPermissions.READ.getValue()), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("permissions").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Update", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)(ProcessDefinitionPermissions.READ.getName() + ", " + ProcessDefinitionPermissions.DELETE.getName()), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("type").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Update", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)String.valueOf(1), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("resource").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Update", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)Resources.PROCESS_DEFINITION.resourceName(), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("resourceId").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Update", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)"*", (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("userId").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Update", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)"testUserId", (String)entry.getNewValue());
    }

    public void testLogCreatedOnAuthorizationDeletion() {
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        this.identityService.clearAuthentication();
        Authorization authorization = this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", "testUserId", new Permission[]{ProcessDefinitionPermissions.DELETE});
        AuthorizationUserOperationLogTest.assertEquals((long)0L, (long)query.count());
        this.identityService.setAuthentication(this.userId, Arrays.asList(this.groupId));
        this.authorizationService.deleteAuthorization(authorization.getId());
        AuthorizationUserOperationLogTest.assertEquals((long)6L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("permissionBits").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Delete", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)String.valueOf(ProcessDefinitionPermissions.DELETE.getValue()), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("permissions").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Delete", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)ProcessDefinitionPermissions.DELETE.getName(), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("type").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Delete", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)String.valueOf(1), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("resource").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Delete", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)Resources.PROCESS_DEFINITION.resourceName(), (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("resourceId").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Delete", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)"*", (String)entry.getNewValue());
        entry = (UserOperationLogEntry)query.property("userId").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Delete", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)"testUserId", (String)entry.getNewValue());
    }

    public void testLogCreatedOnAuthorizationCreationWithExceedingPermissionStringList() {
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        AuthorizationUserOperationLogTest.assertEquals((long)0L, (long)query.count());
        PermissionProvider permissionProvider = this.processEngineConfiguration.getPermissionProvider();
        this.processEngineConfiguration.setPermissionProvider((PermissionProvider)new TestPermissionProvider());
        this.createGrantAuthorizationGroup(TestResource.RESOURCE1, "*", "testGroupId", TestPermissions.LONG_NAME);
        this.processEngineConfiguration.setPermissionProvider(permissionProvider);
        AuthorizationUserOperationLogTest.assertEquals((long)6L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("permissions").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Create", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)TestPermissions.LONG_NAME.getName().substring(0, StringUtil.DB_MAX_STRING_LENGTH), (String)entry.getNewValue());
    }

    public void testLogCreatedOnAuthorizationCreationWithAllPermission() {
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery();
        AuthorizationUserOperationLogTest.assertEquals((long)0L, (long)query.count());
        PermissionProvider permissionProvider = this.processEngineConfiguration.getPermissionProvider();
        this.processEngineConfiguration.setPermissionProvider((PermissionProvider)new TestPermissionProvider());
        this.createGrantAuthorizationGroup(TestResource.RESOURCE1, "*", "testGroupId", TestPermissions.ALL, TestPermissions.CREATE, TestPermissions.DELETE, TestPermissions.LONG_NAME, TestPermissions.RANDOM);
        this.processEngineConfiguration.setPermissionProvider(permissionProvider);
        AuthorizationUserOperationLogTest.assertEquals((long)6L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("permissions").singleResult();
        AuthorizationUserOperationLogTest.assertEquals((String)"Create", (String)entry.getOperationType());
        AuthorizationUserOperationLogTest.assertEquals((String)"Admin", (String)entry.getCategory());
        AuthorizationUserOperationLogTest.assertEquals((String)"Authorization", (String)entry.getEntityType());
        AuthorizationUserOperationLogTest.assertEquals((String)TestPermissions.ALL.getName(), (String)entry.getNewValue());
    }

    public static class TestPermissionProvider
    extends DefaultPermissionProvider {
        public String getNameForResource(int resourceType) {
            for (TestResource resource : TestResource.values()) {
                if (resourceType != resource.resourceType()) continue;
                return resource.resourceName();
            }
            return null;
        }

        public Permission[] getPermissionsForResource(int resourceType) {
            return TestPermissions.values();
        }
    }
}

