/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.optimize;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.OptimizeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

@RequiredHistoryLevel(value="full")
public class OptimizeDecisionDefinitionServiceAuthorizationTest
extends AuthorizationTest {
    protected String deploymentId;
    private OptimizeService optimizeService;
    public static final String DECISION_PROCESS = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml";
    public static final String DECISION_SINGLE_OUTPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml";

    @Override
    public void setUp() throws Exception {
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)OptimizeDecisionDefinitionServiceAuthorizationTest.getProcessEngine().getProcessEngineConfiguration();
        this.optimizeService = config.getOptimizeService();
        super.setUp();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testGetDecisionInstancesWithoutAuthorization() {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"input1", null);
        this.startProcessInstanceByKey("testProcess", (Map<String, Object>)variables);
        try {
            this.optimizeService.getHistoricDecisionInstances(new Date(0L), null, 10);
            OptimizeDecisionDefinitionServiceAuthorizationTest.fail((String)"Exception expected: It should not be possible to retrieve the decision instances");
        }
        catch (AuthorizationException e) {
            String exceptionMessage = e.getMessage();
            this.assertTextPresent(this.userId, exceptionMessage);
            this.assertTextPresent(Permissions.READ_HISTORY.getName(), exceptionMessage);
            this.assertTextPresent(Resources.DECISION_DEFINITION.resourceName(), exceptionMessage);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testGetDecisionInstancesWithAuthorization() {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"input1", null);
        this.startProcessInstanceByKey("testProcess", (Map<String, Object>)variables);
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_HISTORY});
        List decisionInstances = this.optimizeService.getHistoricDecisionInstances(new Date(0L), null, 10);
        MatcherAssert.assertThat((Object)decisionInstances.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testAuthorizationsOnSingleDecisionDefinitionIsNotEnough() {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"input1", null);
        this.startProcessInstanceByKey("testProcess", (Map<String, Object>)variables);
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "testProcess", this.userId, new Permission[]{Permissions.READ_HISTORY});
        try {
            this.optimizeService.getHistoricDecisionInstances(new Date(0L), null, 10);
            OptimizeDecisionDefinitionServiceAuthorizationTest.fail((String)"Exception expected: It should not be possible to retrieve the decision instances");
        }
        catch (AuthorizationException e) {
            String exceptionMessage = e.getMessage();
            this.assertTextPresent(this.userId, exceptionMessage);
            this.assertTextPresent(Permissions.READ_HISTORY.getName(), exceptionMessage);
            this.assertTextPresent(Resources.DECISION_DEFINITION.resourceName(), exceptionMessage);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    public void testGrantAuthorizationWithAllPermissions() {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"input1", null);
        this.startProcessInstanceByKey("testProcess", (Map<String, Object>)variables);
        this.createGrantAuthorization((Resource)Resources.DECISION_DEFINITION, "*", this.userId, new Permission[]{Permissions.ALL});
        List decisionInstances = this.optimizeService.getHistoricDecisionInstances(new Date(0L), null, 10);
        MatcherAssert.assertThat((Object)decisionInstances.size(), (Matcher)CoreMatchers.is((Object)1));
    }
}

