/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cfg;

import java.util.Map;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.HistoryLevelSetupCommand;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.SchemaOperationsProcessEngineBuild;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class DatabaseHistoryPropertyTest {
    private static ProcessEngineImpl processEngineImpl;

    @After
    public void cleanup() {
        TestHelper.dropSchema((ProcessEngineConfigurationImpl)processEngineImpl.getProcessEngineConfiguration());
        processEngineImpl.close();
        processEngineImpl = null;
    }

    @Test
    public void schemaCreatedByEngineAndDatabaseSchemaUpdateTrue() {
        processEngineImpl = DatabaseHistoryPropertyTest.createProcessEngineImpl("true", true);
        this.assertHistoryLevel();
    }

    @Test
    public void schemaCreatedByUserAndDatabaseSchemaUpdateTrue() {
        processEngineImpl = DatabaseHistoryPropertyTest.createProcessEngineImpl("true", false);
        TestHelper.createSchema((ProcessEngineConfigurationImpl)processEngineImpl.getProcessEngineConfiguration());
        processEngineImpl.getProcessEngineConfiguration().getCommandExecutorSchemaOperations().execute((Command)new SchemaOperationsProcessEngineBuild());
        processEngineImpl.getProcessEngineConfiguration().getCommandExecutorSchemaOperations().execute((Command)new HistoryLevelSetupCommand());
        this.assertHistoryLevel();
    }

    @Test
    public void schemaCreatedByUserAndDatabaseSchemaUpdateFalse() {
        processEngineImpl = DatabaseHistoryPropertyTest.createProcessEngineImpl("false", false);
        TestHelper.createSchema((ProcessEngineConfigurationImpl)processEngineImpl.getProcessEngineConfiguration());
        processEngineImpl.getProcessEngineConfiguration().getCommandExecutorSchemaOperations().execute((Command)new SchemaOperationsProcessEngineBuild());
        processEngineImpl.getProcessEngineConfiguration().getCommandExecutorSchemaOperations().execute((Command)new HistoryLevelSetupCommand());
        this.assertHistoryLevel();
    }

    private void assertHistoryLevel() {
        Map properties = processEngineImpl.getManagementService().getProperties();
        String historyLevel = (String)properties.get("historyLevel");
        Assert.assertNotNull((String)"historyLevel is null -> not set in database", (Object)historyLevel);
        Assert.assertEquals((long)ProcessEngineConfigurationImpl.HISTORYLEVEL_FULL, (long)Integer.parseInt(historyLevel));
    }

    private static ProcessEngineImpl createProcessEngineImpl(String databaseSchemaUpdate, boolean executeSchemaOperations) {
        ProcessEngineImpl processEngine = (ProcessEngineImpl)new CustomStandaloneInMemProcessEngineConfiguration().setExecuteSchemaOperations(executeSchemaOperations).setProcessEngineName("database-history-test-engine").setDatabaseSchemaUpdate(databaseSchemaUpdate).setHistory("full").setJdbcUrl("jdbc:h2:mem:DatabaseHistoryPropertyTest").buildProcessEngine();
        return processEngine;
    }

    private static class CustomStandaloneInMemProcessEngineConfiguration
    extends StandaloneInMemProcessEngineConfiguration {
        boolean executeSchemaOperations;

        private CustomStandaloneInMemProcessEngineConfiguration() {
        }

        public ProcessEngine buildProcessEngine() {
            this.init();
            if (this.executeSchemaOperations) {
                return new CreateSchemaProcessEngineImpl((ProcessEngineConfigurationImpl)this);
            }
            return new CreateNoSchemaProcessEngineImpl((ProcessEngineConfigurationImpl)this);
        }

        public ProcessEngineConfigurationImpl setExecuteSchemaOperations(boolean executeSchemaOperations) {
            this.executeSchemaOperations = executeSchemaOperations;
            return this;
        }
    }

    private static class CreateNoSchemaProcessEngineImpl
    extends ProcessEngineImpl {
        public CreateNoSchemaProcessEngineImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
            super(processEngineConfiguration);
        }

        protected void executeSchemaOperations() {
        }
    }

    private static class CreateSchemaProcessEngineImpl
    extends ProcessEngineImpl {
        public CreateSchemaProcessEngineImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
            super(processEngineConfiguration);
        }

        protected void executeSchemaOperations() {
            super.executeSchemaOperations();
        }
    }
}

