/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cfg;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.StandaloneInMemProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.db.sql.DbSqlSession;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.ReflectUtil;

public class DatabaseTableSchemaTest
extends TestCase {
    private static final String SCHEMA_NAME = "SCHEMA1";
    private static final String PREFIX_NAME = "PREFIX1_";

    public void testPerformDatabaseSchemaOperationCreateTwice() throws Exception {
        PooledDataSource pooledDataSource = new PooledDataSource(ReflectUtil.getClassLoader(), "org.h2.Driver", "jdbc:h2:mem:DatabaseTablePrefixTest;DB_CLOSE_DELAY=1000", "sa", "");
        Connection connection = pooledDataSource.getConnection();
        connection.createStatement().execute("drop schema if exists SCHEMA1");
        connection.createStatement().execute("create schema SCHEMA1");
        connection.close();
        ProcessEngineConfigurationImpl config1 = DatabaseTableSchemaTest.createCustomProcessEngineConfiguration().setProcessEngineName("DatabaseTablePrefixTest-engine1").setDataSource((DataSource)pooledDataSource).setDatabaseSchemaUpdate("NO_CHECK");
        config1.setDatabaseTablePrefix("SCHEMA1.");
        config1.setDatabaseSchema(SCHEMA_NAME);
        config1.setDbMetricsReporterActivate(false);
        ProcessEngine engine1 = config1.buildProcessEngine();
        connection = pooledDataSource.getConnection();
        connection.createStatement().execute("set schema SCHEMA1");
        engine1.getManagementService().databaseSchemaUpgrade(connection, "", SCHEMA_NAME);
        connection.close();
        connection = pooledDataSource.getConnection();
        connection.createStatement().execute("set schema SCHEMA1");
        engine1.getManagementService().databaseSchemaUpgrade(connection, "", SCHEMA_NAME);
        engine1.close();
    }

    public void testTablePresentWithSchemaAndPrefix() throws SQLException {
        PooledDataSource pooledDataSource = new PooledDataSource(ReflectUtil.getClassLoader(), "org.h2.Driver", "jdbc:h2:mem:DatabaseTablePrefixTest;DB_CLOSE_DELAY=1000", "sa", "");
        Connection connection = pooledDataSource.getConnection();
        connection.createStatement().execute("drop schema if exists SCHEMA1");
        connection.createStatement().execute("create schema SCHEMA1");
        connection.createStatement().execute("create table SCHEMA1.PREFIX1_SOME_TABLE(id varchar(64));");
        connection.close();
        ProcessEngineConfigurationImpl config1 = DatabaseTableSchemaTest.createCustomProcessEngineConfiguration().setProcessEngineName("DatabaseTablePrefixTest-engine1").setDataSource((DataSource)pooledDataSource).setDatabaseSchemaUpdate("NO_CHECK");
        config1.setDatabaseTablePrefix("SCHEMA1.PREFIX1_");
        config1.setDatabaseSchema(SCHEMA_NAME);
        config1.setDbMetricsReporterActivate(false);
        ProcessEngine engine = config1.buildProcessEngine();
        CommandExecutor commandExecutor = config1.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                DbSqlSession sqlSession = (DbSqlSession)commandContext.getSession(DbSqlSession.class);
                TestCase.assertTrue((boolean)sqlSession.isTablePresent("SOME_TABLE"));
                return null;
            }
        });
        engine.close();
    }

    public void testCreateConfigurationWithMismatchtingSchemaAndPrefix() {
        try {
            StandaloneInMemProcessEngineConfiguration configuration = new StandaloneInMemProcessEngineConfiguration();
            configuration.setDatabaseSchema("foo");
            configuration.setDatabaseTablePrefix("bar");
            configuration.buildProcessEngine();
            DatabaseTableSchemaTest.fail((String)"Should throw exception");
        }
        catch (ProcessEngineException e) {
            DatabaseTableSchemaTest.assertTrue((boolean)e.getMessage().contains("When setting a schema the prefix has to be schema + '.'"));
        }
    }

    public void testCreateConfigurationWithMissingDotInSchemaAndPrefix() {
        try {
            StandaloneInMemProcessEngineConfiguration configuration = new StandaloneInMemProcessEngineConfiguration();
            configuration.setDatabaseSchema("foo");
            configuration.setDatabaseTablePrefix("foo");
            configuration.buildProcessEngine();
            DatabaseTableSchemaTest.fail((String)"Should throw exception");
        }
        catch (ProcessEngineException e) {
            DatabaseTableSchemaTest.assertTrue((boolean)e.getMessage().contains("When setting a schema the prefix has to be schema + '.'"));
        }
    }

    private static ProcessEngineConfigurationImpl createCustomProcessEngineConfiguration() {
        return new CustomStandaloneInMemProcessEngineConfiguration().setHistory("full");
    }

    private static class CustomStandaloneInMemProcessEngineConfiguration
    extends StandaloneInMemProcessEngineConfiguration {
        private CustomStandaloneInMemProcessEngineConfiguration() {
        }

        public ProcessEngine buildProcessEngine() {
            this.init();
            return new NoSchemaProcessEngineImpl((ProcessEngineConfigurationImpl)this);
        }

        class NoSchemaProcessEngineImpl
        extends ProcessEngineImpl {
            public NoSchemaProcessEngineImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
                super(processEngineConfiguration);
            }

            protected void executeSchemaOperations() {
            }
        }
    }
}

