/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cfg;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="audit")
public class PersistenceExceptionTest {
    public ProcessEngineRule engineRule = new ProcessEngineRule(true);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    private RuntimeService runtimeService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Test
    public void testPersistenceExceptionContainsRealCause() {
        Assume.assumeFalse((boolean)this.engineRule.getProcessEngineConfiguration().getDatabaseType().equals("mariadb"));
        StringBuffer longString = new StringBuffer();
        for (int i = 0; i < 100; ++i) {
            longString.append("tensymbols");
        }
        BpmnModelInstance modelInstance = Bpmn.createExecutableProcess((String)"process1").startEvent().userTask(longString.toString()).endEvent().done();
        this.testRule.deploy(modelInstance);
        try {
            this.runtimeService.startProcessInstanceByKey("process1").getId();
            Assert.fail((String)"persistence exception is expected");
        }
        catch (ProcessEngineException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("insertHistoricTaskInstanceEvent"));
        }
    }
}

