/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cmmn;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;

public class CaseServiceHumanTaskTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    public void testManualStart() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
        Task task = (Task)this.taskService.createTaskQuery().caseExecutionId(caseExecutionId).singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    public void testManualStartWithVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
        Task task = (Task)this.taskService.createTaskQuery().caseExecutionId(caseExecutionId).singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceHumanTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceHumanTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    public void testManualStartWithVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariables(variables).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
        Task task = (Task)this.taskService.createTaskQuery().caseExecutionId(caseExecutionId).singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceHumanTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceHumanTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testStart() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
        Task task = (Task)this.taskService.createTaskQuery().caseExecutionId(caseExecutionId).singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testStartWithVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        VariableMap variableMap = Variables.createVariables().putValue("aVariableName", (Object)"abc").putValue("anotherVariableName", (Object)999);
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).setVariables((Map)variableMap).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
        Task task = (Task)this.taskService.createTaskQuery().caseExecutionId(caseExecutionId).singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceHumanTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceHumanTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testStartWithVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).setVariables(variables).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
        Task task = (Task)this.taskService.createTaskQuery().caseExecutionId(caseExecutionId).singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceHumanTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceHumanTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    public void testManualStartWithLocalVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
        Task task = (Task)this.taskService.createTaskQuery().caseExecutionId(caseExecutionId).singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceHumanTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceHumanTaskTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceHumanTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    public void testManualStartWithLocalVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariablesLocal(variables).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
        Task task = (Task)this.taskService.createTaskQuery().caseExecutionId(caseExecutionId).singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceHumanTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceHumanTaskTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceHumanTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testReenableAnEnabledHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).reenable();
            CaseServiceHumanTaskTest.fail((String)"It should not be possible to re-enable an enabled human task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testReenableAnDisabledHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        this.caseService.withCaseExecution(caseExecutionId).reenable();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isDisabled());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testReenableAnActiveHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).reenable();
            CaseServiceHumanTaskTest.fail((String)"It should not be possible to re-enable an active human task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testDisableAnEnabledHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isDisabled());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testDisableADisabledHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        try {
            this.caseService.withCaseExecution(caseExecutionId).disable();
            CaseServiceHumanTaskTest.fail((String)"It should not be possible to disable a already disabled human task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testDisableAnActiveHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).disable();
            CaseServiceHumanTaskTest.fail((String)"It should not be possible to disable an active human task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testManualStartOfADisabledHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        try {
            this.caseService.withCaseExecution(caseExecutionId).manualStart();
            CaseServiceHumanTaskTest.fail((String)"It should not be possible to start a disabled human task manually.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testManualStartOfAnActiveHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).manualStart();
            CaseServiceHumanTaskTest.fail((String)"It should not be possible to start an already active human task manually.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testComplete() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        this.caseService.withCaseExecution(caseExecutionId).complete();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)task);
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().active().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceHumanTaskTest.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCompleteShouldCompleteCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        this.caseService.withCaseExecution(caseExecutionId).complete();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)task);
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceHumanTaskTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    public void testCompleteShouldCompleteCaseInstanceViaTaskService() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)task);
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceHumanTaskTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    public void testDisableShouldCompleteCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceHumanTaskTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    public void testCompleteAnEnabledHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).complete();
            CaseServiceHumanTaskTest.fail((String)"Should not be able to complete task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testCompleteADisabledHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        try {
            this.caseService.withCaseExecution(caseExecutionId).complete();
            CaseServiceHumanTaskTest.fail((String)"Should not be able to complete task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testCompleteWithSetVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        this.caseService.withCaseExecution(caseExecutionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).complete();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)task);
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().active().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceHumanTaskTest.assertTrue((boolean)caseInstance.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceHumanTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceHumanTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceHumanTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceHumanTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testCompleteWithSetVariableLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).complete();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)task);
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().active().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceHumanTaskTest.assertTrue((boolean)caseInstance.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testCompleteWithRemoveVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        this.caseService.withCaseExecution(caseExecutionId).removeVariable("aVariableName").removeVariable("anotherVariableName").complete();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)task);
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().active().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceHumanTaskTest.assertTrue((boolean)caseInstance.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testCompleteWithRemoveVariableLocal() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        this.caseService.withCaseExecution(caseExecutionId).removeVariableLocal("aVariableName").removeVariableLocal("anotherVariableName").complete();
        task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)task);
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().active().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceHumanTaskTest.assertTrue((boolean)caseInstance.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceHumanTaskTest.assertTrue((boolean)result.isEmpty());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testClose() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).close();
            CaseServiceHumanTaskTest.fail((String)"It should not be possible to close a task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testTerminate() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecution taskExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        this.caseService.withCaseExecution(taskExecution.getId()).terminate();
        taskExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        CaseServiceHumanTaskTest.assertNull((Object)taskExecution);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testTerminateNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecution taskExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        this.caseService.terminateCaseExecution(taskExecution.getId());
        taskExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        CaseServiceHumanTaskTest.assertNull((Object)taskExecution);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithManualActivation.cmmn"})
    public void testTerminateNonActiveHumanTask() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecution taskExecution = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        try {
            this.caseService.terminateCaseExecution(taskExecution.getId());
            CaseServiceHumanTaskTest.fail((String)"It should not be possible to terminate a task.");
        }
        catch (NotAllowedException e) {
            boolean result = e.getMessage().contains("The case execution must be in state 'active' to terminate");
            CaseServiceHumanTaskTest.assertTrue((boolean)result);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testManualStartNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
        Task task = (Task)this.taskService.createTaskQuery().caseExecutionId(caseExecutionId).singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testManualStartWithVariablesNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aVariable", "aValue");
        this.caseService.manuallyStartCaseExecution(caseExecutionId, variables);
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
        Task task = (Task)this.taskService.createTaskQuery().caseExecutionId(caseExecutionId).singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)variable);
        CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
        CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
        CaseServiceHumanTaskTest.assertEquals((String)"aVariable", (String)variable.getName());
        CaseServiceHumanTaskTest.assertEquals((Object)"aValue", (Object)variable.getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testDisableNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.disableCaseExecution(caseExecutionId);
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isDisabled());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testDisableNonFluentWithVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aVariable", "aValue");
        this.caseService.disableCaseExecution(caseExecutionId, variables);
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isDisabled());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isEnabled());
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)variable);
        CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
        CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
        CaseServiceHumanTaskTest.assertEquals((String)"aVariable", (String)variable.getName());
        CaseServiceHumanTaskTest.assertEquals((Object)"aValue", (Object)variable.getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testReenableNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        this.caseService.reenableCaseExecution(caseExecutionId);
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isDisabled());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testReenableNonFluentWithVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aVariable", "aValue");
        this.caseService.reenableCaseExecution(caseExecutionId, variables);
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isDisabled());
        CaseServiceHumanTaskTest.assertFalse((boolean)caseExecution.isActive());
        CaseServiceHumanTaskTest.assertTrue((boolean)caseExecution.isEnabled());
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)variable);
        CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
        CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
        CaseServiceHumanTaskTest.assertEquals((String)"aVariable", (String)variable.getName());
        CaseServiceHumanTaskTest.assertEquals((Object)"aValue", (Object)variable.getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testCompleteNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        this.caseService.completeCaseExecution(caseExecutionId);
        task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)task);
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().active().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceHumanTaskTest.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/twoTaskCase.cmmn"})
    public void testCompleteWithVariablesNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)task);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aVariable", "aValue");
        this.caseService.completeCaseExecution(caseExecutionId, variables);
        CaseServiceHumanTaskTest.assertNull((Object)this.taskService.createTaskQuery().singleResult());
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceHumanTaskTest.assertNull((Object)caseExecution);
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        CaseServiceHumanTaskTest.assertNotNull((Object)variable);
        CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
        CaseServiceHumanTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
        CaseServiceHumanTaskTest.assertEquals((String)"aVariable", (String)variable.getName());
        CaseServiceHumanTaskTest.assertEquals((Object)"aValue", (Object)variable.getValue());
    }

    protected CaseExecution queryCaseExecutionByActivityId(String activityId) {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(activityId).singleResult();
    }
}

