/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cmmn;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.Deployment;

public class CaseServiceStageTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testStartAutomated() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceStageTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isEnabled());
        this.verifyTasksState(caseExecutionQuery);
    }

    protected void verifyTasksState(CaseExecutionQuery caseExecutionQuery) {
        CaseExecution firstHumanTask = (CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_1").singleResult();
        CaseServiceStageTest.assertNotNull((Object)firstHumanTask);
        CaseServiceStageTest.assertTrue((boolean)firstHumanTask.isActive());
        CaseServiceStageTest.assertFalse((boolean)firstHumanTask.isEnabled());
        CaseExecution secondHumanTask = (CaseExecution)caseExecutionQuery.activityId("PI_HumanTask_2").singleResult();
        CaseServiceStageTest.assertNotNull((Object)secondHumanTask);
        CaseServiceStageTest.assertTrue((boolean)secondHumanTask.isActive());
        CaseServiceStageTest.assertFalse((boolean)secondHumanTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCaseWithManualActivation.cmmn"})
    public void testManualStart() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceStageTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isEnabled());
        this.verifyTasksState(caseExecutionQuery);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCaseWithManualActivation.cmmn"})
    public void testManualStartWithVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceStageTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isEnabled());
        this.verifyTasksState(caseExecutionQuery);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        this.verifyVariables(caseInstanceId, caseInstanceId, result);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCaseWithManualActivation.cmmn"})
    public void testManualWithVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariables(variables).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceStageTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isEnabled());
        this.verifyTasksState(caseExecutionQuery);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        this.verifyVariables(caseInstanceId, caseInstanceId, result);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCaseWithManualActivation.cmmn"})
    public void testManualStartWithLocalVariable() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceStageTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isEnabled());
        this.verifyTasksState(caseExecutionQuery);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        this.verifyVariables(caseInstanceId, caseExecutionId, result);
    }

    protected void verifyVariables(String caseInstanceId, String caseExecutionId, List<VariableInstance> result) {
        CaseServiceStageTest.assertFalse((boolean)result.isEmpty());
        CaseServiceStageTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceStageTest.assertEquals((String)caseExecutionId, (String)variable.getCaseExecutionId());
            CaseServiceStageTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceStageTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceStageTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceStageTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceStageTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceStageTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCaseWithManualActivation.cmmn"})
    public void testManualStartWithLocalVariables() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        String caseInstanceId = this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(caseExecutionId).setVariablesLocal(variables).manualStart();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceStageTest.assertTrue((boolean)caseExecution.isActive());
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isEnabled());
        this.verifyTasksState(caseExecutionQuery);
        List result = this.runtimeService.createVariableInstanceQuery().list();
        this.verifyVariables(caseInstanceId, caseExecutionId, result);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testReenableAnEnabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).reenable();
            CaseServiceStageTest.fail((String)"It should not be possible to re-enable an enabled stage.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageWithManualActivationCase.cmmn"})
    public void testReenableAnDisabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        this.caseService.withCaseExecution(caseExecutionId).reenable();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isDisabled());
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isActive());
        CaseServiceStageTest.assertTrue((boolean)caseExecution.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testReenableAnActiveStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).reenable();
            CaseServiceStageTest.fail((String)"It should not be possible to re-enable an active human task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageWithManualActivationCase.cmmn"})
    public void testDisableAnEnabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        CaseExecution caseExecution = (CaseExecution)caseExecutionQuery.singleResult();
        CaseServiceStageTest.assertTrue((boolean)caseExecution.isDisabled());
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isActive());
        CaseServiceStageTest.assertFalse((boolean)caseExecution.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageWithManualActivationCase.cmmn"})
    public void testDisableADisabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecutionQuery caseExecutionQuery = this.caseService.createCaseExecutionQuery();
        String caseExecutionId = ((CaseExecution)caseExecutionQuery.activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        try {
            this.caseService.withCaseExecution(caseExecutionId).disable();
            CaseServiceStageTest.fail((String)"It should not be possible to disable a already disabled human task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testDisableAnActiveStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).disable();
            CaseServiceStageTest.fail((String)"It should not be possible to disable an active human task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageWithManualActivationCase.cmmn"})
    public void testManualStartOfADisabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        try {
            this.caseService.withCaseExecution(caseExecutionId).manualStart();
            CaseServiceStageTest.fail((String)"It should not be possible to start a disabled human task manually.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testManualStartOfAnActiveStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).manualStart();
            CaseServiceStageTest.fail((String)"It should not be possible to start an already active human task manually.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCaseWithManualActivation.cmmn"})
    public void testDisableShouldCompleteCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        CaseServiceStageTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        CaseServiceStageTest.assertNotNull((Object)caseInstance);
        CaseServiceStageTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testCompleteShouldCompleteCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(this.queryCaseExecutionByActivityId("PI_HumanTask_1").getId()).complete();
        this.caseService.withCaseExecution(this.queryCaseExecutionByActivityId("PI_HumanTask_2").getId()).complete();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        CaseServiceStageTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        CaseServiceStageTest.assertNotNull((Object)caseInstance);
        CaseServiceStageTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageCase.cmmn"})
    public void testComplete() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(this.queryCaseExecutionByActivityId("PI_HumanTask_11").getId()).complete();
        this.caseService.withCaseExecution(this.queryCaseExecutionByActivityId("PI_HumanTask_2").getId()).complete();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        CaseServiceStageTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().active().singleResult();
        CaseServiceStageTest.assertNotNull((Object)caseInstance);
        CaseServiceStageTest.assertTrue((boolean)caseInstance.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testCompleteEnabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).complete();
            CaseServiceStageTest.fail((String)"Should not be able to complete stage.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskAndOneStageWithManualActivationCase.cmmn"})
    public void testCompleteDisabledStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        this.caseService.withCaseExecution(caseExecutionId).disable();
        try {
            this.caseService.withCaseExecution(caseExecutionId).complete();
            CaseServiceStageTest.fail((String)"Should not be able to complete stage.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/emptyStageCase.cmmn"})
    public void testAutoCompletionOfEmptyStage() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult();
        CaseServiceStageTest.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        CaseServiceStageTest.assertNotNull((Object)caseInstance);
        CaseServiceStageTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testClose() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_Stage_1").singleResult()).getId();
        try {
            this.caseService.withCaseExecution(caseExecutionId).close();
            CaseServiceStageTest.fail((String)"It should not be possible to close a stage.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testTerminate() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecution stageExecution = this.queryCaseExecutionByActivityId("PI_Stage_1");
        CaseExecution humanTaskExecution1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        CaseServiceStageTest.assertTrue((boolean)humanTaskExecution1.isActive());
        CaseExecution humanTaskExecution2 = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        CaseServiceStageTest.assertTrue((boolean)humanTaskExecution2.isActive());
        this.caseService.withCaseExecution(stageExecution.getId()).terminate();
        stageExecution = this.queryCaseExecutionByActivityId("PI_Stage_1");
        CaseServiceStageTest.assertNull((Object)stageExecution);
        humanTaskExecution1 = this.queryCaseExecutionByActivityId("PI_HumanTask_1");
        CaseServiceStageTest.assertNull((Object)humanTaskExecution1);
        humanTaskExecution2 = this.queryCaseExecutionByActivityId("PI_HumanTask_2");
        CaseServiceStageTest.assertNull((Object)humanTaskExecution2);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCase.cmmn"})
    public void testTerminateNonFluent() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecution stageExecution = this.queryCaseExecutionByActivityId("PI_Stage_1");
        this.caseService.terminateCaseExecution(stageExecution.getId());
        stageExecution = this.queryCaseExecutionByActivityId("PI_Stage_1");
        CaseServiceStageTest.assertNull((Object)stageExecution);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneStageCaseWithManualActivation.cmmn"})
    public void testTerminateWithNonActiveState() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create().getId();
        CaseExecution stageExecution = this.queryCaseExecutionByActivityId("PI_Stage_1");
        try {
            this.caseService.terminateCaseExecution(stageExecution.getId());
            CaseServiceStageTest.fail((String)"It should not be possible to terminate a task.");
        }
        catch (NotAllowedException e) {
            boolean result = e.getMessage().contains("The case execution must be in state 'active' to terminate");
            CaseServiceStageTest.assertTrue((boolean)result);
        }
    }

    protected CaseExecution queryCaseExecutionByActivityId(String activityId) {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(activityId).singleResult();
    }
}

