/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.batch.history.HistoricBatchEntity;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.metrics.Meter;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricBatchManager;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoricInstanceForCleanupQueryTest {
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected MigrationTestRule migrationRule = new MigrationTestRule(this.engineRule);
    protected BatchMigrationHelper helper = new BatchMigrationHelper(this.engineRule, this.migrationRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule).around((TestRule)this.migrationRule);
    private HistoryService historyService;
    private ManagementService managementService;
    private CaseService caseService;
    private ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void init() {
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.caseService = this.engineRule.getCaseService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @After
    public void clearDatabase() {
        this.helper.removeAllRunningAndHistoricBatches();
        this.clearMetrics();
    }

    protected void clearMetrics() {
        Collection meters = this.processEngineConfiguration.getMetricsRegistry().getMeters().values();
        for (Meter meter : meters) {
            meter.getAndClear();
        }
        this.managementService.deleteMetrics(null);
    }

    @Test
    public void testSortHistoricBatchesForCleanup() {
        Date startDate = ClockUtil.getCurrentTime();
        int daysInThePast = -11;
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)daysInThePast));
        List<Batch> list = Arrays.asList(this.helper.migrateProcessInstancesAsync(1), this.helper.migrateProcessInstancesAsync(1), this.helper.migrateProcessInstancesAsync(1));
        String batchType = list.get(0).getType();
        HashedMap batchOperationsMap = new HashedMap();
        batchOperationsMap.put(batchType, 4);
        for (Batch batch : list) {
            this.helper.executeSeedJob(batch);
            this.helper.executeJobs(batch);
            ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)startDate, (int)(++daysInThePast)));
            this.helper.executeMonitorJob(batch);
        }
        ClockUtil.setCurrentTime((Date)new Date());
        List historicList = this.historyService.createHistoricBatchQuery().list();
        Assert.assertEquals((long)3L, (long)historicList.size());
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>((Map)batchOperationsMap){
            final /* synthetic */ Map val$batchOperationsMap;
            {
                this.val$batchOperationsMap = map;
            }

            public Void execute(CommandContext commandContext) {
                HistoricBatchManager historicBatchManager = commandContext.getHistoricBatchManager();
                List ids = historicBatchManager.findHistoricBatchIdsForCleanup(Integer.valueOf(7), this.val$batchOperationsMap, 0, 59);
                Assert.assertEquals((long)3L, (long)ids.size());
                HistoricBatchEntity instance0 = historicBatchManager.findHistoricBatchById((String)ids.get(0));
                HistoricBatchEntity instance1 = historicBatchManager.findHistoricBatchById((String)ids.get(1));
                HistoricBatchEntity instance2 = historicBatchManager.findHistoricBatchById((String)ids.get(2));
                Assert.assertTrue((boolean)instance0.getEndTime().before(instance1.getEndTime()));
                Assert.assertTrue((boolean)instance1.getEndTime().before(instance2.getEndTime()));
                return null;
            }
        });
    }
}

