/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@RequiredHistoryLevel(value="full")
public class HistoryCleanupBatchWindowForEveryDayTest {
    protected String defaultStartTime;
    protected String defaultEndTime;
    protected int defaultBatchSize;
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setHistoryCleanupBatchSize(20);
            configuration.setHistoryCleanupBatchThreshold(10);
            configuration.setDefaultNumberOfRetries(5);
            return configuration;
        }
    };
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);
    private HistoryService historyService;
    private ManagementService managementService;
    private ProcessEngineConfigurationImpl processEngineConfiguration;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    @Parameterized.Parameter(value=0)
    public String startTime;
    @Parameterized.Parameter(value=1)
    public String endTime;
    @Parameterized.Parameter(value=2)
    public Date startDateForCheck;
    @Parameterized.Parameter(value=3)
    public Date endDateForCheck;
    @Parameterized.Parameter(value=4)
    public Date currentDate;

    @Parameterized.Parameters
    public static Collection<Object[]> scenarios() throws ParseException {
        return Arrays.asList({"22:00", "23:00", sdf.parse("2017-09-06T22:00:00"), sdf.parse("2017-09-06T23:00:00"), sdf.parse("2017-09-06T22:15:00")}, {"23:00", "01:00", sdf.parse("2017-09-06T23:00:00"), sdf.parse("2017-09-07T01:00:00"), sdf.parse("2017-09-07T00:15:00")}, {"00:00", "00:00", sdf.parse("2017-09-06T00:00:00"), sdf.parse("2017-09-07T00:00:00"), sdf.parse("2017-09-06T15:00:00")}, {"00:00", "00:00", sdf.parse("2017-09-06T00:00:00"), sdf.parse("2017-09-07T00:00:00"), sdf.parse("2017-09-06T00:00:00")}, {"22:00", "23:00", sdf.parse("2017-09-06T22:00:00"), sdf.parse("2017-09-06T23:00:00"), sdf.parse("2017-09-06T21:15:00")}, {"22:00", "23:00", sdf.parse("2017-09-07T22:00:00"), sdf.parse("2017-09-07T23:00:00"), sdf.parse("2017-09-06T23:15:00")}, {"22:00", "23:00", sdf.parse("2017-09-07T22:00:00"), sdf.parse("2017-09-07T23:00:00"), sdf.parse("2017-09-07T00:15:00")});
    }

    @Before
    public void init() {
        this.historyService = this.engineRule.getHistoryService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.managementService = this.engineRule.getManagementService();
        this.defaultStartTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowStartTime();
        this.defaultEndTime = this.processEngineConfiguration.getHistoryCleanupBatchWindowEndTime();
        this.defaultBatchSize = this.processEngineConfiguration.getHistoryCleanupBatchSize();
    }

    @After
    public void clearDatabase() {
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(this.defaultStartTime);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(this.defaultEndTime);
        this.processEngineConfiguration.setHistoryCleanupBatchSize(this.defaultBatchSize);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List jobs = HistoryCleanupBatchWindowForEveryDayTest.this.managementService.createJobQuery().list();
                if (jobs.size() > 0) {
                    Assert.assertEquals((long)1L, (long)jobs.size());
                    String jobId = ((Job)jobs.get(0)).getId();
                    commandContext.getJobManager().deleteJob((JobEntity)jobs.get(0));
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                }
                return null;
            }
        });
    }

    @Test
    public void testScheduleJobForBatchWindow() throws ParseException {
        ClockUtil.setCurrentTime((Date)this.currentDate);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowStartTime(this.startTime);
        this.processEngineConfiguration.setHistoryCleanupBatchWindowEndTime(this.endTime);
        this.processEngineConfiguration.initHistoryCleanup();
        Job job = this.historyService.cleanUpHistoryAsync();
        Assert.assertFalse((boolean)this.startDateForCheck.after(job.getDuedate()));
        Assert.assertTrue((boolean)this.endDateForCheck.after(job.getDuedate()));
    }
}

