/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.batch;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.SetRemovalTimeToHistoricProcessInstancesAsyncBuilder;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.history.removaltime.batch.helper.BatchSetRemovalTimeRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class BatchSetRemovalTimeTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule engineTestRule = new ProcessEngineTestRule(this.engineRule);
    protected BatchSetRemovalTimeRule testRule = new BatchSetRemovalTimeRule(this.engineRule, this.engineTestRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.engineTestRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected final Date CURRENT_DATE;
    protected final Date REMOVAL_TIME;
    protected RuntimeService runtimeService;
    protected HistoryService historyService;

    public BatchSetRemovalTimeTest() {
        this.CURRENT_DATE = this.testRule.CURRENT_DATE;
        this.REMOVAL_TIME = this.testRule.REMOVAL_TIME;
    }

    @Before
    public void assignServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldNotSetRemovalTime_DmnDisabled() {
        this.testRule.getProcessEngineConfiguration().setDmnEnabled(false);
        this.testRule.process().ruleTask("dish-decision").deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).absoluteRemovalTime(this.REMOVAL_TIME).executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldNotSetRemovalTimeInHierarchy_DmnDisabled() {
        this.testRule.getProcessEngineConfiguration().setDmnEnabled(false);
        this.testRule.process().call().passVars("temperature", "dayType").ruleTask("dish-decision").deploy().startWithVariables((Map<String, Object>)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).calculatedRemovalTime().hierarchical().executeAsync());
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime()).isNull();
    }

    @Test
    public void shouldSetRemovalTime_MultipleInvocationsPerBatchJob() {
        this.testRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(2);
        this.testRule.process().userTask().deploy().start();
        this.testRule.process().userTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).absoluteRemovalTime(this.REMOVAL_TIME).executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTime_SingleInvocationPerBatchJob() {
        this.testRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(1);
        this.testRule.process().userTask().deploy().start();
        this.testRule.process().userTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).absoluteRemovalTime(this.REMOVAL_TIME).executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldNotSetRemovalTime_BaseTimeNone() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("none").initHistoryRemovalTime();
        this.testRule.process().serviceTask().deploy().start();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).calculatedRemovalTime().executeAsync());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
    }

    @Test
    public void shouldNotSetRemovalTimeInHierarchy_BaseTimeNone() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("none").initHistoryRemovalTime();
        this.testRule.process().call().serviceTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).calculatedRemovalTime().hierarchical().executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
    }

    @Test
    public void shouldSetRemovalTime_BaseTimeStart() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        this.testRule.process().userTask().deploy().start();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("process", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).calculatedRemovalTime().executeAsync());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTimeInHierarchy_BaseTimeStart() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        this.testRule.process().call().userTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).calculatedRemovalTime().hierarchical().executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldNotSetRemovalTime_BaseTimeEnd() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("end").initHistoryRemovalTime();
        this.testRule.process().ttl(5).userTask().deploy().start();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).calculatedRemovalTime().executeAsync());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
    }

    @Test
    public void shouldNotSetRemovalTimeInHierarchy_BaseTimeEnd() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("end").initHistoryRemovalTime();
        this.testRule.process().call().ttl(5).userTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).calculatedRemovalTime().hierarchical().executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
    }

    @Test
    public void shouldSetRemovalTime_BaseTimeEnd() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("end").initHistoryRemovalTime();
        this.testRule.process().serviceTask().deploy().start();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("process", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).calculatedRemovalTime().executeAsync());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTimeInHierarchy_BaseTimeEnd() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("end").initHistoryRemovalTime();
        this.testRule.process().call().serviceTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
        this.testRule.updateHistoryTimeToLive("rootProcess", 5);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).calculatedRemovalTime().hierarchical().executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
    }

    @Test
    public void shouldSetRemovalTime_Null() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        this.testRule.process().ttl(5).userTask().deploy().start();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).absoluteRemovalTime(null).executeAsync());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isNull();
    }

    @Test
    public void shouldSetRemovalTimeInHierarchy_Null() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        this.testRule.process().call().ttl(5).userTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).absoluteRemovalTime(null).hierarchical().executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isNull();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isNull();
    }

    @Test
    public void shouldSetRemovalTime_Absolute() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        this.testRule.process().ttl(5).userTask().deploy().start();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).absoluteRemovalTime(this.REMOVAL_TIME).executeAsync());
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assertions.assertThat((Date)historicProcessInstance.getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldSetRemovalTimeInHierarchy_Absolute() {
        this.testRule.getProcessEngineConfiguration().setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        this.testRule.process().call().ttl(5).userTask().deploy().start();
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)BatchSetRemovalTimeRule.addDays(this.CURRENT_DATE, 5));
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().rootProcessInstances();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).absoluteRemovalTime(this.REMOVAL_TIME).hierarchical().executeAsync());
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().list();
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(0)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
        Assertions.assertThat((Date)((HistoricProcessInstance)historicProcessInstances.get(1)).getRemovalTime()).isEqualTo((Object)this.REMOVAL_TIME);
    }

    @Test
    public void shouldThrowBadUserRequestException() {
        this.thrown.expect(BadUserRequestException.class);
        this.thrown.expectMessage("historicProcessInstances is empty");
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).absoluteRemovalTime(this.REMOVAL_TIME).executeAsync();
    }

    @Test
    public void shouldProduceHistory() {
        this.testRule.process().serviceTask().deploy().start();
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        this.testRule.syncExec(this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query).calculatedRemovalTime().executeAsync());
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult();
        Assertions.assertThat((String)historicBatch.getType()).isEqualTo((Object)"process-set-removal-time");
        Assertions.assertThat((Date)historicBatch.getStartTime()).isEqualTo((Object)this.CURRENT_DATE);
        Assertions.assertThat((Date)historicBatch.getEndTime()).isEqualTo((Object)this.CURRENT_DATE);
    }

    @Test
    public void shouldThrowExceptionIfNoRemovalTimeSettingDefined() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        SetRemovalTimeToHistoricProcessInstancesAsyncBuilder batchBuilder = this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().byQuery(query);
        this.thrown.expect(BadUserRequestException.class);
        this.thrown.expectMessage("removalTime is null");
        batchBuilder.executeAsync();
    }

    @Test
    public void shouldThrowExceptionIfNoQueryDefined() {
        SetRemovalTimeToHistoricProcessInstancesAsyncBuilder batchBuilder = this.historyService.setRemovalTimeToHistoricProcessInstancesAsync().absoluteRemovalTime(new Date());
        this.thrown.expect(BadUserRequestException.class);
        this.thrown.expectMessage("query is null");
        batchBuilder.executeAsync();
    }
}

