/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.cleanup;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.api.history.removaltime.cleanup.AbstractHistoryCleanupSchedulerTest;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class HistoryCleanupSchedulerBatchesTest
extends AbstractHistoryCleanupSchedulerTest {
    public ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            return HistoryCleanupSchedulerBatchesTest.this.configure(configuration, HistoryEventTypes.BATCH_START, HistoryEventTypes.BATCH_END);
        }
    };
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected final String PROCESS_KEY = "process";
    protected final BpmnModelInstance PROCESS = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().userTask().endEvent().done();
    protected final String CALLING_PROCESS_KEY = "callingProcess";
    protected final BpmnModelInstance CALLING_PROCESS = ((MultiInstanceLoopCharacteristicsBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"callingProcess").startEvent().callActivity().calledElement("process")).multiInstance().cardinality("5")).multiInstanceDone().endEvent().done();
    protected final Date END_DATE = new Date(1363608000000L);

    @Before
    public void init() {
        engineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.initEngineConfiguration(engineConfiguration);
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
    }

    @Test
    public void shouldScheduleToNow() {
        engineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        engineConfiguration.setHistoryCleanupBatchSize(5);
        engineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess").getId();
        for (int i = 0; i < 5; ++i) {
            String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("process").list().get(0)).getId();
            this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
            ClockUtil.setCurrentTime((Date)this.END_DATE);
            String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
            this.managementService.executeJob(jobId);
            this.jobIds.add(jobId);
            List jobs = this.managementService.createJobQuery().list();
            for (Job job : jobs) {
                this.managementService.executeJob(job.getId());
                this.jobIds.add(job.getId());
            }
        }
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        Assert.assertThat((Object)job.getDuedate(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldScheduleToLater() {
        engineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        engineConfiguration.setHistoryCleanupBatchSize(6);
        engineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess").getId();
        for (int i = 0; i < 5; ++i) {
            String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("process").list().get(0)).getId();
            this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
            ClockUtil.setCurrentTime((Date)this.END_DATE);
            String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
            this.managementService.executeJob(jobId);
            this.jobIds.add(jobId);
            List jobs = this.managementService.createJobQuery().list();
            for (Job job : jobs) {
                this.managementService.executeJob(job.getId());
                this.jobIds.add(job.getId());
            }
        }
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        Assert.assertThat((Object)job.getDuedate(), (Matcher)Is.is((Object)DateUtils.addSeconds((Date)removalTime, (int)10)));
    }
}

