/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.cleanup;

import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.api.history.removaltime.cleanup.AbstractHistoryCleanupSchedulerTest;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class HistoryCleanupSchedulerExternalTaskLogsTest
extends AbstractHistoryCleanupSchedulerTest {
    public ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            return HistoryCleanupSchedulerExternalTaskLogsTest.this.configure(configuration, HistoryEventTypes.EXTERNAL_TASK_SUCCESS);
        }
    };
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected ExternalTaskService externalTaskService;
    protected final String PROCESS_KEY = "process";
    protected final BpmnModelInstance PROCESS = ((UserTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().userTask("userTask").name("userTask")).endEvent().done();

    @Before
    public void init() {
        engineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.initEngineConfiguration(engineConfiguration);
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
    }

    @Test
    public void shouldScheduleToNow() {
        this.testRule.deploy(((MultiInstanceLoopCharacteristicsBuilder)((ServiceTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().serviceTask().camundaExternalTask("anExternalTaskTopic")).multiInstance().cardinality("5")).multiInstanceDone().endEvent().done());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.runtimeService.startProcessInstanceByKey("process");
        for (int i = 0; i < 5; ++i) {
            LockedExternalTask externalTask = (LockedExternalTask)this.externalTaskService.fetchAndLock(1, "aWorkerId").topic("anExternalTaskTopic", 2000L).execute().get(0);
            this.externalTaskService.complete(externalTask.getId(), "aWorkerId");
        }
        engineConfiguration.setHistoryCleanupBatchSize(5);
        engineConfiguration.initHistoryCleanup();
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        Assert.assertThat((Object)job.getDuedate(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldScheduleToLater() {
        this.testRule.deploy(((MultiInstanceLoopCharacteristicsBuilder)((ServiceTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().serviceTask().camundaExternalTask("anExternalTaskTopic")).multiInstance().cardinality("5")).multiInstanceDone().endEvent().done());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.runtimeService.startProcessInstanceByKey("process");
        for (int i = 0; i < 5; ++i) {
            LockedExternalTask externalTask = (LockedExternalTask)this.externalTaskService.fetchAndLock(1, "aWorkerId").topic("anExternalTaskTopic", 2000L).execute().get(0);
            this.externalTaskService.complete(externalTask.getId(), "aWorkerId");
        }
        engineConfiguration.setHistoryCleanupBatchSize(6);
        engineConfiguration.initHistoryCleanup();
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        Job job = (Job)this.historyService.findHistoryCleanupJobs().get(0);
        Assert.assertThat((Object)job.getDuedate(), (Matcher)Is.is((Object)DateUtils.addSeconds((Date)removalTime, (int)10)));
    }
}

