/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.List;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.TenantQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class TenantQueryTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String USER = "user";
    protected static final String GROUP = "group";
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected IdentityService identityService;

    @Before
    public void setUp() {
        this.identityService = this.engineRule.getIdentityService();
        this.createTenant(TENANT_ONE, "Tenant_1");
        this.createTenant(TENANT_TWO, "Tenant_2");
        User user = this.identityService.newUser(USER);
        this.identityService.saveUser(user);
        Group group = this.identityService.newGroup(GROUP);
        this.identityService.saveGroup(group);
        this.identityService.createMembership(USER, GROUP);
        this.identityService.createTenantUserMembership(TENANT_ONE, USER);
        this.identityService.createTenantGroupMembership(TENANT_TWO, GROUP);
    }

    @Test
    public void queryById() {
        TenantQuery query = this.identityService.createTenantQuery().tenantId(TENANT_ONE);
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.list().size(), (Matcher)CoreMatchers.is((Object)1));
        Tenant tenant = (Tenant)query.singleResult();
        Assert.assertThat((Object)tenant, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)tenant.getName(), (Matcher)CoreMatchers.is((Object)"Tenant_1"));
    }

    @Test
    public void queryByNonExistingId() {
        TenantQuery query = this.identityService.createTenantQuery().tenantId("nonExisting");
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void queryByIdIn() {
        TenantQuery query = this.identityService.createTenantQuery();
        Assert.assertThat((Object)query.tenantIdIn(new String[]{"non", "existing"}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void queryByName() {
        TenantQuery query = this.identityService.createTenantQuery();
        Assert.assertThat((Object)query.tenantName("nonExisting").count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantName("Tenant_1").count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantName("Tenant_2").count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void queryByNameLike() {
        TenantQuery query = this.identityService.createTenantQuery();
        Assert.assertThat((Object)query.tenantNameLike("%nonExisting%").count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantNameLike("%Tenant\\_1%").count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantNameLike("%Tenant%").count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void queryByUser() {
        TenantQuery query = this.identityService.createTenantQuery();
        Assert.assertThat((Object)query.userMember("nonExisting").count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.userMember(USER).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.userMember(USER).tenantId(TENANT_ONE).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void queryByGroup() {
        TenantQuery query = this.identityService.createTenantQuery();
        Assert.assertThat((Object)query.groupMember("nonExisting").count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.groupMember(GROUP).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.groupMember(GROUP).tenantId(TENANT_TWO).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void queryByUserIncludingGroups() {
        TenantQuery query = this.identityService.createTenantQuery().userMember(USER);
        Assert.assertThat((Object)query.includingGroupsOfUser(false).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.includingGroupsOfUser(true).count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void queryOrderById() {
        List tenants = ((TenantQuery)this.identityService.createTenantQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)tenants.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Tenant)tenants.get(0)).getId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((Tenant)tenants.get(1)).getId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        tenants = ((TenantQuery)this.identityService.createTenantQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)((Tenant)tenants.get(0)).getId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((Tenant)tenants.get(1)).getId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    @Test
    public void queryOrderByName() {
        List tenants = ((TenantQuery)this.identityService.createTenantQuery().orderByTenantName().asc()).list();
        Assert.assertThat((Object)tenants.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((Tenant)tenants.get(0)).getName(), (Matcher)CoreMatchers.is((Object)"Tenant_1"));
        Assert.assertThat((Object)((Tenant)tenants.get(1)).getName(), (Matcher)CoreMatchers.is((Object)"Tenant_2"));
        tenants = ((TenantQuery)this.identityService.createTenantQuery().orderByTenantName().desc()).list();
        Assert.assertThat((Object)((Tenant)tenants.get(0)).getName(), (Matcher)CoreMatchers.is((Object)"Tenant_2"));
        Assert.assertThat((Object)((Tenant)tenants.get(1)).getName(), (Matcher)CoreMatchers.is((Object)"Tenant_1"));
    }

    protected Tenant createTenant(String id, String name) {
        Tenant tenant = this.engineRule.getIdentityService().newTenant(id);
        tenant.setName(name);
        this.identityService.saveTenant(tenant);
        return tenant;
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.deleteTenant(TENANT_ONE);
        this.identityService.deleteTenant(TENANT_TWO);
        this.identityService.deleteUser(USER);
        this.identityService.deleteGroup(GROUP);
    }
}

