/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.metrics;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.mgmt.metrics.AbstractMetricsTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;

public class ActivityInstanceCountMetricsTest
extends AbstractMetricsTest {
    public void testBpmnActivityInstances() {
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"testProcess").startEvent().manualTask().endEvent().done()});
        ActivityInstanceCountMetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        this.runtimeService.startProcessInstanceByKey("testProcess");
        ActivityInstanceCountMetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        ActivityInstanceCountMetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
    }

    public void testStandaloneTask() {
        ActivityInstanceCountMetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        ActivityInstanceCountMetricsTest.assertEquals((long)1L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        ActivityInstanceCountMetricsTest.assertEquals((long)1L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        this.taskService.deleteTask(task.getId());
        HistoricTaskInstance hti = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        if (hti != null) {
            this.historyService.deleteHistoricTaskInstance(hti.getId());
        }
    }

    @Deployment
    public void testCmmnActivitiyInstances() {
        ActivityInstanceCountMetricsTest.assertEquals((long)0L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        this.caseService.createCaseInstanceByKey("case");
        ActivityInstanceCountMetricsTest.assertEquals((long)1L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        List list = this.caseService.createCaseExecutionQuery().enabled().list();
        for (CaseExecution caseExecution : list) {
            this.caseService.withCaseExecution(caseExecution.getId()).manualStart();
        }
        ActivityInstanceCountMetricsTest.assertEquals((long)2L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        this.processEngineConfiguration.getDbMetricsReporter().reportNow();
        ActivityInstanceCountMetricsTest.assertEquals((long)2L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
        CaseExecution taskExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        this.caseService.completeCaseExecution(taskExecution.getId());
        ActivityInstanceCountMetricsTest.assertEquals((long)3L, (long)this.managementService.createMetricsQuery().name("activity-instance-start").sum());
    }
}

