/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.metrics;

import java.util.Date;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MetricsUserOperationLogTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ManagementService managementService;
    protected HistoryService historyService;
    protected IdentityService identityService;

    @Before
    public void setup() {
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Test
    public void testDeleteMetrics() {
        this.identityService.setAuthenticatedUserId("userId");
        this.managementService.deleteMetrics(null);
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)this.historyService.createUserOperationLogQuery().count(), (Matcher)Matchers.is((Object)1L));
        UserOperationLogEntry logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assert.assertThat((Object)logEntry.getEntityType(), (Matcher)Matchers.is((Object)"Metrics"));
        Assert.assertThat((Object)logEntry.getOperationType(), (Matcher)Matchers.is((Object)"Delete"));
        Assert.assertThat((Object)logEntry.getProperty(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)logEntry.getOrgValue(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)logEntry.getNewValue(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testDeleteMetricsWithTimestamp() {
        Date timestamp = ClockUtil.getCurrentTime();
        this.identityService.setAuthenticatedUserId("userId");
        this.managementService.deleteMetrics(timestamp);
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)this.historyService.createUserOperationLogQuery().count(), (Matcher)Matchers.is((Object)1L));
        UserOperationLogEntry logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assert.assertThat((Object)logEntry.getEntityType(), (Matcher)Matchers.is((Object)"Metrics"));
        Assert.assertThat((Object)logEntry.getOperationType(), (Matcher)Matchers.is((Object)"Delete"));
        Assert.assertThat((Object)logEntry.getProperty(), (Matcher)Matchers.is((Object)"timestamp"));
        Assert.assertThat((Object)logEntry.getOrgValue(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)logEntry.getNewValue(), (Matcher)Matchers.is((Object)String.valueOf(timestamp.getTime())));
    }

    @Test
    public void testDeleteMetricsWithReporterId() {
        this.identityService.setAuthenticatedUserId("userId");
        this.managementService.deleteMetrics(null, "reporter1");
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)this.historyService.createUserOperationLogQuery().count(), (Matcher)Matchers.is((Object)1L));
        UserOperationLogEntry logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assert.assertThat((Object)logEntry.getEntityType(), (Matcher)Matchers.is((Object)"Metrics"));
        Assert.assertThat((Object)logEntry.getOperationType(), (Matcher)Matchers.is((Object)"Delete"));
        Assert.assertThat((Object)logEntry.getProperty(), (Matcher)Matchers.is((Object)"reporter"));
        Assert.assertThat((Object)logEntry.getOrgValue(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)logEntry.getNewValue(), (Matcher)Matchers.is((Object)"reporter1"));
    }

    @Test
    public void testDeleteMetricsWithTimestampAndReporterId() {
        Date timestamp = ClockUtil.getCurrentTime();
        this.identityService.setAuthenticatedUserId("userId");
        this.managementService.deleteMetrics(timestamp, "reporter1");
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)this.historyService.createUserOperationLogQuery().count(), (Matcher)Matchers.is((Object)2L));
        UserOperationLogEntry logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("reporter").singleResult();
        Assert.assertThat((Object)logEntry.getEntityType(), (Matcher)Matchers.is((Object)"Metrics"));
        Assert.assertThat((Object)logEntry.getOperationType(), (Matcher)Matchers.is((Object)"Delete"));
        Assert.assertThat((Object)logEntry.getProperty(), (Matcher)Matchers.is((Object)"reporter"));
        Assert.assertThat((Object)logEntry.getOrgValue(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)logEntry.getNewValue(), (Matcher)Matchers.is((Object)"reporter1"));
        logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("timestamp").singleResult();
        Assert.assertThat((Object)logEntry.getEntityType(), (Matcher)Matchers.is((Object)"Metrics"));
        Assert.assertThat((Object)logEntry.getOperationType(), (Matcher)Matchers.is((Object)"Delete"));
        Assert.assertThat((Object)logEntry.getProperty(), (Matcher)Matchers.is((Object)"timestamp"));
        Assert.assertThat((Object)logEntry.getOrgValue(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)logEntry.getNewValue(), (Matcher)Matchers.is((Object)String.valueOf(timestamp.getTime())));
    }
}

