/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyBusinessRuleTaskTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String DMN_FILE = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected static final String DMN_FILE_VERSION_TWO = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable_v2.dmn";
    protected static final String RESULT_OF_VERSION_ONE = "A";
    protected static final String RESULT_OF_VERSION_TWO = "C";
    public static final String DMN_FILE_VERSION_TAG = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionVersionTagOkay.dmn11.xml";
    public static final String DMN_FILE_VERSION_TAG_TWO = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionVersionTagOkay_v2.dmn11.xml";
    protected static final String RESULT_OF_VERSION_TAG_ONE = "A";
    protected static final String RESULT_OF_VERSION_TAG_TWO = "C";

    public void testEvaluateDecisionWithDeploymentBinding() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("deployment")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, DMN_FILE, process);
        this.deploymentForTenant(TENANT_TWO, DMN_FILE_VERSION_TWO, process);
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstance processInstanceTwo = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_TWO).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)"A"));
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceTwo.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)"C"));
    }

    public void testEvaluateDecisionWithLatestBindingSameVersion() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, DMN_FILE, process);
        this.deploymentForTenant(TENANT_TWO, DMN_FILE_VERSION_TWO, process);
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstance processInstanceTwo = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_TWO).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)"A"));
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceTwo.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)"C"));
    }

    public void testEvaluateDecisionWithLatestBindingDifferentVersions() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, DMN_FILE, process);
        this.deploymentForTenant(TENANT_TWO, DMN_FILE, process);
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE_VERSION_TWO});
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstance processInstanceTwo = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_TWO).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)"A"));
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceTwo.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)"C"));
    }

    public void testEvaluateDecisionWithVersionBinding() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("version")).camundaDecisionRefVersion("1")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, DMN_FILE, process);
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE_VERSION_TWO});
        this.deploymentForTenant(TENANT_TWO, DMN_FILE_VERSION_TWO, process);
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstance processInstanceTwo = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_TWO).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)"A"));
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceTwo.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)"C"));
    }

    public void testEvaluateDecisionWithVersionTagBinding() {
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE_VERSION_TAG});
        this.deployment(new BpmnModelInstance[]{((EndEventBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefTenantId(TENANT_ONE)).camundaDecisionRefBinding("versionTag")).camundaDecisionRefVersionTag("0.0.2")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).endEvent().camundaAsyncBefore()).done()});
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstance.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)"A"));
    }

    public void testEvaluateDecisionWithVersionTagBinding_ResolveTenantFromDefinition() {
        BpmnModelInstance process = ((EndEventBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("versionTag")).camundaDecisionRefVersionTag("0.0.2")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).endEvent().camundaAsyncBefore()).done();
        this.deploymentForTenant(TENANT_ONE, DMN_FILE_VERSION_TAG, process);
        this.deploymentForTenant(TENANT_TWO, DMN_FILE_VERSION_TAG_TWO, process);
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstance processInstanceTwo = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_TWO).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)"A"));
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceTwo.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)"C"));
    }

    public void testFailEvaluateDecisionFromOtherTenantWithDeploymentBinding() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("deployment")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{process});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        try {
            this.runtimeService.createProcessInstanceByKey("process").processDefinitionTenantId(TENANT_ONE).execute();
            MultiTenancyBusinessRuleTaskTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no decision definition deployed with key = 'decision'"));
        }
    }

    public void testFailEvaluateDecisionFromOtherTenantWithLatestBinding() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{process});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        try {
            this.runtimeService.createProcessInstanceByKey("process").processDefinitionTenantId(TENANT_ONE).execute();
            MultiTenancyBusinessRuleTaskTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no decision definition deployed with key 'decision'"));
        }
    }

    public void testFailEvaluateDecisionFromOtherTenantWithVersionBinding() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("version")).camundaDecisionRefVersion("2")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, DMN_FILE, process);
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE});
        try {
            this.runtimeService.createProcessInstanceByKey("process").processDefinitionTenantId(TENANT_ONE).execute();
            MultiTenancyBusinessRuleTaskTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no decision definition deployed with key = 'decision', version = '2' and tenant-id 'tenant1'"));
        }
    }

    public void testFailEvaluateDecisionFromOtherTenantWithVersionTagBinding() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("versionTag")).camundaDecisionRefVersionTag("0.0.2")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("result")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{process});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE_VERSION_TAG});
        try {
            this.runtimeService.createProcessInstanceByKey("process").processDefinitionTenantId(TENANT_ONE).execute();
            MultiTenancyBusinessRuleTaskTest.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"no decision definition deployed with key = 'decision', versionTag = '0.0.2' and tenant-id 'tenant1': decisionDefinition is null"));
        }
    }

    public void testEvaluateDecisionTenantIdConstant() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaDecisionRefTenantId(TENANT_ONE)).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE_VERSION_TWO});
        this.deployment(new BpmnModelInstance[]{process});
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)"A"));
    }

    public void testEvaluateDecisionWithoutTenantIdConstant() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaDecisionRefTenantId("${null}")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.deployment(new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{process});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE_VERSION_TWO});
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)"A"));
    }

    public void testEvaluateDecisionTenantIdExpression() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaDecisionRefTenantId("${'tenant1'}")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE_VERSION_TWO});
        this.deployment(new BpmnModelInstance[]{process});
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)"A"));
    }

    public void testEvaluateDecisionTenantIdCompositeExpression() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaDecisionRefTenantId("tenant${'1'}")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new String[]{DMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{DMN_FILE_VERSION_TWO});
        this.deployment(new BpmnModelInstance[]{process});
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).execute();
        Assert.assertThat((Object)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar")), (Matcher)CoreMatchers.is((Object)"A"));
    }
}

