/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cfg.multitenancy.TenantIdProvider;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.multitenancy.StaticTenantIdTestProvider;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancySharedDefinitionPropagationTest {
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";
    protected static final String TENANT_ID = "tenant1";
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            StaticTenantIdTestProvider tenantIdProvider = new StaticTenantIdTestProvider(MultiTenancySharedDefinitionPropagationTest.TENANT_ID);
            configuration.setTenantIdProvider((TenantIdProvider)tenantIdProvider);
            return configuration;
        }
    };
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Test
    public void propagateTenantIdToProcessInstance() {
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().endEvent().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey(PROCESS_DEFINITION_KEY);
        ProcessInstance processInstance = (ProcessInstance)this.engineRule.getRuntimeService().createProcessInstanceQuery().singleResult();
        Assert.assertThat((Object)processInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)processInstance.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void propagateTenantIdToIntermediateTimerJob() {
        this.testRule.deploy(((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent().timerWithDuration("PT1M")).endEvent().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().singleResult();
        Assert.assertThat((Object)job, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)job.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }

    @Test
    public void propagateTenantIdToAsyncJob() {
        this.testRule.deploy(((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask().camundaAsyncBefore()).endEvent().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        Job job = (Job)this.engineRule.getManagementService().createJobQuery().singleResult();
        Assert.assertThat((Object)job, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)job.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ID));
    }
}

