/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.cmmn.query;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class MultiTenancyCaseInstanceQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String CMMN_FILE = "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        this.deployment(new String[]{CMMN_FILE});
        this.deploymentForTenant(TENANT_ONE, new String[]{CMMN_FILE});
        this.deploymentForTenant(TENANT_TWO, new String[]{CMMN_FILE});
        this.createCaseInstance(null);
        this.createCaseInstance(TENANT_ONE);
        this.createCaseInstance(TENANT_TWO);
    }

    public void testQueryNoTenantIdSet() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    public void testQueryByTenantId() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.caseService.createCaseInstanceQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIds() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByInstancesWithoutTenantId() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByNonExistingTenantId() {
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.caseService.createCaseInstanceQuery().tenantIdIn(new String[]{null});
            MultiTenancyCaseInstanceQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List caseInstances = ((CaseInstanceQuery)this.caseService.createCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assert.assertThat((Object)caseInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((CaseInstance)caseInstances.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((CaseInstance)caseInstances.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List caseInstances = ((CaseInstanceQuery)this.caseService.createCaseInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assert.assertThat((Object)caseInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((CaseInstance)caseInstances.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((CaseInstance)caseInstances.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        CaseInstanceQuery query = this.caseService.createCaseInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    protected void createCaseInstance(String tenantId) {
        String caseDefinitionId = null;
        CaseDefinitionQuery caseDefinitionQuery = this.repositoryService.createCaseDefinitionQuery().caseDefinitionKey("oneTaskCase");
        caseDefinitionId = tenantId == null ? ((CaseDefinition)caseDefinitionQuery.withoutTenantId().singleResult()).getId() : ((CaseDefinition)caseDefinitionQuery.tenantIdIn(new String[]{tenantId}).singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
    }
}

