/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.util.Arrays;
import java.util.Map;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceStatisticsQuery;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyHistoricDecisionInstanceStatisticsQueryTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String DISH_DRG_DMN = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected static final String DISH_DECISION = "dish-decision";
    protected static final String TEMPERATURE = "temperature";
    protected static final String DAY_TYPE = "dayType";
    protected static final String WEEKEND = "Weekend";
    protected static final String USER_ID = "user";
    protected DecisionService decisionService;
    protected RepositoryService repositoryService;
    protected HistoryService historyService;
    protected IdentityService identityService;
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() {
        this.decisionService = this.engineRule.getDecisionService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.historyService = this.engineRule.getHistoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.testRule.deployForTenant(TENANT_ONE, DISH_DRG_DMN);
        this.decisionService.evaluateDecisionByKey(DISH_DECISION).decisionDefinitionTenantId(TENANT_ONE).variables((Map)Variables.createVariables().putValue(TEMPERATURE, (Object)21).putValue(DAY_TYPE, (Object)WEEKEND)).evaluate();
    }

    @Test
    public void testQueryNoAuthenticatedTenants() {
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        this.identityService.setAuthentication(USER_ID, null, null);
        HistoricDecisionInstanceStatisticsQuery query = this.historyService.createHistoricDecisionInstanceStatisticsQuery(decisionRequirementsDefinition.getId());
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void testQueryAuthenticatedTenant() {
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        HistoricDecisionInstanceStatisticsQuery query = this.historyService.createHistoricDecisionInstanceStatisticsQuery(decisionRequirementsDefinition.getId());
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void testQueryDisabledTenantCheck() {
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).singleResult();
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication(USER_ID, null, null);
        HistoricDecisionInstanceStatisticsQuery query = this.historyService.createHistoricDecisionInstanceStatisticsQuery(decisionRequirementsDefinition.getId());
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }
}

