/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@RequiredHistoryLevel(value="full")
public class MultiTenancyHistoricIncidentQueryTest
extends PluggableProcessEngineTestCase {
    protected static final BpmnModelInstance BPMN = ((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"failingProcess").startEvent().serviceTask().camundaAsyncBefore()).camundaExpression("${failing}")).endEvent().done();
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{BPMN});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{BPMN});
        this.startProcessInstanceAndExecuteFailingJobForTenant(TENANT_ONE);
        this.startProcessInstanceAndExecuteFailingJobForTenant(TENANT_TWO);
    }

    public void testQueryWithoutTenantId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByTenantId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.historyService.createHistoricIncidentQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIds() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByNonExistingTenantId() {
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricIncidentQuery().tenantIdIn(new String[]{null});
            MultiTenancyHistoricIncidentQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List historicIncidents = ((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)historicIncidents.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((HistoricIncident)historicIncidents.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((HistoricIncident)historicIncidents.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List historicIncidents = ((HistoricIncidentQuery)this.historyService.createHistoricIncidentQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)historicIncidents.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((HistoricIncident)historicIncidents.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((HistoricIncident)historicIncidents.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HistoricIncidentQuery query = this.historyService.createHistoricIncidentQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    protected void startProcessInstanceAndExecuteFailingJobForTenant(String tenant) {
        this.runtimeService.createProcessInstanceByKey("failingProcess").processDefinitionTenantId(tenant).execute();
        this.executeAvailableJobs();
    }
}

