/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@RequiredHistoryLevel(value="activity")
public class MultiTenancyHistoricProcessInstanceQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    protected void setUp() {
        BpmnModelInstance oneTaskProcess = Bpmn.createExecutableProcess((String)"testProcess").startEvent().endEvent().done();
        this.deployment(new BpmnModelInstance[]{oneTaskProcess});
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{oneTaskProcess});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{oneTaskProcess});
        this.startProcessInstance();
        this.startProcessInstanceForTenant(TENANT_ONE);
        this.startProcessInstanceForTenant(TENANT_TWO);
    }

    public void testQueryNoTenantIdSet() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    public void testQueryByTenantId() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        query = this.historyService.createHistoricProcessInstanceQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryByTenantIds() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByNonExistingTenantId() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testQueryByWithoutTenantId() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().withoutTenantId();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricProcessInstanceQuery().tenantIdIn(new String[]{null});
            MultiTenancyHistoricProcessInstanceQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List historicProcessInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assert.assertThat((Object)historicProcessInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((HistoricProcessInstance)historicProcessInstances.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)((HistoricProcessInstance)historicProcessInstances.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
    }

    public void testQuerySortingDesc() {
        List historicProcessInstances = ((HistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assert.assertThat((Object)historicProcessInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((HistoricProcessInstance)historicProcessInstances.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        Assert.assertThat((Object)((HistoricProcessInstance)historicProcessInstances.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Collections.singletonList(TENANT_ONE));
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.withoutTenantId().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)3L));
    }

    protected ProcessInstance startProcessInstanceForTenant(String tenant) {
        return this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(tenant).execute();
    }

    protected ProcessInstance startProcessInstance() {
        return this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionWithoutTenantId().execute();
    }
}

