/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@RequiredHistoryLevel(value="audit")
public class MultiTenancyHistoricVariableInstanceQueryTest
extends PluggableProcessEngineTestCase {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String TENANT_ONE_VAR = "tenant1Var";
    protected static final String TENANT_TWO_VAR = "tenant2Var";

    protected void setUp() {
        BpmnModelInstance oneTaskProcess = Bpmn.createExecutableProcess((String)"testProcess").startEvent().endEvent().done();
        this.deploymentForTenant(TENANT_ONE, new BpmnModelInstance[]{oneTaskProcess});
        this.deploymentForTenant(TENANT_TWO, new BpmnModelInstance[]{oneTaskProcess});
        this.startProcessInstanceForTenant(TENANT_ONE, TENANT_ONE_VAR);
        this.startProcessInstanceForTenant(TENANT_TWO, TENANT_TWO_VAR);
    }

    public void testQueryWithoutTenantId() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByTenantId() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        MultiTenancyHistoricVariableInstanceQueryTest.assertEquals((Object)((HistoricVariableInstance)query.list().get(0)).getValue(), (Object)TENANT_ONE_VAR);
        query = this.historyService.createHistoricVariableInstanceQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        MultiTenancyHistoricVariableInstanceQueryTest.assertEquals((Object)((HistoricVariableInstance)query.list().get(0)).getValue(), (Object)TENANT_TWO_VAR);
    }

    public void testQueryByTenantIds() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testQueryByNonExistingTenantId() {
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery().tenantIdIn(new String[]{"nonExisting"});
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricVariableInstanceQuery().tenantIdIn(new String[]{null});
            MultiTenancyHistoricVariableInstanceQueryTest.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    public void testQuerySortingAsc() {
        List historicVariableInstances = ((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByTenantId().asc()).list();
        Assert.assertThat((Object)historicVariableInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((HistoricVariableInstance)historicVariableInstances.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        MultiTenancyHistoricVariableInstanceQueryTest.assertEquals((Object)((HistoricVariableInstance)historicVariableInstances.get(0)).getValue(), (Object)TENANT_ONE_VAR);
        Assert.assertThat((Object)((HistoricVariableInstance)historicVariableInstances.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        MultiTenancyHistoricVariableInstanceQueryTest.assertEquals((Object)((HistoricVariableInstance)historicVariableInstances.get(1)).getValue(), (Object)TENANT_TWO_VAR);
    }

    public void testQuerySortingDesc() {
        List historicVariableInstances = ((HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByTenantId().desc()).list();
        Assert.assertThat((Object)historicVariableInstances.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((HistoricVariableInstance)historicVariableInstances.get(0)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_TWO));
        MultiTenancyHistoricVariableInstanceQueryTest.assertEquals((Object)((HistoricVariableInstance)historicVariableInstances.get(0)).getValue(), (Object)TENANT_TWO_VAR);
        Assert.assertThat((Object)((HistoricVariableInstance)historicVariableInstances.get(1)).getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        MultiTenancyHistoricVariableInstanceQueryTest.assertEquals((Object)((HistoricVariableInstance)historicVariableInstances.get(1)).getValue(), (Object)TENANT_ONE_VAR);
    }

    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HistoricVariableInstanceQuery query = this.historyService.createHistoricVariableInstanceQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    protected ProcessInstance startProcessInstanceForTenant(String tenant, String var) {
        return ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("testProcess").setVariable("myVar", (Object)var)).processDefinitionTenantId(tenant).execute();
    }
}

