/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.Resource;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyDeploymentCmdsTenantCheckTest {
    protected static final String TENANT_TWO = "tenant2";
    protected static final String TENANT_ONE = "tenant1";
    protected static final BpmnModelInstance emptyProcess = Bpmn.createExecutableProcess().done();
    protected static final BpmnModelInstance startEndProcess = Bpmn.createExecutableProcess().startEvent().endEvent().done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected ProcessEngineConfiguration processEngineConfiguration;

    @Before
    public void init() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Test
    public void createDeploymentForAnotherTenant() {
        this.identityService.setAuthentication("user", null, null);
        this.repositoryService.createDeployment().addModelInstance("emptyProcess.bpmn", emptyProcess).tenantId(TENANT_ONE).deploy();
        this.identityService.clearAuthentication();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void createDeploymentWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.createDeployment().addModelInstance("emptyProcess.bpmn", emptyProcess).tenantId(TENANT_ONE).deploy();
        this.identityService.clearAuthentication();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void createDeploymentDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.repositoryService.createDeployment().addModelInstance("emptyProcessOne", emptyProcess).tenantId(TENANT_ONE).deploy();
        this.repositoryService.createDeployment().addModelInstance("emptyProcessTwo", startEndProcess).tenantId(TENANT_TWO).deploy();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void failToDeleteDeploymentNoAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot delete the deployment");
        this.repositoryService.deleteDeployment(deployment.getId());
    }

    @Test
    public void deleteDeploymentWithAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.deleteDeployment(deployment.getId());
        this.identityService.clearAuthentication();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void deleteDeploymentDisabledTenantCheck() {
        Deployment deploymentOne = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Deployment deploymentTwo = this.testRule.deployForTenant(TENANT_TWO, startEndProcess);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.repositoryService.deleteDeployment(deploymentOne.getId());
        this.repositoryService.deleteDeployment(deploymentTwo.getId());
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void failToGetDeploymentResourceNamesNoAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the deployment");
        this.repositoryService.getDeploymentResourceNames(deployment.getId());
    }

    @Test
    public void getDeploymentResourceNamesWithAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List deploymentResourceNames = this.repositoryService.getDeploymentResourceNames(deployment.getId());
        Assert.assertThat((Object)deploymentResourceNames, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void getDeploymentResourceNamesDisabledTenantCheck() {
        Deployment deploymentOne = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Deployment deploymentTwo = this.testRule.deployForTenant(TENANT_TWO, startEndProcess);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        List deploymentResourceNames = this.repositoryService.getDeploymentResourceNames(deploymentOne.getId());
        Assert.assertThat((Object)deploymentResourceNames, (Matcher)Matchers.hasSize((int)1));
        deploymentResourceNames = this.repositoryService.getDeploymentResourceNames(deploymentTwo.getId());
        Assert.assertThat((Object)deploymentResourceNames, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void failToGetDeploymentResourcesNoAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the deployment");
        this.repositoryService.getDeploymentResources(deployment.getId());
    }

    @Test
    public void getDeploymentResourcesWithAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        List deploymentResources = this.repositoryService.getDeploymentResources(deployment.getId());
        Assert.assertThat((Object)deploymentResources, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void getDeploymentResourcesDisabledTenantCheck() {
        Deployment deploymentOne = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Deployment deploymentTwo = this.testRule.deployForTenant(TENANT_TWO, startEndProcess);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        List deploymentResources = this.repositoryService.getDeploymentResources(deploymentOne.getId());
        Assert.assertThat((Object)deploymentResources, (Matcher)Matchers.hasSize((int)1));
        deploymentResources = this.repositoryService.getDeploymentResources(deploymentTwo.getId());
        Assert.assertThat((Object)deploymentResources, (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void failToGetResourceAsStreamNoAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Resource resource = (Resource)this.repositoryService.getDeploymentResources(deployment.getId()).get(0);
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the deployment");
        this.repositoryService.getResourceAsStream(deployment.getId(), resource.getName());
    }

    @Test
    public void getResourceAsStreamWithAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Resource resource = (Resource)this.repositoryService.getDeploymentResources(deployment.getId()).get(0);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        InputStream inputStream = this.repositoryService.getResourceAsStream(deployment.getId(), resource.getName());
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void getResourceAsStreamDisabledTenantCheck() {
        Deployment deploymentOne = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Deployment deploymentTwo = this.testRule.deployForTenant(TENANT_TWO, startEndProcess);
        Resource resourceOne = (Resource)this.repositoryService.getDeploymentResources(deploymentOne.getId()).get(0);
        Resource resourceTwo = (Resource)this.repositoryService.getDeploymentResources(deploymentTwo.getId()).get(0);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        InputStream inputStream = this.repositoryService.getResourceAsStream(deploymentOne.getId(), resourceOne.getName());
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.notNullValue());
        inputStream = this.repositoryService.getResourceAsStream(deploymentTwo.getId(), resourceTwo.getName());
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void failToGetResourceAsStreamByIdNoAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Resource resource = (Resource)this.repositoryService.getDeploymentResources(deployment.getId()).get(0);
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the deployment");
        this.repositoryService.getResourceAsStreamById(deployment.getId(), resource.getId());
    }

    @Test
    public void getResourceAsStreamByIdWithAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Resource resource = (Resource)this.repositoryService.getDeploymentResources(deployment.getId()).get(0);
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        InputStream inputStream = this.repositoryService.getResourceAsStreamById(deployment.getId(), resource.getId());
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void getResourceAsStreamByIdDisabledTenantCheck() {
        Deployment deploymentOne = this.testRule.deployForTenant(TENANT_ONE, emptyProcess);
        Deployment deploymentTwo = this.testRule.deployForTenant(TENANT_TWO, startEndProcess);
        Resource resourceOne = (Resource)this.repositoryService.getDeploymentResources(deploymentOne.getId()).get(0);
        Resource resourceTwo = (Resource)this.repositoryService.getDeploymentResources(deploymentTwo.getId()).get(0);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        InputStream inputStream = this.repositoryService.getResourceAsStreamById(deploymentOne.getId(), resourceOne.getId());
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.notNullValue());
        inputStream = this.repositoryService.getResourceAsStreamById(deploymentTwo.getId(), resourceTwo.getId());
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void redeployForDifferentAuthenticatedTenants() {
        Deployment deploymentOne = this.repositoryService.createDeployment().addModelInstance("emptyProcess.bpmn", emptyProcess).addModelInstance("startEndProcess.bpmn", startEndProcess).tenantId(TENANT_ONE).deploy();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_TWO));
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the deployment");
        this.repositoryService.createDeployment().addDeploymentResources(deploymentOne.getId()).tenantId(TENANT_TWO).deploy();
    }

    @Test
    public void redeployForTheSameAuthenticatedTenant() {
        Deployment deploymentOne = this.repositoryService.createDeployment().addModelInstance("emptyProcess.bpmn", emptyProcess).addModelInstance("startEndProcess.bpmn", startEndProcess).tenantId(TENANT_ONE).deploy();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.createDeployment().addDeploymentResources(deploymentOne.getId()).tenantId(TENANT_ONE).deploy();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void redeployForDifferentAuthenticatedTenantsDisabledTenantCheck() {
        Deployment deploymentOne = this.repositoryService.createDeployment().addModelInstance("emptyProcess.bpmn", emptyProcess).addModelInstance("startEndProcess.bpmn", startEndProcess).tenantId(TENANT_ONE).deploy();
        this.identityService.setAuthentication("user", null, null);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.repositoryService.createDeployment().addDeploymentResources(deploymentOne.getId()).tenantId(TENANT_TWO).deploy();
        DeploymentQuery query = this.repositoryService.createDeploymentQuery();
        Assert.assertThat((Object)query.count(), (Matcher)CoreMatchers.is((Object)2L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)query.tenantIdIn(new String[]{TENANT_TWO}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @After
    public void tearDown() throws Exception {
        this.identityService.clearAuthentication();
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }
}

