/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DiagramLayout;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyProcessDefinitionCmdsTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String BPMN_PROCESS_MODEL = "org/camunda/bpm/engine/test/api/multitenancy/testProcess.bpmn";
    protected static final String BPMN_PROCESS_DIAGRAM = "org/camunda/bpm/engine/test/api/multitenancy/testProcess.png";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected String processDefinitionId;

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.testRule.deployForTenant(TENANT_ONE, BPMN_PROCESS_MODEL, BPMN_PROCESS_DIAGRAM);
        this.processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
    }

    @Test
    public void failToGetProcessModelNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the process definition");
        this.repositoryService.getProcessModel(this.processDefinitionId);
    }

    @Test
    public void getProcessModelWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        InputStream inputStream = this.repositoryService.getProcessModel(this.processDefinitionId);
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void getProcessModelDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        InputStream inputStream = this.repositoryService.getProcessModel(this.processDefinitionId);
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void failToGetProcessDiagramNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the process definition");
        this.repositoryService.getProcessDiagram(this.processDefinitionId);
    }

    @Test
    public void getProcessDiagramWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        InputStream inputStream = this.repositoryService.getProcessDiagram(this.processDefinitionId);
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void getProcessDiagramDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        InputStream inputStream = this.repositoryService.getProcessDiagram(this.processDefinitionId);
        Assert.assertThat((Object)inputStream, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void failToGetProcessDiagramLayoutNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the process definition");
        this.repositoryService.getProcessDiagramLayout(this.processDefinitionId);
    }

    @Test
    public void getProcessDiagramLayoutWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        DiagramLayout diagramLayout = this.repositoryService.getProcessDiagramLayout(this.processDefinitionId);
        Assert.assertThat((Object)diagramLayout, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void getProcessDiagramLayoutDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        DiagramLayout diagramLayout = this.repositoryService.getProcessDiagramLayout(this.processDefinitionId);
        Assert.assertThat((Object)diagramLayout, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void failToGetProcessDefinitionNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the process definition");
        this.repositoryService.getProcessDefinition(this.processDefinitionId);
    }

    @Test
    public void getProcessDefinitionWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        ProcessDefinition definition = this.repositoryService.getProcessDefinition(this.processDefinitionId);
        Assert.assertThat((Object)definition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    @Test
    public void getProcessDefinitionDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        ProcessDefinition definition = this.repositoryService.getProcessDefinition(this.processDefinitionId);
        Assert.assertThat((Object)definition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
    }

    @Test
    public void failToGetBpmnModelInstanceNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot get the process definition");
        this.repositoryService.getBpmnModelInstance(this.processDefinitionId);
    }

    @Test
    public void getBpmnModelInstanceWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        BpmnModelInstance modelInstance = this.repositoryService.getBpmnModelInstance(this.processDefinitionId);
        Assert.assertThat((Object)modelInstance, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void getBpmnModelInstanceDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        BpmnModelInstance modelInstance = this.repositoryService.getBpmnModelInstance(this.processDefinitionId);
        Assert.assertThat((Object)modelInstance, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void failToDeleteProcessDefinitionNoAuthenticatedTenant() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot delete the process definition");
        this.repositoryService.deleteProcessDefinition(((ProcessDefinition)processDefinitions.get(0)).getId());
    }

    @Test
    public void testDeleteProcessDefinitionWithAuthenticatedTenant() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/repository/twoProcesses.bpmn20.xml");
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId());
        List processDefinitions = processDefinitionQuery.list();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.deleteProcessDefinition(((ProcessDefinition)processDefinitions.get(0)).getId());
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)processDefinitionQuery.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)processDefinitionQuery.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testDeleteCascadeProcessDefinitionWithAuthenticatedTenant() {
        BpmnModelInstance bpmnModel = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, bpmnModel);
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitionQuery.processDefinitionKey("process").singleResult();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("process").executeWithVariablesInReturn();
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.deleteProcessDefinition(processDefinition.getId(), true);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.engineRule.getRuntimeService().createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_ACTIVITY.getId()) {
            Assert.assertEquals((long)0L, (long)this.engineRule.getHistoryService().createHistoricActivityInstanceQuery().count());
        }
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testDeleteProcessDefinitionDisabledTenantCheck() {
        Deployment deployment = this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/repository/twoProcesses.bpmn20.xml");
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().deploymentId(deployment.getId());
        List processDefinitions = processDefinitionQuery.list();
        this.identityService.setAuthentication("user", null, null);
        this.repositoryService.deleteProcessDefinition(((ProcessDefinition)processDefinitions.get(0)).getId());
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)processDefinitionQuery.count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)processDefinitionQuery.tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testDeleteCascadeProcessDefinitionDisabledTenantCheck() {
        BpmnModelInstance bpmnModel = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, bpmnModel);
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery();
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitionQuery.processDefinitionKey("process").singleResult();
        this.engineRule.getRuntimeService().createProcessInstanceByKey("process").executeWithVariablesInReturn();
        this.identityService.setAuthentication("user", null, null);
        this.repositoryService.deleteProcessDefinition(processDefinition.getId(), true);
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)0L, (long)this.engineRule.getRuntimeService().createProcessInstanceQuery().count());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= HistoryLevel.HISTORY_LEVEL_ACTIVITY.getId()) {
            Assert.assertEquals((long)0L, (long)this.engineRule.getHistoryService().createHistoricActivityInstanceQuery().count());
        }
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void failToDeleteProcessDefinitionsByKeyNoAuthenticatedTenant() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("No process definition found");
        this.repositoryService.deleteProcessDefinitions().byKey("process").withoutTenantId().delete();
    }

    @Test
    public void testDeleteProcessDefinitionsByKeyForAllTenants() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
            this.deployProcessDefinitionWithoutTenant();
        }
        this.repositoryService.deleteProcessDefinitions().byKey("process").delete();
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testDeleteProcessDefinitionsByKeyWithAuthenticatedTenant() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.deleteProcessDefinitions().byKey("process").withTenantId(TENANT_ONE).delete();
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testDeleteCascadeProcessDefinitionsByKeyWithAuthenticatedTenant() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        this.runtimeService.startProcessInstanceByKey("process");
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.deleteProcessDefinitions().byKey("process").withTenantId(TENANT_ONE).cascade().delete();
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)this.historyService.createHistoricProcessInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testDeleteProcessDefinitionsByKeyDisabledTenantCheck() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.repositoryService.deleteProcessDefinitions().byKey("process").withTenantId(TENANT_ONE).delete();
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testDeleteCascadeProcessDefinitionsByKeyDisabledTenantCheck() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.startProcessInstanceByKey("process");
        this.repositoryService.deleteProcessDefinitions().byKey("process").withTenantId(TENANT_ONE).cascade().delete();
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)this.historyService.createHistoricProcessInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void failToDeleteProcessDefinitionsByIdsNoAuthenticatedTenant() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        String[] processDefinitionIds = this.findProcessDefinitionIdsByKey("process");
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot delete the process definition");
        this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIds).delete();
    }

    @Test
    public void testDeleteProcessDefinitionsByIdsWithAuthenticatedTenant() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        String[] processDefinitionIds = this.findProcessDefinitionIdsByKey("process");
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIds).delete();
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testDeleteCascadeProcessDefinitionsByIdsWithAuthenticatedTenant() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        String[] processDefinitionIds = this.findProcessDefinitionIdsByKey("process");
        this.runtimeService.startProcessInstanceByKey("process");
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIds).cascade().delete();
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)this.historyService.createHistoricProcessInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testDeleteProcessDefinitionsByIdsDisabledTenantCheck() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        String[] processDefinitionIds = this.findProcessDefinitionIdsByKey("process");
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIds).delete();
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void testDeleteCascadeProcessDefinitionsByIdsDisabledTenantCheck() {
        for (int i = 0; i < 3; ++i) {
            this.deployProcessDefinitionWithTenant();
        }
        String[] processDefinitionIds = this.findProcessDefinitionIdsByKey("process");
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.runtimeService.startProcessInstanceByKey("process");
        this.repositoryService.deleteProcessDefinitions().byIds(processDefinitionIds).cascade().delete();
        this.identityService.clearAuthentication();
        Assert.assertThat((Object)this.historyService.createHistoricProcessInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)this.repositoryService.createProcessDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void updateHistoryTimeToLiveWithAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(this.processDefinitionId, Integer.valueOf(6));
        ProcessDefinition definition = this.repositoryService.getProcessDefinition(this.processDefinitionId);
        Assert.assertThat((Object)definition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)definition.getHistoryTimeToLive(), (Matcher)CoreMatchers.is((Object)6));
    }

    @Test
    public void updateHistoryTimeToLiveDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(this.processDefinitionId, Integer.valueOf(6));
        ProcessDefinition definition = this.repositoryService.getProcessDefinition(this.processDefinitionId);
        Assert.assertThat((Object)definition.getTenantId(), (Matcher)CoreMatchers.is((Object)TENANT_ONE));
        Assert.assertThat((Object)definition.getHistoryTimeToLive(), (Matcher)CoreMatchers.is((Object)6));
    }

    @Test
    public void updateHistoryTimeToLiveNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        this.thrown.expect(ProcessEngineException.class);
        this.thrown.expectMessage("Cannot update the process definition");
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(this.processDefinitionId, Integer.valueOf(6));
    }

    private String[] findProcessDefinitionIdsByKey(String processDefinitionKey) {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).list();
        ArrayList<String> processDefinitionIds = new ArrayList<String>();
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionIds.add(processDefinition.getId());
        }
        return processDefinitionIds.toArray(new String[0]);
    }

    private void deployProcessDefinitionWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done());
    }

    private void deployProcessDefinitionWithoutTenant() {
        this.testRule.deploy(Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done());
    }
}

