/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.optimize;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.OptimizeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class GetHistoricOperationLogsForOptimizeTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    private OptimizeService optimizeService;
    protected String userId = "test";
    private IdentityService identityService;
    private RuntimeService runtimeService;
    private AuthorizationService authorizationService;
    private TaskService taskService;

    @Before
    public void init() {
        ProcessEngineConfigurationImpl config = this.engineRule.getProcessEngineConfiguration();
        this.optimizeService = config.getOptimizeService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.taskService = this.engineRule.getTaskService();
        this.createUser(this.userId);
        this.identityService.setAuthenticatedUserId(this.userId);
    }

    @After
    public void cleanUp() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
        ClockUtil.reset();
        this.identityService.clearAuthentication();
    }

    @Test
    public void getHistoricUserOperationLogs() {
        BpmnModelInstance simpleDefinition = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask").name("task")).endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
        this.runtimeService.startProcessInstanceByKey("process");
        this.claimAllUserTasks();
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)1));
        this.assertThatTasksHaveAllImportantInformation((UserOperationLogEntry)userOperationsLog.get(0));
    }

    @Test
    public void occurredAfterParameterWorks() {
        BpmnModelInstance simpleDefinition = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask").camundaAssignee(this.userId)).endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.unclaimAllUserTasks();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.claimAllUserTasks();
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        this.completeAllUserTasks();
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(now, null, 10);
        HashSet<String> allowedOperationsTypes = new HashSet<String>(Arrays.asList("Claim", "Complete"));
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)2));
        TestCase.assertTrue((boolean)allowedOperationsTypes.contains(((UserOperationLogEntry)userOperationsLog.get(0)).getOperationType()));
        TestCase.assertTrue((boolean)allowedOperationsTypes.contains(((UserOperationLogEntry)userOperationsLog.get(1)).getOperationType()));
    }

    @Test
    public void occurredAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask").endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.claimAllUserTasks();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.completeAllUserTasks();
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(null, now, 10);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getOperationType(), (Matcher)CoreMatchers.is((Object)"Claim"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getCategory(), (Matcher)CoreMatchers.is((Object)"TaskWorker"));
    }

    @Test
    public void occurredAfterAndOccurredAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask").endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.claimAllUserTasks();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.completeAllUserTasks();
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(now, now, 10);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void maxResultsParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().userTask().userTask().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.claimAndCompleteAllUserTasks();
        this.claimAndCompleteAllUserTasks();
        this.claimAndCompleteAllUserTasks();
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(this.pastDate(), null, 3);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void resultIsSortedByTimestamp() {
        BpmnModelInstance simpleDefinition = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("userTask").camundaAssignee(this.userId)).endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        ClockUtil.setCurrentTime((Date)now);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.unclaimAllUserTasks();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.claimAllUserTasks();
        Date nowPlus4Seconds = new Date(now.getTime() + 4000L);
        ClockUtil.setCurrentTime((Date)nowPlus4Seconds);
        this.completeAllUserTasks();
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(this.pastDate(), null, 4);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(0)).getOperationType(), (Matcher)CoreMatchers.is((Object)"Assign"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(1)).getOperationType(), (Matcher)CoreMatchers.is((Object)"Claim"));
        MatcherAssert.assertThat((Object)((UserOperationLogEntry)userOperationsLog.get(2)).getOperationType(), (Matcher)CoreMatchers.is((Object)"Complete"));
    }

    @Test
    public void fetchOnlyUserTaskBasedLogEntries() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask().endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.createLogEntriesThatShouldNotBeReturned(processInstance.getId());
        MatcherAssert.assertThat((Object)this.engineRule.getHistoryService().createUserOperationLogQuery().count(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(0L)));
        List userOperationsLog = this.optimizeService.getHistoricUserOperationLogs(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)userOperationsLog.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    private void createLogEntriesThatShouldNotBeReturned(String processInstanceId) {
        ClockUtil.setCurrentTime((Date)new Date());
        String processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.addCandidateUser(processTaskId, "er");
        this.taskService.deleteCandidateUser(processTaskId, "er");
        this.taskService.addCandidateGroup(processTaskId, "wir");
        this.taskService.deleteCandidateGroup(processTaskId, "wir");
        this.taskService.setOwner(processTaskId, "icke");
        this.taskService.setPriority(processTaskId, 10);
        Attachment attachment = this.taskService.createAttachment("image/ico", processTaskId, processInstanceId, "favicon.ico", "favicon", "http://camunda.com/favicon.ico");
        this.taskService.deleteAttachment(attachment.getId());
        this.runtimeService.deleteProcessInstance(processInstanceId, "that's why");
        Task userTask = this.taskService.newTask();
        userTask.setName("to do");
        this.taskService.saveTask(userTask);
        ClockUtil.setCurrentTime((Date)new Date());
        userTask.setDescription("desc");
        userTask.setOwner("icke");
        userTask.setAssignee("er");
        userTask.setDueDate(new Date());
        this.taskService.saveTask(userTask);
        this.taskService.deleteTask(userTask.getId(), true);
    }

    private Date pastDate() {
        return new Date(2L);
    }

    private void claimAndCompleteAllUserTasks() {
        List list = this.taskService.createTaskQuery().list();
        for (Task task : list) {
            this.taskService.claim(task.getId(), this.userId);
            this.taskService.complete(task.getId());
        }
    }

    private void completeAllUserTasks() {
        List list = this.taskService.createTaskQuery().list();
        for (Task task : list) {
            this.taskService.complete(task.getId());
        }
    }

    private void claimAllUserTasks() {
        List list = this.taskService.createTaskQuery().list();
        for (Task task : list) {
            this.taskService.claim(task.getId(), this.userId);
        }
    }

    private void unclaimAllUserTasks() {
        List list = this.taskService.createTaskQuery().list();
        for (Task task : list) {
            this.taskService.setAssignee(task.getId(), null);
        }
    }

    protected void createUser(String userId) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
    }

    private void assertThatTasksHaveAllImportantInformation(UserOperationLogEntry userOperationLogEntry) {
        MatcherAssert.assertThat((Object)userOperationLogEntry, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)userOperationLogEntry.getId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)userOperationLogEntry.getOperationType(), (Matcher)CoreMatchers.is((Object)"Claim"));
        MatcherAssert.assertThat((Object)userOperationLogEntry.getOrgValue(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)userOperationLogEntry.getNewValue(), (Matcher)CoreMatchers.is((Object)this.userId));
        MatcherAssert.assertThat((Object)userOperationLogEntry.getTimestamp(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)userOperationLogEntry.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)userOperationLogEntry.getProcessDefinitionId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)userOperationLogEntry.getUserId(), (Matcher)CoreMatchers.is((Object)this.userId));
        MatcherAssert.assertThat((Object)userOperationLogEntry.getTaskId(), (Matcher)CoreMatchers.is((Object)((Task)this.taskService.createTaskQuery().singleResult()).getId()));
        MatcherAssert.assertThat((Object)userOperationLogEntry.getCategory(), (Matcher)CoreMatchers.is((Object)"TaskWorker"));
    }
}

