/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.optimize;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.OptimizeService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class GetRunningHistoricActivityInstancesForOptimizeTest {
    protected static final String VARIABLE_NAME = "aVariableName";
    protected static final String VARIABLE_VALUE = "aVariableValue";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected String userId = "test";
    private OptimizeService optimizeService;
    private IdentityService identityService;
    private RuntimeService runtimeService;
    private AuthorizationService authorizationService;
    private TaskService taskService;

    @Before
    public void init() {
        ProcessEngineConfigurationImpl config = this.engineRule.getProcessEngineConfiguration();
        this.optimizeService = config.getOptimizeService();
        this.identityService = this.engineRule.getIdentityService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        this.taskService = this.engineRule.getTaskService();
        this.createUser(this.userId);
    }

    @After
    public void cleanUp() {
        for (User user : this.identityService.createUserQuery().list()) {
            this.identityService.deleteUser(user.getId());
        }
        for (Group group : this.identityService.createGroupQuery().list()) {
            this.identityService.deleteGroup(group.getId());
        }
        for (Authorization authorization : this.authorizationService.createAuthorizationQuery().list()) {
            this.authorizationService.deleteAuthorization(authorization.getId());
        }
        ClockUtil.reset();
    }

    @Test
    public void getRunningHistoricActivityInstances() {
        BpmnModelInstance simpleDefinition = ((EndEventBuilder)((UserTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").name("start")).userTask("userTask").name("task")).endEvent("endEvent").name("end")).done();
        this.testHelper.deploy(simpleDefinition);
        this.runtimeService.startProcessInstanceByKey("process");
        List runningHistoricActivityInstances = this.optimizeService.getRunningHistoricActivityInstances(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)runningHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        HistoricActivityInstance activityInstance = (HistoricActivityInstance)runningHistoricActivityInstances.get(0);
        this.assertThatActivitiesHaveAllImportantInformation(activityInstance);
    }

    @Test
    public void startedAfterParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask").endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)now);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        ProcessInstance secondProcessInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        List runningHistoricActivityInstances = this.optimizeService.getRunningHistoricActivityInstances(now, null, 10);
        MatcherAssert.assertThat((Object)runningHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((HistoricActivityInstance)runningHistoricActivityInstances.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)secondProcessInstance.getId()));
    }

    @Test
    public void startedAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask").endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)now);
        ProcessInstance firstProcessInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        List runningHistoricActivityInstances = this.optimizeService.getRunningHistoricActivityInstances(null, now, 10);
        MatcherAssert.assertThat((Object)runningHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((HistoricActivityInstance)runningHistoricActivityInstances.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)firstProcessInstance.getId()));
    }

    @Test
    public void startedAfterAndStartedAtParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask").endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
        Date now = new Date();
        Date nowPlus2Seconds = new Date(now.getTime() + 2000L);
        ClockUtil.setCurrentTime((Date)now);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        ClockUtil.setCurrentTime((Date)nowPlus2Seconds);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        List runningHistoricActivityInstances = this.optimizeService.getRunningHistoricActivityInstances(now, now, 10);
        MatcherAssert.assertThat((Object)runningHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void maxResultsParameterWorks() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask").endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        List runningHistoricActivityInstances = this.optimizeService.getRunningHistoricActivityInstances(this.pastDate(), null, 3);
        MatcherAssert.assertThat((Object)runningHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void resultIsSortedByStartTime() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask").endEvent("endEvent").done();
        this.testHelper.deploy(simpleDefinition);
        ClockUtil.setCurrentTime((Date)new Date());
        ProcessInstance firstProcessInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.shiftTimeByOneMinute();
        ProcessInstance secondProcessInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        this.shiftTimeByOneMinute();
        ProcessInstance thirdProcessInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        List runningHistoricActivityInstances = this.optimizeService.getRunningHistoricActivityInstances(this.pastDate(), null, 4);
        MatcherAssert.assertThat((Object)runningHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((HistoricActivityInstance)runningHistoricActivityInstances.get(0)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)firstProcessInstance.getId()));
        MatcherAssert.assertThat((Object)((HistoricActivityInstance)runningHistoricActivityInstances.get(1)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)secondProcessInstance.getId()));
        MatcherAssert.assertThat((Object)((HistoricActivityInstance)runningHistoricActivityInstances.get(2)).getProcessInstanceId(), (Matcher)CoreMatchers.is((Object)thirdProcessInstance.getId()));
    }

    public void shiftTimeByOneMinute() {
        Long oneMinute = 60000L;
        Date shiftedTimeByOneMinute = new Date(ClockUtil.getCurrentTime().getTime() + oneMinute);
        ClockUtil.setCurrentTime((Date)shiftedTimeByOneMinute);
    }

    @Test
    public void fetchOnlyRunningActivities() {
        BpmnModelInstance simpleDefinition = Bpmn.createExecutableProcess((String)"process").startEvent("startEvent").userTask("userTask").endEvent().done();
        this.testHelper.deploy(simpleDefinition);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
        List runningHistoricActivityInstances = this.optimizeService.getRunningHistoricActivityInstances(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)runningHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((HistoricActivityInstance)runningHistoricActivityInstances.get(0)).getActivityId(), (Matcher)CoreMatchers.is((Object)"userTask"));
        this.completeAllUserTasks();
        runningHistoricActivityInstances = this.optimizeService.getRunningHistoricActivityInstances(this.pastDate(), null, 10);
        MatcherAssert.assertThat((Object)runningHistoricActivityInstances.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    private Date pastDate() {
        return new Date(2L);
    }

    private void completeAllUserTasks() {
        List list = this.taskService.createTaskQuery().list();
        for (Task task : list) {
            this.taskService.claim(task.getId(), this.userId);
            this.taskService.complete(task.getId());
        }
    }

    protected void createUser(String userId) {
        User user = this.identityService.newUser(userId);
        this.identityService.saveUser(user);
    }

    private void assertThatActivitiesHaveAllImportantInformation(HistoricActivityInstance activityInstance) {
        MatcherAssert.assertThat((Object)activityInstance, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)activityInstance.getActivityName(), (Matcher)CoreMatchers.is((Object)"task"));
        MatcherAssert.assertThat((Object)activityInstance.getActivityType(), (Matcher)CoreMatchers.is((Object)"userTask"));
        MatcherAssert.assertThat((Object)activityInstance.getStartTime(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)activityInstance.getEndTime(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)activityInstance.getProcessDefinitionKey(), (Matcher)CoreMatchers.is((Object)"process"));
        MatcherAssert.assertThat((Object)activityInstance.getProcessDefinitionId(), (Matcher)CoreMatchers.notNullValue());
    }
}

