/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.query.Query;

public abstract class AbstractDefinitionQueryTest
extends PluggableProcessEngineTestCase {
    protected String deploymentOneId;
    protected String deploymentTwoId;

    protected void setUp() throws Exception {
        this.deploymentOneId = this.repositoryService.createDeployment().name("firstDeployment").addClasspathResource(this.getResourceOnePath()).addClasspathResource(this.getResourceTwoPath()).deploy().getId();
        this.deploymentTwoId = this.repositoryService.createDeployment().name("secondDeployment").addClasspathResource(this.getResourceOnePath()).deploy().getId();
        super.setUp();
    }

    protected abstract String getResourceOnePath();

    protected abstract String getResourceTwoPath();

    protected void tearDown() throws Exception {
        super.tearDown();
        this.repositoryService.deleteDeployment(this.deploymentOneId, true);
        this.repositoryService.deleteDeployment(this.deploymentTwoId, true);
    }

    protected void verifyQueryResults(Query query, int countExpected) {
        AbstractDefinitionQueryTest.assertEquals((int)countExpected, (int)query.list().size());
        AbstractDefinitionQueryTest.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            AbstractDefinitionQueryTest.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            AbstractDefinitionQueryTest.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(Query query) {
        try {
            query.singleResult();
            AbstractDefinitionQueryTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }
}

