/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.util.Collection;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.Event;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.StartEvent;

public class BpmnModelInstanceCmdTest
extends PluggableProcessEngineTestCase {
    private static final String PROCESS_KEY = "one";

    @Deployment(resources={"org/camunda/bpm/engine/test/repository/one.bpmn20.xml"})
    public void testRepositoryService() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(PROCESS_KEY).singleResult()).getId();
        BpmnModelInstance modelInstance = this.repositoryService.getBpmnModelInstance(processDefinitionId);
        BpmnModelInstanceCmdTest.assertNotNull((Object)modelInstance);
        Collection events = modelInstance.getModelElementsByType(modelInstance.getModel().getType(Event.class));
        BpmnModelInstanceCmdTest.assertEquals((int)2, (int)events.size());
        Collection sequenceFlows = modelInstance.getModelElementsByType(modelInstance.getModel().getType(SequenceFlow.class));
        BpmnModelInstanceCmdTest.assertEquals((int)1, (int)sequenceFlows.size());
        StartEvent startEvent = (StartEvent)modelInstance.getModelElementById("start");
        BpmnModelInstanceCmdTest.assertNotNull((Object)startEvent);
    }
}

