/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.RepositoryServiceImpl;
import org.camunda.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.camunda.bpm.engine.impl.cfg.StandaloneProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.history.event.UserOperationLogEntryEventEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.deploy.cache.DeploymentCache;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinitionQuery;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.bpmn.tasklistener.util.RecorderTaskListener;
import org.camunda.bpm.engine.test.util.TestExecutionListener;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;

public class RepositoryServiceTest
extends PluggableProcessEngineTestCase {
    private static final String NAMESPACE = "xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL'";
    private static final String TARGET_NAMESPACE = "targetNamespace='" + BpmnParse.CAMUNDA_BPMN_EXTENSIONS_NS + "'";

    public void tearDown() throws Exception {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("activate-processdefinition");
                return null;
            }
        });
    }

    private void checkDeployedBytes(InputStream deployedResource, byte[] utf8Bytes) throws IOException {
        byte[] deployedBytes = new byte[utf8Bytes.length];
        deployedResource.read(deployedBytes);
        for (int i = 0; i < utf8Bytes.length; ++i) {
            RepositoryServiceTest.assertEquals((byte)utf8Bytes[i], (byte)deployedBytes[i]);
        }
    }

    public void testUTF8DeploymentMethod() throws IOException {
        Charset utf8Charset = Charset.forName("UTF-8");
        Charset defaultCharset = this.processEngineConfiguration.getDefaultCharset();
        this.processEngineConfiguration.setDefaultCharset(utf8Charset);
        String umlautsString = "\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df";
        String resourceName = "deployment.bpmn";
        BpmnModelInstance instance = Bpmn.createExecutableProcess((String)"umlautsProcess").startEvent(umlautsString).done();
        String instanceAsString = Bpmn.convertToString((BpmnModelInstance)instance);
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addString(resourceName, instanceAsString).deploy();
        InputStream inputStream = this.repositoryService.getResourceAsStream(deployment.getId(), resourceName);
        byte[] utf8Bytes = instanceAsString.getBytes(utf8Charset);
        this.checkDeployedBytes(inputStream, utf8Bytes);
        this.repositoryService.deleteDeployment(deployment.getId());
        deployment = this.repositoryService.createDeployment().addModelInstance(resourceName, instance).deploy();
        inputStream = this.repositoryService.getResourceAsStream(deployment.getId(), resourceName);
        this.checkDeployedBytes(inputStream, utf8Bytes);
        this.repositoryService.deleteDeployment(deployment.getId());
        this.processEngineConfiguration.setDefaultCharset(defaultCharset);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testStartProcessInstanceById() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        RepositoryServiceTest.assertEquals((int)1, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        RepositoryServiceTest.assertEquals((String)"oneTaskProcess", (String)processDefinition.getKey());
        RepositoryServiceTest.assertNotNull((Object)processDefinition.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testFindProcessDefinitionById() {
        List definitions = this.repositoryService.createProcessDefinitionQuery().list();
        RepositoryServiceTest.assertEquals((int)1, (int)definitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(((ProcessDefinition)definitions.get(0)).getId()).singleResult();
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        RepositoryServiceTest.assertNotNull((Object)processDefinition);
        RepositoryServiceTest.assertEquals((String)"oneTaskProcess", (String)processDefinition.getKey());
        RepositoryServiceTest.assertEquals((String)"The One Task Process", (String)processDefinition.getName());
        processDefinition = this.repositoryService.getProcessDefinition(((ProcessDefinition)definitions.get(0)).getId());
        RepositoryServiceTest.assertEquals((String)"This is a process for testing purposes", (String)processDefinition.getDescription());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteDeploymentWithRunningInstances() {
        block2: {
            List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
            RepositoryServiceTest.assertEquals((int)1, (int)processDefinitions.size());
            ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
            this.runtimeService.startProcessInstanceById(processDefinition.getId());
            try {
                this.repositoryService.deleteDeployment(processDefinition.getDeploymentId());
                RepositoryServiceTest.fail((String)"Exception expected");
            }
            catch (ProcessEngineException pee) {
                if ($assertionsDisabled || pee.getMessage().contains("Deletion of process definition without cascading failed.")) break block2;
                throw new AssertionError();
            }
        }
    }

    public void testDeleteDeploymentSkipCustomListeners() {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/RepositoryServiceTest.testDeleteProcessInstanceSkipCustomListeners.bpmn20.xml");
        String deploymentId = deploymentBuilder.deploy().getId();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.repositoryService.deleteDeployment(deploymentId, true, false);
        RepositoryServiceTest.assertEquals((int)1, (int)TestExecutionListener.collectedEvents.size());
        TestExecutionListener.reset();
        deploymentId = deploymentBuilder.deploy().getId();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.repositoryService.deleteDeployment(deploymentId, true, true);
        RepositoryServiceTest.assertTrue((boolean)TestExecutionListener.collectedEvents.isEmpty());
        TestExecutionListener.reset();
    }

    public void testDeleteDeploymentSkipCustomTaskListeners() {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/RepositoryServiceTest.testDeleteProcessInstanceSkipCustomTaskListeners.bpmn20.xml");
        String deploymentId = deploymentBuilder.deploy().getId();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        RecorderTaskListener.getRecordedEvents().clear();
        this.repositoryService.deleteDeployment(deploymentId, true, false);
        RepositoryServiceTest.assertEquals((int)1, (int)RecorderTaskListener.getRecordedEvents().size());
        RecorderTaskListener.clear();
        deploymentId = deploymentBuilder.deploy().getId();
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.repositoryService.deleteDeployment(deploymentId, true, true);
        RepositoryServiceTest.assertTrue((boolean)RecorderTaskListener.getRecordedEvents().isEmpty());
        RecorderTaskListener.clear();
    }

    public void testDeleteDeploymentSkipIoMappings() {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/RepositoryServiceTest.testDeleteDeploymentSkipIoMappings.bpmn20.xml");
        String deploymentId = deploymentBuilder.deploy().getId();
        this.runtimeService.startProcessInstanceByKey("ioMappingProcess");
        try {
            this.repositoryService.deleteDeployment(deploymentId, true, false, true);
        }
        catch (Exception e) {
            throw new ProcessEngineException("Exception is not expected when deleting deployment with running process", (Throwable)e);
        }
    }

    public void testDeleteDeploymentWithoutSkipIoMappings() {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/RepositoryServiceTest.testDeleteDeploymentSkipIoMappings.bpmn20.xml");
        String deploymentId = deploymentBuilder.deploy().getId();
        this.runtimeService.startProcessInstanceByKey("ioMappingProcess");
        try {
            this.repositoryService.deleteDeployment(deploymentId, true, false, false);
            RepositoryServiceTest.fail((String)"Exception expected");
        }
        catch (Exception e) {
            this.assertTextPresent("Exception when output mapping is executed", e.getMessage());
        }
        this.repositoryService.deleteDeployment(deploymentId, true, false, true);
    }

    public void testDeleteDeploymentNullDeploymentId() {
        try {
            this.repositoryService.deleteDeployment(null);
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("deploymentId is null", ae.getMessage());
        }
    }

    public void testDeleteDeploymentCascadeNullDeploymentId() {
        try {
            this.repositoryService.deleteDeployment(null, true);
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("deploymentId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteDeploymentCascadeWithRunningInstances() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        RepositoryServiceTest.assertEquals((int)1, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        this.runtimeService.startProcessInstanceById(processDefinition.getId());
        this.repositoryService.deleteDeployment(processDefinition.getDeploymentId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/repository/one.cmmn"})
    public void testDeleteDeploymentClearsCache() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.repositoryService.getCmmnModelInstance(caseDefinitionId);
        DeploymentCache deploymentCache = this.processEngineConfiguration.getDeploymentCache();
        RepositoryServiceTest.assertNotNull((Object)deploymentCache.getProcessDefinitionCache().get((Object)processDefinitionId));
        RepositoryServiceTest.assertNotNull((Object)deploymentCache.getBpmnModelInstanceCache().get((Object)processDefinitionId));
        RepositoryServiceTest.assertNotNull((Object)deploymentCache.getCaseDefinitionCache().get((Object)caseDefinitionId));
        RepositoryServiceTest.assertNotNull((Object)deploymentCache.getCmmnModelInstanceCache().get((Object)caseDefinitionId));
        this.repositoryService.deleteDeployment(this.deploymentId, true);
        RepositoryServiceTest.assertNull((Object)deploymentCache.getProcessDefinitionCache().get((Object)processDefinitionId));
        RepositoryServiceTest.assertNull((Object)deploymentCache.getBpmnModelInstanceCache().get((Object)processDefinitionId));
        RepositoryServiceTest.assertNull((Object)deploymentCache.getCaseDefinitionCache().get((Object)caseDefinitionId));
        RepositoryServiceTest.assertNull((Object)deploymentCache.getCmmnModelInstanceCache().get((Object)caseDefinitionId));
    }

    public void testFindDeploymentResourceNamesNullDeploymentId() {
        try {
            this.repositoryService.getDeploymentResourceNames(null);
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("deploymentId is null", ae.getMessage());
        }
    }

    public void testFindDeploymentResourcesNullDeploymentId() {
        try {
            this.repositoryService.getDeploymentResources(null);
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("deploymentId is null", e.getMessage());
        }
    }

    public void testDeploymentWithDelayedProcessDefinitionActivation() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        Date inThreeDays = new Date(startTime.getTime() + 259200000L);
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml").activateProcessDefinitionsOn(inThreeDays).deploy();
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        RepositoryServiceTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        try {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            RepositoryServiceTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresentIgnoreCase("suspended", e.getMessage());
        }
        List jobs = this.managementService.createJobQuery().list();
        this.managementService.executeJob(((Job)jobs.get(0)).getId());
        this.managementService.executeJob(((Job)jobs.get(1)).getId());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        RepositoryServiceTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)2L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        RepositoryServiceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    public void testDeploymentWithDelayedProcessDefinitionAndJobDefinitionActivation() {
        Date startTime = new Date();
        ClockUtil.setCurrentTime((Date)startTime);
        Date inThreeDays = new Date(startTime.getTime() + 259200000L);
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/oneAsyncTask.bpmn").activateProcessDefinitionsOn(inThreeDays).deploy();
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().active().count());
        try {
            this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
            RepositoryServiceTest.fail();
        }
        catch (ProcessEngineException e) {
            this.assertTextPresentIgnoreCase("suspended", e.getMessage());
        }
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createDeploymentQuery().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.repositoryService.createProcessDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().active().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)this.managementService.createJobDefinitionQuery().suspended().count());
        RepositoryServiceTest.assertEquals((long)1L, (long)this.managementService.createJobDefinitionQuery().active().count());
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        RepositoryServiceTest.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().count());
        this.repositoryService.deleteDeployment(deployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetResourceAsStreamUnexistingResourceInExistingDeployment() {
        org.camunda.bpm.engine.repository.Deployment deployment = (org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        try {
            this.repositoryService.getResourceAsStream(deployment.getId(), "org/camunda/bpm/engine/test/api/unexistingProcess.bpmn.xml");
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("no resource found with name", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetResourceAsStreamUnexistingDeployment() {
        try {
            this.repositoryService.getResourceAsStream("unexistingdeployment", "org/camunda/bpm/engine/test/api/unexistingProcess.bpmn.xml");
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("no resource found with name", ae.getMessage());
        }
    }

    public void testGetResourceAsStreamNullArguments() {
        try {
            this.repositoryService.getResourceAsStream(null, "resource");
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("deploymentId is null", ae.getMessage());
        }
        try {
            this.repositoryService.getResourceAsStream("deployment", null);
            RepositoryServiceTest.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("resourceName is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/repository/one.cmmn"})
    public void testGetCaseDefinition() {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        CaseDefinition caseDefinition = (CaseDefinition)query.singleResult();
        String caseDefinitionId = caseDefinition.getId();
        CaseDefinition definition = this.repositoryService.getCaseDefinition(caseDefinitionId);
        RepositoryServiceTest.assertNotNull((Object)definition);
        RepositoryServiceTest.assertEquals((String)caseDefinitionId, (String)definition.getId());
    }

    public void testGetCaseDefinitionByInvalidId() {
        try {
            this.repositoryService.getCaseDefinition("invalid");
        }
        catch (NotFoundException e) {
            this.assertTextPresent("no deployed case definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getCaseDefinition(null);
            RepositoryServiceTest.fail();
        }
        catch (NotValidException e) {
            this.assertTextPresent("caseDefinitionId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/repository/one.cmmn"})
    public void testGetCaseModel() throws Exception {
        CaseDefinitionQuery query = this.repositoryService.createCaseDefinitionQuery();
        CaseDefinition caseDefinition = (CaseDefinition)query.singleResult();
        String caseDefinitionId = caseDefinition.getId();
        InputStream caseModel = this.repositoryService.getCaseModel(caseDefinitionId);
        RepositoryServiceTest.assertNotNull((Object)caseModel);
        byte[] readInputStream = IoUtil.readInputStream((InputStream)caseModel, (String)"caseModel");
        String model = new String(readInputStream, "UTF-8");
        RepositoryServiceTest.assertTrue((boolean)model.contains("<case id=\"one\" name=\"One\">"));
        IoUtil.closeSilently((Closeable)caseModel);
    }

    public void testGetCaseModelByInvalidId() throws Exception {
        try {
            this.repositoryService.getCaseModel("invalid");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("no deployed case definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getCaseModel(null);
            RepositoryServiceTest.fail();
        }
        catch (NotValidException e) {
            this.assertTextPresent("caseDefinitionId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/repository/one.dmn"})
    public void testGetDecisionDefinition() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        String decisionDefinitionId = decisionDefinition.getId();
        DecisionDefinition definition = this.repositoryService.getDecisionDefinition(decisionDefinitionId);
        RepositoryServiceTest.assertNotNull((Object)definition);
        RepositoryServiceTest.assertEquals((String)decisionDefinitionId, (String)definition.getId());
    }

    public void testGetDecisionDefinitionByInvalidId() {
        try {
            this.repositoryService.getDecisionDefinition("invalid");
            RepositoryServiceTest.fail();
        }
        catch (NotFoundException e) {
            this.assertTextPresent("no deployed decision definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getDecisionDefinition(null);
            RepositoryServiceTest.fail();
        }
        catch (NotValidException e) {
            this.assertTextPresent("decisionDefinitionId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/repository/drg.dmn"})
    public void testGetDecisionRequirementsDefinition() {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)query.singleResult();
        String decisionRequirementsDefinitionId = decisionRequirementsDefinition.getId();
        DecisionRequirementsDefinition definition = this.repositoryService.getDecisionRequirementsDefinition(decisionRequirementsDefinitionId);
        RepositoryServiceTest.assertNotNull((Object)definition);
        RepositoryServiceTest.assertEquals((String)decisionRequirementsDefinitionId, (String)definition.getId());
    }

    public void testGetDecisionRequirementsDefinitionByInvalidId() {
        try {
            this.repositoryService.getDecisionRequirementsDefinition("invalid");
            RepositoryServiceTest.fail();
        }
        catch (Exception e) {
            this.assertTextPresent("no deployed decision requirements definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getDecisionRequirementsDefinition(null);
            RepositoryServiceTest.fail();
        }
        catch (NotValidException e) {
            this.assertTextPresent("decisionRequirementsDefinitionId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/repository/one.dmn"})
    public void testGetDecisionModel() throws Exception {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        String decisionDefinitionId = decisionDefinition.getId();
        InputStream decisionModel = this.repositoryService.getDecisionModel(decisionDefinitionId);
        RepositoryServiceTest.assertNotNull((Object)decisionModel);
        byte[] readInputStream = IoUtil.readInputStream((InputStream)decisionModel, (String)"decisionModel");
        String model = new String(readInputStream, "UTF-8");
        RepositoryServiceTest.assertTrue((boolean)model.contains("<decision id=\"one\" name=\"One\">"));
        IoUtil.closeSilently((Closeable)decisionModel);
    }

    public void testGetDecisionModelByInvalidId() throws Exception {
        try {
            this.repositoryService.getDecisionModel("invalid");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("no deployed decision definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getDecisionModel(null);
            RepositoryServiceTest.fail();
        }
        catch (NotValidException e) {
            this.assertTextPresent("decisionDefinitionId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/repository/drg.dmn"})
    public void testGetDecisionRequirementsModel() throws Exception {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)query.singleResult();
        String decisionRequirementsDefinitionId = decisionRequirementsDefinition.getId();
        InputStream decisionRequirementsModel = this.repositoryService.getDecisionRequirementsModel(decisionRequirementsDefinitionId);
        RepositoryServiceTest.assertNotNull((Object)decisionRequirementsModel);
        byte[] readInputStream = IoUtil.readInputStream((InputStream)decisionRequirementsModel, (String)"decisionRequirementsModel");
        String model = new String(readInputStream, "UTF-8");
        RepositoryServiceTest.assertTrue((boolean)model.contains("<definitions id=\"dish\" name=\"Dish\" namespace=\"test-drg\""));
        IoUtil.closeSilently((Closeable)decisionRequirementsModel);
    }

    public void testGetDecisionRequirementsModelByInvalidId() throws Exception {
        try {
            this.repositoryService.getDecisionRequirementsModel("invalid");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("no deployed decision requirements definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getDecisionRequirementsModel(null);
            RepositoryServiceTest.fail();
        }
        catch (NotValidException e) {
            this.assertTextPresent("decisionRequirementsDefinitionId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/repository/drg.dmn", "org/camunda/bpm/engine/test/repository/drg.png"})
    public void testGetDecisionRequirementsDiagram() throws Exception {
        DecisionRequirementsDefinitionQuery query = this.repositoryService.createDecisionRequirementsDefinitionQuery();
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)query.singleResult();
        String decisionRequirementsDefinitionId = decisionRequirementsDefinition.getId();
        InputStream actualDrd = this.repositoryService.getDecisionRequirementsDiagram(decisionRequirementsDefinitionId);
        RepositoryServiceTest.assertNotNull((Object)actualDrd);
    }

    public void testGetDecisionRequirementsDiagramByInvalidId() throws Exception {
        try {
            this.repositoryService.getDecisionRequirementsDiagram("invalid");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("no deployed decision requirements definition found with id 'invalid'", e.getMessage());
        }
        try {
            this.repositoryService.getDecisionRequirementsDiagram(null);
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("decisionRequirementsDefinitionId is null", e.getMessage());
        }
    }

    public void testDeployRevisedProcessAfterDeleteOnOtherProcessEngine() {
        ProcessEngine processEngine1 = new StandaloneProcessEngineConfiguration().setProcessEngineName("reboot-test-schema").setDatabaseSchemaUpdate("true").setJdbcUrl("jdbc:h2:mem:activiti-process-cache-test;DB_CLOSE_DELAY=1000").setJobExecutorActivate(false).buildProcessEngine();
        RepositoryService repositoryService1 = processEngine1.getRepositoryService();
        ProcessEngine processEngine2 = new StandaloneProcessEngineConfiguration().setProcessEngineName("reboot-test").setDatabaseSchemaUpdate("false").setJdbcUrl("jdbc:h2:mem:activiti-process-cache-test;DB_CLOSE_DELAY=1000").setJobExecutorActivate(false).buildProcessEngine();
        RepositoryService repositoryService2 = processEngine2.getRepositoryService();
        RuntimeService runtimeService2 = processEngine2.getRuntimeService();
        TaskService taskService2 = processEngine2.getTaskService();
        String deploymentId = repositoryService1.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/RepositoryServiceTest.testDeployRevisedProcessAfterDeleteOnOtherProcessEngine.v1.bpmn20.xml").deploy().getId();
        String processDefinitionId = ((ProcessDefinition)repositoryService2.createProcessDefinitionQuery().singleResult()).getId();
        runtimeService2.startProcessInstanceById(processDefinitionId);
        Task task = (Task)taskService2.createTaskQuery().singleResult();
        RepositoryServiceTest.assertEquals((String)"original task", (String)task.getName());
        repositoryService2.deleteDeployment(deploymentId, true);
        RepositoryServiceTest.assertEquals((long)0L, (long)repositoryService2.createDeploymentQuery().count());
        RepositoryServiceTest.assertEquals((long)0L, (long)runtimeService2.createProcessInstanceQuery().count());
        deploymentId = repositoryService1.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/RepositoryServiceTest.testDeployRevisedProcessAfterDeleteOnOtherProcessEngine.v2.bpmn20.xml").deploy().getId();
        processDefinitionId = ((ProcessDefinition)repositoryService2.createProcessDefinitionQuery().singleResult()).getId();
        runtimeService2.startProcessInstanceByKey("oneTaskProcess");
        task = (Task)taskService2.createTaskQuery().singleResult();
        RepositoryServiceTest.assertEquals((String)"revised task", (String)task.getName());
        repositoryService1.deleteDeployment(deploymentId, true);
        processEngine1.close();
        processEngine2.close();
    }

    public void testDeploymentPersistence() {
        org.camunda.bpm.engine.repository.Deployment deployment = this.repositoryService.createDeployment().name("strings").addString("org/camunda/bpm/engine/test/test/HelloWorld.string", "hello world").addString("org/camunda/bpm/engine/test/test/TheAnswer.string", "42").deploy();
        List deployments = this.repositoryService.createDeploymentQuery().list();
        RepositoryServiceTest.assertEquals((int)1, (int)deployments.size());
        deployment = (org.camunda.bpm.engine.repository.Deployment)deployments.get(0);
        RepositoryServiceTest.assertEquals((String)"strings", (String)deployment.getName());
        RepositoryServiceTest.assertNotNull((Object)deployment.getDeploymentTime());
        String deploymentId = deployment.getId();
        List resourceNames = this.repositoryService.getDeploymentResourceNames(deploymentId);
        HashSet<String> expectedResourceNames = new HashSet<String>();
        expectedResourceNames.add("org/camunda/bpm/engine/test/test/HelloWorld.string");
        expectedResourceNames.add("org/camunda/bpm/engine/test/test/TheAnswer.string");
        RepositoryServiceTest.assertEquals(expectedResourceNames, new HashSet(resourceNames));
        InputStream resourceStream = this.repositoryService.getResourceAsStream(deploymentId, "org/camunda/bpm/engine/test/test/HelloWorld.string");
        RepositoryServiceTest.assertTrue((boolean)Arrays.equals("hello world".getBytes(), IoUtil.readInputStream((InputStream)resourceStream, (String)"test")));
        resourceStream = this.repositoryService.getResourceAsStream(deploymentId, "org/camunda/bpm/engine/test/test/TheAnswer.string");
        RepositoryServiceTest.assertTrue((boolean)Arrays.equals("42".getBytes(), IoUtil.readInputStream((InputStream)resourceStream, (String)"test")));
        this.repositoryService.deleteDeployment(deploymentId);
    }

    public void testProcessDefinitionPersistence() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/processOne.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/repository/processTwo.bpmn20.xml").deploy().getId();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        RepositoryServiceTest.assertEquals((int)2, (int)processDefinitions.size());
        this.repositoryService.deleteDeployment(deploymentId);
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    public void testDecisionDefinitionUpdateTimeToLiveWithUserOperationLog() {
        this.identityService.setAuthenticatedUserId("userId");
        DecisionDefinition decisionDefinition = this.findOnlyDecisionDefinition();
        Integer orgTtl = decisionDefinition.getHistoryTimeToLive();
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinition.getId(), Integer.valueOf(6));
        decisionDefinition = this.findOnlyDecisionDefinition();
        RepositoryServiceTest.assertEquals((int)6, (int)decisionDefinition.getHistoryTimeToLive());
        UserOperationLogQuery operationLogQuery = this.historyService.createUserOperationLogQuery().operationType("UpdateHistoryTimeToLive").entityType("DecisionDefinition");
        UserOperationLogEntry ttlEntry = (UserOperationLogEntry)operationLogQuery.property("historyTimeToLive").singleResult();
        UserOperationLogEntry definitionIdEntry = (UserOperationLogEntry)operationLogQuery.property("decisionDefinitionId").singleResult();
        UserOperationLogEntry definitionKeyEntry = (UserOperationLogEntry)operationLogQuery.property("decisionDefinitionKey").singleResult();
        RepositoryServiceTest.assertNotNull((Object)ttlEntry);
        RepositoryServiceTest.assertNotNull((Object)definitionIdEntry);
        RepositoryServiceTest.assertNotNull((Object)definitionKeyEntry);
        RepositoryServiceTest.assertEquals((String)orgTtl.toString(), (String)ttlEntry.getOrgValue());
        RepositoryServiceTest.assertEquals((String)"6", (String)ttlEntry.getNewValue());
        RepositoryServiceTest.assertEquals((String)decisionDefinition.getId(), (String)definitionIdEntry.getNewValue());
        RepositoryServiceTest.assertEquals((String)decisionDefinition.getKey(), (String)definitionKeyEntry.getNewValue());
        RepositoryServiceTest.assertEquals((String)"Operator", (String)ttlEntry.getCategory());
        RepositoryServiceTest.assertEquals((String)"Operator", (String)definitionIdEntry.getCategory());
        RepositoryServiceTest.assertEquals((String)"Operator", (String)definitionKeyEntry.getCategory());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    public void testDecisionDefinitionUpdateTimeToLiveNull() {
        DecisionDefinition decisionDefinition = this.findOnlyDecisionDefinition();
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinition.getId(), null);
        decisionDefinition = (DecisionDefinitionEntity)this.repositoryService.getDecisionDefinition(decisionDefinition.getId());
        RepositoryServiceTest.assertEquals(null, (Object)decisionDefinition.getHistoryTimeToLive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/Example.dmn"})
    public void testDecisionDefinitionUpdateTimeToLiveNegative() {
        DecisionDefinition decisionDefinition = this.findOnlyDecisionDefinition();
        try {
            this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinition.getId(), Integer.valueOf(-1));
            RepositoryServiceTest.fail((String)"Exception is expected, that negative value is not allowed.");
        }
        catch (BadUserRequestException ex) {
            RepositoryServiceTest.assertTrue((boolean)ex.getMessage().contains("greater than"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessDefinitionUpdateTimeToLive() {
        ProcessDefinition processDefinition = this.findOnlyProcessDefinition();
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(processDefinition.getId(), Integer.valueOf(6));
        processDefinition = this.findOnlyProcessDefinition();
        RepositoryServiceTest.assertEquals((int)6, (int)processDefinition.getHistoryTimeToLive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessDefinitionUpdateTimeToLiveNull() {
        ProcessDefinition processDefinition = this.findOnlyProcessDefinition();
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(processDefinition.getId(), null);
        processDefinition = this.findOnlyProcessDefinition();
        RepositoryServiceTest.assertEquals(null, (Object)processDefinition.getHistoryTimeToLive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessDefinitionUpdateTimeToLiveNegative() {
        ProcessDefinition processDefinition = this.findOnlyProcessDefinition();
        try {
            this.repositoryService.updateProcessDefinitionHistoryTimeToLive(processDefinition.getId(), Integer.valueOf(-1));
            RepositoryServiceTest.fail((String)"Exception is expected, that negative value is not allowed.");
        }
        catch (BadUserRequestException ex) {
            RepositoryServiceTest.assertTrue((boolean)ex.getMessage().contains("greater than"));
        }
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessDefinitionUpdateHistoryTimeToLiveWithUserOperationLog() {
        ProcessDefinition processDefinition = this.findOnlyProcessDefinition();
        Integer timeToLiveOrgValue = processDefinition.getHistoryTimeToLive();
        this.processEngine.getIdentityService().setAuthenticatedUserId("userId");
        Integer timeToLiveNewValue = 6;
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(processDefinition.getId(), timeToLiveNewValue);
        List opLogEntries = this.processEngine.getHistoryService().createUserOperationLogQuery().list();
        Assert.assertEquals((long)1L, (long)opLogEntries.size());
        UserOperationLogEntryEventEntity userOperationLogEntry = (UserOperationLogEntryEventEntity)opLogEntries.get(0);
        RepositoryServiceTest.assertEquals((String)"UpdateHistoryTimeToLive", (String)userOperationLogEntry.getOperationType());
        RepositoryServiceTest.assertEquals((String)processDefinition.getKey(), (String)userOperationLogEntry.getProcessDefinitionKey());
        RepositoryServiceTest.assertEquals((String)processDefinition.getId(), (String)userOperationLogEntry.getProcessDefinitionId());
        RepositoryServiceTest.assertEquals((String)"historyTimeToLive", (String)userOperationLogEntry.getProperty());
        RepositoryServiceTest.assertEquals((Object)timeToLiveOrgValue, (Object)Integer.valueOf(userOperationLogEntry.getOrgValue()));
        RepositoryServiceTest.assertEquals((Object)timeToLiveNewValue, (Object)Integer.valueOf(userOperationLogEntry.getNewValue()));
    }

    @RequiredHistoryLevel(value="full")
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testCaseDefinitionUpdateHistoryTimeToLiveWithUserOperationLog() {
        this.identityService.setAuthenticatedUserId("userId");
        CaseDefinition caseDefinition = this.findOnlyCaseDefinition();
        this.repositoryService.updateCaseDefinitionHistoryTimeToLive(caseDefinition.getId(), Integer.valueOf(6));
        caseDefinition = this.findOnlyCaseDefinition();
        RepositoryServiceTest.assertEquals((int)6, (int)caseDefinition.getHistoryTimeToLive());
        UserOperationLogQuery operationLogQuery = this.historyService.createUserOperationLogQuery().operationType("UpdateHistoryTimeToLive").entityType("CaseDefinition").caseDefinitionId(caseDefinition.getId());
        UserOperationLogEntry ttlEntry = (UserOperationLogEntry)operationLogQuery.property("historyTimeToLive").singleResult();
        UserOperationLogEntry definitionKeyEntry = (UserOperationLogEntry)operationLogQuery.property("caseDefinitionKey").singleResult();
        RepositoryServiceTest.assertNotNull((Object)ttlEntry);
        RepositoryServiceTest.assertNotNull((Object)definitionKeyEntry);
        RepositoryServiceTest.assertNull((Object)ttlEntry.getOrgValue());
        RepositoryServiceTest.assertEquals((String)"6", (String)ttlEntry.getNewValue());
        RepositoryServiceTest.assertEquals((String)caseDefinition.getKey(), (String)definitionKeyEntry.getNewValue());
        RepositoryServiceTest.assertEquals((String)"Operator", (String)ttlEntry.getCategory());
        RepositoryServiceTest.assertEquals((String)"Operator", (String)definitionKeyEntry.getCategory());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testUpdateHistoryTimeToLiveNull() {
        CaseDefinition caseDefinition = this.findOnlyCaseDefinition();
        this.repositoryService.updateCaseDefinitionHistoryTimeToLive(caseDefinition.getId(), null);
        caseDefinition = this.findOnlyCaseDefinition();
        RepositoryServiceTest.assertEquals(null, (Object)caseDefinition.getHistoryTimeToLive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testUpdateHistoryTimeToLiveNegative() {
        CaseDefinition caseDefinition = this.findOnlyCaseDefinition();
        try {
            this.repositoryService.updateCaseDefinitionHistoryTimeToLive(caseDefinition.getId(), Integer.valueOf(-1));
            RepositoryServiceTest.fail((String)"Exception is expected, that negative value is not allowed.");
        }
        catch (BadUserRequestException ex) {
            RepositoryServiceTest.assertTrue((boolean)ex.getMessage().contains("greater than"));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testUpdateHistoryTimeToLiveInCache() {
        CaseDefinition caseDefinition = this.findOnlyCaseDefinition();
        RepositoryServiceTest.assertNull((Object)caseDefinition.getHistoryTimeToLive());
        this.repositoryService.updateCaseDefinitionHistoryTimeToLive(caseDefinition.getId(), Integer.valueOf(10));
        CaseDefinition definition = this.repositoryService.getCaseDefinition(caseDefinition.getId());
        RepositoryServiceTest.assertEquals((Object)10, (Object)definition.getHistoryTimeToLive());
    }

    private CaseDefinition findOnlyCaseDefinition() {
        List caseDefinitions = this.repositoryService.createCaseDefinitionQuery().list();
        RepositoryServiceTest.assertNotNull((Object)caseDefinitions);
        RepositoryServiceTest.assertEquals((int)1, (int)caseDefinitions.size());
        return (CaseDefinition)caseDefinitions.get(0);
    }

    private ProcessDefinition findOnlyProcessDefinition() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        RepositoryServiceTest.assertNotNull((Object)processDefinitions);
        RepositoryServiceTest.assertEquals((int)1, (int)processDefinitions.size());
        return (ProcessDefinition)processDefinitions.get(0);
    }

    private DecisionDefinition findOnlyDecisionDefinition() {
        List decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().list();
        RepositoryServiceTest.assertNotNull((Object)decisionDefinitions);
        RepositoryServiceTest.assertEquals((int)1, (int)decisionDefinitions.size());
        return (DecisionDefinition)decisionDefinitions.get(0);
    }

    public void testProcessDefinitionIntrospection() {
        String deploymentId = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/processOne.bpmn20.xml").deploy().getId();
        String procDefId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        ReadOnlyProcessDefinition processDefinition = ((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(procDefId);
        RepositoryServiceTest.assertEquals((String)procDefId, (String)processDefinition.getId());
        RepositoryServiceTest.assertEquals((String)"Process One", (String)processDefinition.getName());
        RepositoryServiceTest.assertEquals((Object)"the first process", (Object)processDefinition.getProperty("documentation"));
        PvmActivity start = processDefinition.findActivity("start");
        RepositoryServiceTest.assertNotNull((Object)start);
        RepositoryServiceTest.assertEquals((String)"start", (String)start.getId());
        RepositoryServiceTest.assertEquals((Object)"S t a r t", (Object)start.getProperty("name"));
        RepositoryServiceTest.assertEquals((Object)"the start event", (Object)start.getProperty("documentation"));
        RepositoryServiceTest.assertEquals((Object)Collections.EMPTY_LIST, (Object)start.getActivities());
        List outgoingTransitions = start.getOutgoingTransitions();
        RepositoryServiceTest.assertEquals((int)1, (int)outgoingTransitions.size());
        RepositoryServiceTest.assertEquals((Object)"${a == b}", (Object)((PvmTransition)outgoingTransitions.get(0)).getProperty("conditionText"));
        PvmActivity end = processDefinition.findActivity("end");
        RepositoryServiceTest.assertNotNull((Object)end);
        RepositoryServiceTest.assertEquals((String)"end", (String)end.getId());
        PvmTransition transition = (PvmTransition)outgoingTransitions.get(0);
        RepositoryServiceTest.assertEquals((String)"flow1", (String)transition.getId());
        RepositoryServiceTest.assertEquals((Object)"Flow One", (Object)transition.getProperty("name"));
        RepositoryServiceTest.assertEquals((Object)"The only transitions in the process", (Object)transition.getProperty("documentation"));
        RepositoryServiceTest.assertSame((Object)start, (Object)transition.getSource());
        RepositoryServiceTest.assertSame((Object)end, (Object)transition.getDestination());
        this.repositoryService.deleteDeployment(deploymentId);
    }

    public void testProcessDefinitionQuery() {
        String deployment1Id = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/processOne.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/repository/processTwo.bpmn20.xml").deploy().getId();
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionName().asc()).orderByProcessDefinitionVersion().asc()).list();
        RepositoryServiceTest.assertEquals((int)2, (int)processDefinitions.size());
        String deployment2Id = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/processOne.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/repository/processTwo.bpmn20.xml").deploy().getId();
        RepositoryServiceTest.assertEquals((long)4L, (long)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionName().asc()).count());
        RepositoryServiceTest.assertEquals((long)2L, (long)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().latestVersion().orderByProcessDefinitionName().asc()).count());
        this.deleteDeployments(Arrays.asList(deployment1Id, deployment2Id));
    }

    public void testGetProcessDefinitions() {
        ArrayList<String> deploymentIds = new ArrayList<String>();
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' " + TARGET_NAMESPACE + ">  <process id='IDR' name='Insurance Damage Report 1' isExecutable='true' /></definitions>"));
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' " + TARGET_NAMESPACE + ">  <process id='IDR' name='Insurance Damage Report 2' isExecutable='true' /></definitions>"));
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' " + TARGET_NAMESPACE + ">  <process id='IDR' name='Insurance Damage Report 3' isExecutable='true' /></definitions>"));
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' " + TARGET_NAMESPACE + ">  <process id='EN' name='Expense Note 1' isExecutable='true' /></definitions>"));
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' " + TARGET_NAMESPACE + ">  <process id='EN' name='Expense Note 2' isExecutable='true' /></definitions>"));
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionKey().asc()).orderByProcessDefinitionVersion().desc()).list();
        RepositoryServiceTest.assertNotNull((Object)processDefinitions);
        RepositoryServiceTest.assertEquals((int)5, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        RepositoryServiceTest.assertEquals((String)"EN", (String)processDefinition.getKey());
        RepositoryServiceTest.assertEquals((String)"Expense Note 2", (String)processDefinition.getName());
        RepositoryServiceTest.assertTrue((boolean)processDefinition.getId().startsWith("EN:2"));
        RepositoryServiceTest.assertEquals((int)2, (int)processDefinition.getVersion());
        processDefinition = (ProcessDefinition)processDefinitions.get(1);
        RepositoryServiceTest.assertEquals((String)"EN", (String)processDefinition.getKey());
        RepositoryServiceTest.assertEquals((String)"Expense Note 1", (String)processDefinition.getName());
        RepositoryServiceTest.assertTrue((boolean)processDefinition.getId().startsWith("EN:1"));
        RepositoryServiceTest.assertEquals((int)1, (int)processDefinition.getVersion());
        processDefinition = (ProcessDefinition)processDefinitions.get(2);
        RepositoryServiceTest.assertEquals((String)"IDR", (String)processDefinition.getKey());
        RepositoryServiceTest.assertEquals((String)"Insurance Damage Report 3", (String)processDefinition.getName());
        RepositoryServiceTest.assertTrue((boolean)processDefinition.getId().startsWith("IDR:3"));
        RepositoryServiceTest.assertEquals((int)3, (int)processDefinition.getVersion());
        processDefinition = (ProcessDefinition)processDefinitions.get(3);
        RepositoryServiceTest.assertEquals((String)"IDR", (String)processDefinition.getKey());
        RepositoryServiceTest.assertEquals((String)"Insurance Damage Report 2", (String)processDefinition.getName());
        RepositoryServiceTest.assertTrue((boolean)processDefinition.getId().startsWith("IDR:2"));
        RepositoryServiceTest.assertEquals((int)2, (int)processDefinition.getVersion());
        processDefinition = (ProcessDefinition)processDefinitions.get(4);
        RepositoryServiceTest.assertEquals((String)"IDR", (String)processDefinition.getKey());
        RepositoryServiceTest.assertEquals((String)"Insurance Damage Report 1", (String)processDefinition.getName());
        RepositoryServiceTest.assertTrue((boolean)processDefinition.getId().startsWith("IDR:1"));
        RepositoryServiceTest.assertEquals((int)1, (int)processDefinition.getVersion());
        this.deleteDeployments(deploymentIds);
    }

    public void testDeployIdenticalProcessDefinitions() {
        ArrayList<String> deploymentIds = new ArrayList<String>();
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' " + TARGET_NAMESPACE + ">  <process id='IDR' name='Insurance Damage Report' isExecutable='true' /></definitions>"));
        deploymentIds.add(this.deployProcessString("<definitions xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL' " + TARGET_NAMESPACE + ">  <process id='IDR' name='Insurance Damage Report' isExecutable='true' /></definitions>"));
        List processDefinitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionKey().asc()).orderByProcessDefinitionVersion().desc()).list();
        RepositoryServiceTest.assertNotNull((Object)processDefinitions);
        RepositoryServiceTest.assertEquals((int)2, (int)processDefinitions.size());
        ProcessDefinition processDefinition = (ProcessDefinition)processDefinitions.get(0);
        RepositoryServiceTest.assertEquals((String)"IDR", (String)processDefinition.getKey());
        RepositoryServiceTest.assertEquals((String)"Insurance Damage Report", (String)processDefinition.getName());
        RepositoryServiceTest.assertTrue((boolean)processDefinition.getId().startsWith("IDR:2"));
        RepositoryServiceTest.assertEquals((int)2, (int)processDefinition.getVersion());
        processDefinition = (ProcessDefinition)processDefinitions.get(1);
        RepositoryServiceTest.assertEquals((String)"IDR", (String)processDefinition.getKey());
        RepositoryServiceTest.assertEquals((String)"Insurance Damage Report", (String)processDefinition.getName());
        RepositoryServiceTest.assertTrue((boolean)processDefinition.getId().startsWith("IDR:1"));
        RepositoryServiceTest.assertEquals((int)1, (int)processDefinition.getVersion());
        this.deleteDeployments(deploymentIds);
    }

    private String deployProcessString(String processString) {
        String resourceName = "xmlString." + BpmnDeployer.BPMN_RESOURCE_SUFFIXES[0];
        return this.repositoryService.createDeployment().addString(resourceName, processString).deploy().getId();
    }

    private void deleteDeployments(Collection<String> deploymentIds) {
        for (String deploymentId : deploymentIds) {
            this.repositoryService.deleteDeployment(deploymentId);
        }
    }
}

