/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class CreateAndResolveIncidentUserOperationLogTest {
    protected ProcessEngineRule engineRule = new ProcessEngineRule(true);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected IdentityService identityService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.historyService = this.engineRule.getHistoryService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Test
    @Ignore(value="prepared for CAM-10146, needs to be filled with further assertions on the entry's content")
    public void shouldLogIncidentCreation() {
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Assert.assertEquals((long)0L, (long)this.historyService.createUserOperationLogQuery().count());
        this.identityService.setAuthenticatedUserId("userId");
        this.runtimeService.createIncident("foo", processInstance.getId(), "aa", "bar");
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)1L, (long)this.historyService.createUserOperationLogQuery().count());
    }

    @Test
    public void shouldNotLogIncidentCreationFailure() {
        Assert.assertEquals((long)0L, (long)this.historyService.createUserOperationLogQuery().count());
        this.thrown.expect(BadUserRequestException.class);
        this.runtimeService.createIncident("foo", null, "userTask1", "bar");
        Assert.assertEquals((long)0L, (long)this.historyService.createUserOperationLogQuery().count());
    }

    @Test
    public void shouldLogIncidentResolution() {
        this.testRule.deploy(ProcessModels.TWO_TASKS_PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process");
        Incident incident = this.runtimeService.createIncident("foo", processInstance.getId(), "userTask1", "bar");
        Assert.assertEquals((long)0L, (long)this.historyService.createUserOperationLogQuery().count());
        this.identityService.setAuthenticatedUserId("userId");
        this.runtimeService.resolveIncident(incident.getId());
        this.identityService.clearAuthentication();
        Assert.assertEquals((long)1L, (long)this.historyService.createUserOperationLogQuery().count());
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assert.assertEquals((Object)"Resolve", (Object)entry.getOperationType());
        Assert.assertEquals((Object)"ProcessInstance", (Object)entry.getEntityType());
        Assert.assertEquals((Object)"Operator", (Object)entry.getCategory());
        Assert.assertEquals((Object)"incidentId", (Object)entry.getProperty());
        Assert.assertNull((Object)entry.getOrgValue());
        Assert.assertEquals((Object)incident.getId(), (Object)entry.getNewValue());
        Assert.assertNull((Object)entry.getExecutionId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)entry.getProcessInstanceId());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)entry.getProcessDefinitionId());
        Assert.assertEquals((Object)"Process", (Object)entry.getProcessDefinitionKey());
    }

    @Test
    public void shouldNotLogIncidentResolutionFailure() {
        Assert.assertEquals((long)0L, (long)this.historyService.createUserOperationLogQuery().count());
        this.thrown.expect(NotFoundException.class);
        this.runtimeService.resolveIncident("foo");
        Assert.assertEquals((long)0L, (long)this.historyService.createUserOperationLogQuery().count());
    }
}

