/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.ActivityStatistics;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ExecutionTree;

public class ProcessInstanceModificationMultiInstanceTest
extends PluggableProcessEngineTestCase {
    public static final String PARALLEL_MULTI_INSTANCE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelTasks.bpmn20.xml";
    public static final String PARALLEL_MULTI_INSTANCE_SUBPROCESS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelSubprocess.bpmn20.xml";
    public static final String SEQUENTIAL_MULTI_INSTANCE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.sequentialTasks.bpmn20.xml";
    public static final String SEQUENTIAL_MULTI_INSTANCE_SUBPROCESS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.sequentialSubprocess.bpmn20.xml";
    public static final String PARALLEL_MULTI_INSTANCE_TASK_COMPLETION_CONDITION_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelTasksCompletionCondition.bpmn20.xml";
    public static final String PARALLEL_MULTI_INSTANCE_SUBPROCESS_COMPLETION_CONDITION_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelSubprocessCompletionCondition.bpmn20.xml";
    public static final String NESTED_PARALLEL_MULTI_INSTANCE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.nestedParallelTasks.bpmn20.xml";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelTasks.bpmn20.xml"})
    public void testStartBeforeMultiInstanceBodyParallelTasks() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miParallelUserTasks");
        this.completeTasksInOrder("beforeTask");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("miTasks#multiInstanceBody")).execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginMiBody("miTasks").activity("miTasks").activity("miTasks").activity("miTasks").endScope().beginMiBody("miTasks").activity("miTasks").activity("miTasks").activity("miTasks").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).concurrent().noScope().child(null).scope().child("miTasks").concurrent().noScope().up().child("miTasks").concurrent().noScope().up().child("miTasks").concurrent().noScope().up().up().up().child(null).concurrent().noScope().child(null).scope().child("miTasks").concurrent().noScope().up().child("miTasks").concurrent().noScope().up().child("miTasks").concurrent().noScope().up().done());
        this.completeTasksInOrder("miTasks", "miTasks", "miTasks", "miTasks", "miTasks", "miTasks", "afterTask", "afterTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelSubprocess.bpmn20.xml"})
    public void testStartBeforeMultiInstanceBodyParallelSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miParallelSubprocess");
        this.completeTasksInOrder("beforeTask");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("miSubProcess#multiInstanceBody")).execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginMiBody("miSubProcess").beginScope("miSubProcess").activity("subProcessTask").endScope().beginScope("miSubProcess").activity("subProcessTask").endScope().beginScope("miSubProcess").activity("subProcessTask").endScope().endScope().beginMiBody("miSubProcess").beginScope("miSubProcess").activity("subProcessTask").endScope().beginScope("miSubProcess").activity("subProcessTask").endScope().beginScope("miSubProcess").activity("subProcessTask").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).concurrent().noScope().child(null).scope().child(null).concurrent().noScope().child("subProcessTask").scope().up().up().child(null).concurrent().noScope().child("subProcessTask").scope().up().up().child(null).concurrent().noScope().child("subProcessTask").scope().up().up().up().up().child(null).concurrent().noScope().child(null).scope().child(null).concurrent().noScope().child("subProcessTask").scope().up().up().child(null).concurrent().noScope().child("subProcessTask").scope().up().up().child(null).concurrent().noScope().child("subProcessTask").scope().done());
        this.completeTasksInOrder("subProcessTask", "subProcessTask", "subProcessTask", "subProcessTask", "subProcessTask", "afterTask", "subProcessTask", "afterTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelTasksCompletionCondition.bpmn20.xml"})
    public void testStartInnerActivityParallelTasksWithCompletionCondition() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miParallelUserTasksCompletionCondition");
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("miTasks")).startBeforeActivity("miTasks")).execute();
        this.completeTasksInOrder("miTasks", "miTasks", "miTasks", "miTasks");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelSubprocessCompletionCondition.bpmn20.xml"})
    public void testStartInnerActivityParallelSubprocessWithCompletionCondition() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miParallelSubprocessCompletionCondition");
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("miSubProcess")).startBeforeActivity("miSubProcess")).execute();
        this.completeTasksInOrder("subProcessTask", "subProcessTask", "subProcessTask", "subProcessTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.sequentialTasks.bpmn20.xml"})
    public void testStartBeforeMultiInstanceBodySequentialTasks() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miSequentialUserTasks");
        this.completeTasksInOrder("beforeTask");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("miTasks#multiInstanceBody")).execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginMiBody("miTasks").activity("miTasks").endScope().beginMiBody("miTasks").activity("miTasks").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).concurrent().noScope().child("miTasks").scope().up().up().child(null).concurrent().noScope().child("miTasks").scope().done());
        this.completeTasksInOrder("miTasks", "miTasks", "miTasks", "miTasks", "miTasks", "miTasks", "afterTask", "afterTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.sequentialSubprocess.bpmn20.xml"})
    public void testStartBeforeMultiInstanceBodySequentialSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess");
        this.completeTasksInOrder("beforeTask");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("miSubProcess#multiInstanceBody")).execute();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginMiBody("miSubProcess").beginScope("miSubProcess").activity("subProcessTask").endScope().endScope().beginMiBody("miSubProcess").beginScope("miSubProcess").activity("subProcessTask").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).concurrent().noScope().child(null).scope().child("subProcessTask").scope().up().up().up().child(null).concurrent().noScope().child(null).scope().child("subProcessTask").scope().done());
        this.completeTasksInOrder("subProcessTask", "subProcessTask", "subProcessTask", "subProcessTask", "subProcessTask", "subProcessTask", "afterTask", "afterTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelTasks.bpmn20.xml"})
    public void testStartBeforeInnerActivityParallelTasks() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miParallelUserTasks");
        this.completeTasksInOrder("beforeTask");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("miTasks", tree.getActivityInstances("miTasks#multiInstanceBody")[0].getId()).execute();
        List leafExecutions = this.runtimeService.createExecutionQuery().activityId("miTasks").list();
        ProcessInstanceModificationMultiInstanceTest.assertEquals((int)4, (int)leafExecutions.size());
        this.assertVariableSet(leafExecutions, "loopCounter", Arrays.asList(0, 1, 2, 3));
        for (Execution leafExecution : leafExecutions) {
            this.assertVariable(leafExecution, "nrOfInstances", 4);
            this.assertVariable(leafExecution, "nrOfCompletedInstances", 0);
            this.assertVariable(leafExecution, "nrOfActiveInstances", 4);
        }
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginMiBody("miTasks").activity("miTasks").activity("miTasks").activity("miTasks").activity("miTasks").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("miTasks").concurrent().noScope().up().child("miTasks").concurrent().noScope().up().child("miTasks").concurrent().noScope().up().child("miTasks").concurrent().noScope().done());
        this.completeTasksInOrder("miTasks", "miTasks", "miTasks", "miTasks", "afterTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelSubprocess.bpmn20.xml"})
    public void testStartBeforeInnerActivityParallelSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miParallelSubprocess");
        this.completeTasksInOrder("beforeTask");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("miSubProcess", tree.getActivityInstances("miSubProcess#multiInstanceBody")[0].getId()).execute();
        List leafExecutions = this.runtimeService.createExecutionQuery().activityId("subProcessTask").list();
        ProcessInstanceModificationMultiInstanceTest.assertEquals((int)4, (int)leafExecutions.size());
        this.assertVariableSet(leafExecutions, "loopCounter", Arrays.asList(0, 1, 2, 3));
        for (Execution leafExecution : leafExecutions) {
            this.assertVariable(leafExecution, "nrOfInstances", 4);
            this.assertVariable(leafExecution, "nrOfCompletedInstances", 0);
            this.assertVariable(leafExecution, "nrOfActiveInstances", 4);
        }
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginMiBody("miSubProcess").beginScope("miSubProcess").activity("subProcessTask").endScope().beginScope("miSubProcess").activity("subProcessTask").endScope().beginScope("miSubProcess").activity("subProcessTask").endScope().beginScope("miSubProcess").activity("subProcessTask").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child(null).concurrent().noScope().child("subProcessTask").scope().up().up().child(null).concurrent().noScope().child("subProcessTask").scope().up().up().child(null).concurrent().noScope().child("subProcessTask").scope().up().up().child(null).concurrent().noScope().child("subProcessTask").scope().done());
        this.completeTasksInOrder("subProcessTask", "subProcessTask", "subProcessTask", "subProcessTask", "afterTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelTasks.bpmn20.xml"})
    public void testStartBeforeInnerActivityWithMiBodyParallelTasks() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miParallelUserTasks");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("miTasks")).execute();
        Execution leafExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("miTasks").singleResult();
        ProcessInstanceModificationMultiInstanceTest.assertNotNull((Object)leafExecution);
        this.assertVariable(leafExecution, "loopCounter", 0);
        this.assertVariable(leafExecution, "nrOfInstances", 1);
        this.assertVariable(leafExecution, "nrOfCompletedInstances", 0);
        this.assertVariable(leafExecution, "nrOfActiveInstances", 1);
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("beforeTask").beginMiBody("miTasks").activity("miTasks").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("beforeTask").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("miTasks").concurrent().noScope().done());
        this.completeTasksInOrder("miTasks", "afterTask", "beforeTask", "miTasks", "miTasks", "miTasks", "afterTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelTasks.bpmn20.xml"})
    public void testStartBeforeInnerActivityWithMiBodyParallelTasksActivityStatistics() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miParallelUserTasks");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("miTasks")).execute();
        List statistics = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).list();
        ProcessInstanceModificationMultiInstanceTest.assertEquals((int)2, (int)statistics.size());
        ActivityStatistics miTasksStatistics = this.getStatisticsForActivity(statistics, "miTasks");
        ProcessInstanceModificationMultiInstanceTest.assertNotNull((Object)miTasksStatistics);
        ProcessInstanceModificationMultiInstanceTest.assertEquals((int)1, (int)miTasksStatistics.getInstances());
        ActivityStatistics beforeTaskStatistics = this.getStatisticsForActivity(statistics, "beforeTask");
        ProcessInstanceModificationMultiInstanceTest.assertNotNull((Object)beforeTaskStatistics);
        ProcessInstanceModificationMultiInstanceTest.assertEquals((int)1, (int)beforeTaskStatistics.getInstances());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelSubprocess.bpmn20.xml"})
    public void testStartBeforeInnerActivityWithMiBodyParallelSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miParallelSubprocess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("subProcessTask")).execute();
        Execution leafExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("subProcessTask").singleResult();
        ProcessInstanceModificationMultiInstanceTest.assertNotNull((Object)leafExecution);
        this.assertVariable(leafExecution, "loopCounter", 0);
        this.assertVariable(leafExecution, "nrOfInstances", 1);
        this.assertVariable(leafExecution, "nrOfCompletedInstances", 0);
        this.assertVariable(leafExecution, "nrOfActiveInstances", 1);
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("beforeTask").beginMiBody("miSubProcess").beginScope("miSubProcess").activity("subProcessTask").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("beforeTask").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child(null).concurrent().noScope().child("subProcessTask").scope().done());
        this.completeTasksInOrder("subProcessTask", "afterTask", "beforeTask", "subProcessTask", "subProcessTask", "subProcessTask", "afterTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelSubprocess.bpmn20.xml"})
    public void testStartBeforeInnerActivityWithMiBodyParallelSubprocessActivityStatistics() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miParallelSubprocess");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("subProcessTask")).execute();
        List statistics = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).list();
        ProcessInstanceModificationMultiInstanceTest.assertEquals((int)2, (int)statistics.size());
        ActivityStatistics miTasksStatistics = this.getStatisticsForActivity(statistics, "subProcessTask");
        ProcessInstanceModificationMultiInstanceTest.assertNotNull((Object)miTasksStatistics);
        ProcessInstanceModificationMultiInstanceTest.assertEquals((int)1, (int)miTasksStatistics.getInstances());
        ActivityStatistics beforeTaskStatistics = this.getStatisticsForActivity(statistics, "beforeTask");
        ProcessInstanceModificationMultiInstanceTest.assertNotNull((Object)beforeTaskStatistics);
        ProcessInstanceModificationMultiInstanceTest.assertEquals((int)1, (int)beforeTaskStatistics.getInstances());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelSubprocess.bpmn20.xml"})
    public void testStartBeforeInnerActivityWithMiBodySetNrOfInstancesParallelSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miParallelSubprocess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("subProcessTask")).setVariable("nrOfInstances", (Object)3)).execute();
        Execution leafExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("subProcessTask").singleResult();
        ProcessInstanceModificationMultiInstanceTest.assertNotNull((Object)leafExecution);
        this.assertVariable(leafExecution, "loopCounter", 0);
        this.assertVariable(leafExecution, "nrOfInstances", 3);
        this.assertVariable(leafExecution, "nrOfCompletedInstances", 0);
        this.assertVariable(leafExecution, "nrOfActiveInstances", 1);
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("beforeTask").beginMiBody("miSubProcess").beginScope("miSubProcess").activity("subProcessTask").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("beforeTask").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child(null).concurrent().noScope().child("subProcessTask").scope().done());
        this.completeTasksInOrder("subProcessTask");
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("beforeTask").activity("afterTask").done());
        this.completeTasksInOrder("beforeTask", "subProcessTask", "afterTask", "subProcessTask", "subProcessTask", "afterTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.sequentialTasks.bpmn20.xml"})
    public void testStartBeforeInnerActivitySequentialTasks() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miSequentialUserTasks");
        this.completeTasksInOrder("beforeTask");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        try {
            this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("miTasks", tree.getActivityInstances("miTasks#multiInstanceBody")[0].getId()).execute();
            ProcessInstanceModificationMultiInstanceTest.fail((String)"expect exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent(e.getMessage(), "Concurrent instantiation not possible for activities in scope miTasks#multiInstanceBody");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.sequentialSubprocess.bpmn20.xml"})
    public void testStartBeforeInnerActivitySequentialSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess");
        this.completeTasksInOrder("beforeTask");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        try {
            this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("miSubProcess", tree.getActivityInstances("miSubProcess#multiInstanceBody")[0].getId()).execute();
            ProcessInstanceModificationMultiInstanceTest.fail((String)"expect exception");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent(e.getMessage(), "Concurrent instantiation not possible for activities in scope miSubProcess#multiInstanceBody");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.sequentialTasks.bpmn20.xml"})
    public void testStartBeforeInnerActivityWithMiBodySequentialTasks() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miSequentialUserTasks");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("miTasks")).execute();
        Execution leafExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("miTasks").singleResult();
        ProcessInstanceModificationMultiInstanceTest.assertNotNull((Object)leafExecution);
        this.assertVariable(leafExecution, "loopCounter", 0);
        this.assertVariable(leafExecution, "nrOfInstances", 1);
        this.assertVariable(leafExecution, "nrOfCompletedInstances", 0);
        this.assertVariable(leafExecution, "nrOfActiveInstances", 1);
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("beforeTask").beginMiBody("miTasks").activity("miTasks").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("beforeTask").concurrent().noScope().up().child(null).concurrent().noScope().child("miTasks").scope().done());
        this.completeTasksInOrder("miTasks", "afterTask", "beforeTask", "miTasks", "miTasks", "miTasks", "afterTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.sequentialTasks.bpmn20.xml"})
    public void testStartBeforeInnerActivityWithMiBodySequentialTasksActivityStatistics() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miSequentialUserTasks");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("miTasks")).execute();
        List statistics = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).list();
        ProcessInstanceModificationMultiInstanceTest.assertEquals((int)2, (int)statistics.size());
        ActivityStatistics miTasksStatistics = this.getStatisticsForActivity(statistics, "miTasks");
        ProcessInstanceModificationMultiInstanceTest.assertNotNull((Object)miTasksStatistics);
        ProcessInstanceModificationMultiInstanceTest.assertEquals((int)1, (int)miTasksStatistics.getInstances());
        ActivityStatistics beforeTaskStatistics = this.getStatisticsForActivity(statistics, "beforeTask");
        ProcessInstanceModificationMultiInstanceTest.assertNotNull((Object)beforeTaskStatistics);
        ProcessInstanceModificationMultiInstanceTest.assertEquals((int)1, (int)beforeTaskStatistics.getInstances());
    }

    protected ActivityStatistics getStatisticsForActivity(List<ActivityStatistics> statistics, String activityId) {
        for (ActivityStatistics statisticsInstance : statistics) {
            if (!statisticsInstance.getId().equals(activityId)) continue;
            return statisticsInstance;
        }
        return null;
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.sequentialSubprocess.bpmn20.xml"})
    public void testStartBeforeInnerActivityWithMiBodySequentialSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("subProcessTask")).execute();
        Execution leafExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("subProcessTask").singleResult();
        ProcessInstanceModificationMultiInstanceTest.assertNotNull((Object)leafExecution);
        this.assertVariable(leafExecution, "loopCounter", 0);
        this.assertVariable(leafExecution, "nrOfInstances", 1);
        this.assertVariable(leafExecution, "nrOfCompletedInstances", 0);
        this.assertVariable(leafExecution, "nrOfActiveInstances", 1);
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("beforeTask").beginMiBody("miSubProcess").beginScope("miSubProcess").activity("subProcessTask").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("beforeTask").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("subProcessTask").scope().done());
        this.completeTasksInOrder("subProcessTask", "afterTask", "beforeTask", "subProcessTask", "subProcessTask", "subProcessTask", "afterTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.sequentialSubprocess.bpmn20.xml"})
    public void testStartBeforeInnerActivityWithMiBodySequentialSubprocessActivityStatistics() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess");
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("subProcessTask")).execute();
        List statistics = this.managementService.createActivityStatisticsQuery(processInstance.getProcessDefinitionId()).list();
        ProcessInstanceModificationMultiInstanceTest.assertEquals((int)2, (int)statistics.size());
        ActivityStatistics miTasksStatistics = this.getStatisticsForActivity(statistics, "subProcessTask");
        ProcessInstanceModificationMultiInstanceTest.assertNotNull((Object)miTasksStatistics);
        ProcessInstanceModificationMultiInstanceTest.assertEquals((int)1, (int)miTasksStatistics.getInstances());
        ActivityStatistics beforeTaskStatistics = this.getStatisticsForActivity(statistics, "beforeTask");
        ProcessInstanceModificationMultiInstanceTest.assertNotNull((Object)beforeTaskStatistics);
        ProcessInstanceModificationMultiInstanceTest.assertEquals((int)1, (int)beforeTaskStatistics.getInstances());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.sequentialSubprocess.bpmn20.xml"})
    public void testStartBeforeInnerActivityWithMiBodySetNrOfInstancesSequentialSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("subProcessTask")).setVariable("nrOfInstances", (Object)3)).execute();
        Execution leafExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("subProcessTask").singleResult();
        ProcessInstanceModificationMultiInstanceTest.assertNotNull((Object)leafExecution);
        this.assertVariable(leafExecution, "loopCounter", 0);
        this.assertVariable(leafExecution, "nrOfInstances", 3);
        this.assertVariable(leafExecution, "nrOfCompletedInstances", 0);
        this.assertVariable(leafExecution, "nrOfActiveInstances", 1);
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("beforeTask").beginMiBody("miSubProcess").beginScope("miSubProcess").activity("subProcessTask").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("beforeTask").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("subProcessTask").scope().done());
        this.completeTasksInOrder("subProcessTask");
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("beforeTask").beginMiBody("miSubProcess").beginScope("miSubProcess").activity("subProcessTask").done());
        leafExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("subProcessTask").singleResult();
        ProcessInstanceModificationMultiInstanceTest.assertNotNull((Object)leafExecution);
        this.assertVariable(leafExecution, "loopCounter", 1);
        this.assertVariable(leafExecution, "nrOfInstances", 3);
        this.assertVariable(leafExecution, "nrOfCompletedInstances", 1);
        this.assertVariable(leafExecution, "nrOfActiveInstances", 1);
        this.completeTasksInOrder("subProcessTask");
        this.completeTasksInOrder("subProcessTask", "beforeTask", "subProcessTask", "subProcessTask", "subProcessTask", "afterTask", "afterTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelTasks.bpmn20.xml"})
    public void testCancelMultiInstanceBodyParallelTasks() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miParallelUserTasks");
        this.completeTasksInOrder("beforeTask");
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("miTasks#multiInstanceBody").execute();
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelSubprocess.bpmn20.xml"})
    public void testCancelMultiInstanceBodyParallelSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miParallelSubprocess");
        this.completeTasksInOrder("beforeTask");
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("miSubProcess#multiInstanceBody").execute();
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.sequentialTasks.bpmn20.xml"})
    public void testCancelMultiInstanceBodySequentialTasks() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miSequentialUserTasks");
        this.completeTasksInOrder("beforeTask");
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("miTasks#multiInstanceBody").execute();
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.sequentialSubprocess.bpmn20.xml"})
    public void testCancelMultiInstanceBodySequentialSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess");
        this.completeTasksInOrder("beforeTask");
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("miSubProcess#multiInstanceBody").execute();
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelTasks.bpmn20.xml"})
    public void testCancelInnerActivityParallelTasks() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miParallelUserTasks");
        this.completeTasksInOrder("beforeTask");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(tree.getActivityInstances("miTasks")[0].getId()).execute();
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginMiBody("miTasks").activity("miTasks").activity("miTasks").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("miTasks").concurrent().noScope().up().child("miTasks").concurrent().noScope().up().done());
        this.completeTasksInOrder("miTasks", "miTasks", "afterTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelTasks.bpmn20.xml"})
    public void testCancelAllInnerActivityParallelTasks() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miParallelUserTasks");
        this.completeTasksInOrder("beforeTask");
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("miTasks").execute();
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.nestedParallelTasks.bpmn20.xml"})
    public void testCancelAllInnerActivityNestedParallelTasks() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedMiParallelUserTasks");
        this.completeTasksInOrder("beforeTask");
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("miTasks").execute();
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelTasks.bpmn20.xml"})
    public void testCancelInnerActivityParallelTasksAllButOne() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miParallelUserTasks");
        this.completeTasksInOrder("beforeTask");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(tree.getActivityInstances("miTasks")[0].getId()).cancelActivityInstance(tree.getActivityInstances("miTasks")[1].getId()).execute();
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginMiBody("miTasks").activity("miTasks").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("miTasks").concurrent().noScope().done());
        this.completeTasksInOrder("miTasks", "afterTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.parallelSubprocess.bpmn20.xml"})
    public void testCancelInnerActivityParallelSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miParallelSubprocess");
        this.completeTasksInOrder("beforeTask");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(tree.getActivityInstances("miSubProcess")[0].getId()).execute();
        tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginMiBody("miSubProcess").beginScope("miSubProcess").activity("subProcessTask").endScope().beginScope("miSubProcess").activity("subProcessTask").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child(null).concurrent().noScope().child("subProcessTask").scope().up().up().child(null).concurrent().noScope().child("subProcessTask").scope().up().up().done());
        this.completeTasksInOrder("subProcessTask", "subProcessTask", "afterTask");
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.sequentialTasks.bpmn20.xml"})
    public void testCancelInnerActivitySequentialTasks() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miSequentialUserTasks");
        this.completeTasksInOrder("beforeTask");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(tree.getActivityInstances("miTasks")[0].getId()).execute();
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.sequentialTasks.bpmn20.xml"})
    public void testCancelAllInnerActivitySequentialTasks() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miSequentialUserTasks");
        this.completeTasksInOrder("beforeTask");
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("miTasks").execute();
        this.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationMultiInstanceTest.sequentialSubprocess.bpmn20.xml"})
    public void testCancelInnerActivitySequentialSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("miSequentialSubprocess");
        this.completeTasksInOrder("beforeTask");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(tree.getActivityInstances("miSubProcess")[0].getId()).execute();
        this.assertProcessEnded(processInstance.getId());
    }

    protected void completeTasksInOrder(String ... taskNames) {
        for (String taskName : taskNames) {
            List tasks = this.taskService.createTaskQuery().taskDefinitionKey(taskName).listPage(0, 1);
            ProcessInstanceModificationMultiInstanceTest.assertTrue((String)("task for activity " + taskName + " does not exist"), (!tasks.isEmpty() ? 1 : 0) != 0);
            this.taskService.complete(((Task)tasks.get(0)).getId());
        }
    }

    protected void assertVariable(Execution execution, String variableName, Object expectedValue) {
        Object variableValue = this.runtimeService.getVariable(execution.getId(), variableName);
        ProcessInstanceModificationMultiInstanceTest.assertEquals((String)("Value for variable '" + variableName + "' and " + execution + " does not match."), (Object)expectedValue, (Object)variableValue);
    }

    protected void assertVariableSet(List<Execution> executions, String variableName, List<?> expectedValues) {
        ArrayList<Object> actualValues = new ArrayList<Object>();
        for (Execution execution : executions) {
            actualValues.add(this.runtimeService.getVariable(execution.getId(), variableName));
        }
        for (Object expectedValue : expectedValues) {
            boolean valueFound = actualValues.remove(expectedValue);
            ProcessInstanceModificationMultiInstanceTest.assertTrue((String)("Expected variable value '" + expectedValue + "' not contained in the list of actual values. Unmatched actual values: " + actualValues), (boolean)valueFound);
        }
        ProcessInstanceModificationMultiInstanceTest.assertTrue((String)"There are more actual than expected values.", (boolean)actualValues.isEmpty());
    }
}

