/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.Map;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class ProcessInstantiationAtStartEventTest
extends PluggableProcessEngineTestCase {
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";

    protected void setUp() throws Exception {
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().endEvent().done()});
    }

    public void testStartProcessInstanceById() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.createProcessInstanceById(processDefinition.getId()).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartProcessInstanceByKey() {
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).execute();
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testStartProcessInstanceAndSetBusinessKey() {
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).businessKey("businessKey").execute();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertThat((Object)processInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)processInstance.getBusinessKey(), (Matcher)CoreMatchers.is((Object)"businessKey"));
    }

    public void testStartProcessInstanceAndSetCaseInstanceId() {
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).caseInstanceId("caseInstanceId").execute();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assert.assertThat((Object)processInstance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)processInstance.getCaseInstanceId(), (Matcher)CoreMatchers.is((Object)"caseInstanceId"));
    }

    public void testStartProcessInstanceAndSetVariable() {
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).setVariable("var", (Object)"value")).execute();
        Object variable = this.runtimeService.getVariable(processInstance.getId(), "var");
        Assert.assertThat((Object)variable, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)variable, (Matcher)CoreMatchers.is((Object)"value"));
    }

    public void testStartProcessInstanceAndSetVariables() {
        VariableMap variables = Variables.createVariables().putValue("var1", (Object)"v1").putValue("var2", (Object)"v2");
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).setVariables((Map)variables)).execute();
        Assert.assertThat((Object)this.runtimeService.getVariables(processInstance.getId()), (Matcher)CoreMatchers.is((Object)variables));
    }

    public void testStartProcessInstanceNoSkipping() {
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).execute(false, false);
        Assert.assertThat((Object)this.runtimeService.createProcessInstanceQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testFailToStartProcessInstanceSkipListeners() {
        try {
            this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).execute(true, false);
            ProcessInstantiationAtStartEventTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot skip"));
        }
    }

    public void testFailToStartProcessInstanceSkipInputOutputMapping() {
        try {
            this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).execute(false, true);
            ProcessInstantiationAtStartEventTest.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot skip"));
        }
    }
}

