/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.List;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.MultiInstanceProcessModels;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrationRemoveMultiInstanceTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testHelper);

    @Test
    public void testRemoveParallelMultiInstanceBody() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").concurrent().noScope().up().child("userTask").concurrent().noScope().up().child("userTask").concurrent().noScope().done());
        ActivityInstance[] userTaskInstances = this.testHelper.snapshotBeforeMigration.getActivityTree().getActivityInstances("userTask");
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", userTaskInstances[0].getId()).activity("userTask", userTaskInstances[1].getId()).activity("userTask", userTaskInstances[2].getId()).done());
        List<Task> migratedTasks = this.testHelper.snapshotAfterMigration.getTasks();
        Assert.assertEquals((long)3L, (long)migratedTasks.size());
        for (Task migratedTask : migratedTasks) {
            this.rule.getTaskService().complete(migratedTask.getId());
        }
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveParallelMultiInstanceBodyVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        Assert.assertEquals((long)0L, (long)this.rule.getRuntimeService().createVariableInstanceQuery().variableName("nrOfInstances").count());
        Assert.assertEquals((long)0L, (long)this.rule.getRuntimeService().createVariableInstanceQuery().variableName("nrOfInstances").count());
        Assert.assertEquals((long)0L, (long)this.rule.getRuntimeService().createVariableInstanceQuery().variableName("nrOfActiveInstances").count());
        Assert.assertEquals((long)0L, (long)this.rule.getRuntimeService().createVariableInstanceQuery().variableName("nrOfCompletedInstances").count());
        Assert.assertEquals((long)3L, (long)this.rule.getRuntimeService().createVariableInstanceQuery().variableName("loopCounter").count());
    }

    @Test
    public void testRemoveParallelMultiInstanceBodyScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(MultiInstanceProcessModels.PAR_MI_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        ActivityInstance[] subProcessInstances = this.testHelper.snapshotBeforeMigration.getActivityTree().getActivityInstances("subProcess");
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child(null).concurrent().noScope().child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivity(subProcessInstances[0], "subProcess")).up().up().child(null).concurrent().noScope().child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivity(subProcessInstances[1], "subProcess")).up().up().child(null).concurrent().noScope().child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivity(subProcessInstances[2], "subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", subProcessInstances[0].getId()).activity("userTask", subProcessInstances[0].getActivityInstances("userTask")[0].getId()).endScope().beginScope("subProcess", subProcessInstances[1].getId()).activity("userTask", subProcessInstances[1].getActivityInstances("userTask")[0].getId()).endScope().beginScope("subProcess", subProcessInstances[2].getId()).activity("userTask", subProcessInstances[2].getActivityInstances("userTask")[0].getId()).endScope().done());
        List<Task> migratedTasks = this.testHelper.snapshotAfterMigration.getTasks();
        Assert.assertEquals((long)3L, (long)migratedTasks.size());
        for (Task migratedTask : migratedTasks) {
            this.rule.getTaskService().complete(migratedTask.getId());
        }
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveParallelMultiInstanceBodyOneInstanceFinished() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(MultiInstanceProcessModels.PAR_MI_ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        ProcessInstance processInstance = this.rule.getRuntimeService().startProcessInstanceById(migrationPlan.getSourceProcessDefinitionId());
        Task firstTask = (Task)this.rule.getTaskService().createTaskQuery().listPage(0, 1).get(0);
        this.rule.getTaskService().complete(firstTask.getId());
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").concurrent().noScope().up().child("userTask").concurrent().noScope().done());
        ActivityInstance[] userTaskInstances = this.testHelper.snapshotBeforeMigration.getActivityTree().getActivityInstances("userTask");
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", userTaskInstances[0].getId()).activity("userTask", userTaskInstances[1].getId()).done());
        List<Task> migratedTasks = this.testHelper.snapshotAfterMigration.getTasks();
        Assert.assertEquals((long)2L, (long)migratedTasks.size());
        for (Task migratedTask : migratedTasks) {
            this.rule.getTaskService().complete(migratedTask.getId());
        }
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveSequentialMultiInstanceBody() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(MultiInstanceProcessModels.SEQ_MI_ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree("userTask").scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).activity("userTask", this.testHelper.getSingleActivityInstanceBeforeMigration("userTask").getId()).done());
        Task migratedTask = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask");
        Assert.assertNotNull((Object)migratedTask);
        this.rule.getTaskService().complete(migratedTask.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }

    @Test
    public void testRemoveSequentialMultiInstanceBodyVariables() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(MultiInstanceProcessModels.SEQ_MI_ONE_TASK_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        Assert.assertEquals((long)0L, (long)this.rule.getRuntimeService().createVariableInstanceQuery().count());
    }

    @Test
    public void testRemovSequentialMultiInstanceBodyScope() {
        ProcessDefinition sourceProcessDefinition = this.testHelper.deployAndGetDefinition(MultiInstanceProcessModels.SEQ_MI_SUBPROCESS_PROCESS);
        ProcessDefinition targetProcessDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.SUBPROCESS_PROCESS);
        MigrationPlan migrationPlan = this.rule.getRuntimeService().createMigrationPlan(sourceProcessDefinition.getId(), targetProcessDefinition.getId()).mapActivities("subProcess", "subProcess").mapActivities("userTask", "userTask").build();
        this.testHelper.createProcessInstanceAndMigrate(migrationPlan);
        ActivityInstance subProcessInstance = this.testHelper.getSingleActivityInstanceBeforeMigration("subProcess");
        this.testHelper.assertExecutionTreeAfterMigration().hasProcessDefinitionId(targetProcessDefinition.getId()).matches(ExecutionAssert.describeExecutionTree(null).scope().id(this.testHelper.snapshotBeforeMigration.getProcessInstanceId()).child("userTask").scope().id(this.testHelper.getSingleExecutionIdForActivityBeforeMigration("subProcess")).done());
        this.testHelper.assertActivityTreeAfterMigration().hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(targetProcessDefinition.getId()).beginScope("subProcess", subProcessInstance.getId()).activity("userTask", subProcessInstance.getActivityInstances("userTask")[0].getId()).done());
        Task migratedTask = this.testHelper.snapshotAfterMigration.getTaskForKey("userTask");
        Assert.assertNotNull((Object)migratedTask);
        this.rule.getTaskService().complete(migratedTask.getId());
        this.testHelper.assertProcessEnded(this.testHelper.snapshotBeforeMigration.getProcessInstanceId());
    }
}

