/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.util.List;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;

public class StandaloneTaskTest
extends PluggableProcessEngineTestCase {
    public void setUp() throws Exception {
        super.setUp();
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.identityService.saveUser(this.identityService.newUser("gonzo"));
    }

    public void tearDown() throws Exception {
        this.identityService.deleteUser("kermit");
        this.identityService.deleteUser("gonzo");
        super.tearDown();
    }

    public void testCreateToComplete() {
        Task task = this.taskService.newTask();
        task.setName("testTask");
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.addCandidateUser(taskId, "kermit");
        this.taskService.addCandidateUser(taskId, "gonzo");
        List tasks = this.taskService.createTaskQuery().taskCandidateUser("kermit").list();
        StandaloneTaskTest.assertEquals((int)1, (int)tasks.size());
        StandaloneTaskTest.assertEquals((String)"testTask", (String)((Task)tasks.get(0)).getName());
        tasks = this.taskService.createTaskQuery().taskCandidateUser("gonzo").list();
        StandaloneTaskTest.assertEquals((int)1, (int)tasks.size());
        StandaloneTaskTest.assertEquals((String)"testTask", (String)((Task)tasks.get(0)).getName());
        this.taskService.claim(taskId, "kermit");
        StandaloneTaskTest.assertTrue((boolean)this.taskService.createTaskQuery().taskCandidateUser("kermit").list().isEmpty());
        StandaloneTaskTest.assertTrue((boolean)this.taskService.createTaskQuery().taskCandidateUser("gonzo").list().isEmpty());
        this.taskService.deleteTask(taskId, true);
        StandaloneTaskTest.assertNull((Object)this.taskService.createTaskQuery().taskId(taskId).singleResult());
    }

    public void testOptimisticLockingThrownOnMultipleUpdates() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        Task task1 = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        Task task2 = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        task1.setDescription("first modification");
        this.taskService.saveTask(task1);
        task2.setDescription("second modification");
        try {
            this.taskService.saveTask(task2);
            StandaloneTaskTest.fail((String)"should get an exception here as the task was modified by someone else.");
        }
        catch (OptimisticLockingException optimisticLockingException) {
            // empty catch block
        }
        this.taskService.deleteTask(taskId, true);
    }

    public void testRevisionUpdatedOnSave() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        StandaloneTaskTest.assertEquals((int)1, (int)((TaskEntity)task).getRevision());
        task.setDescription("first modification");
        this.taskService.saveTask(task);
        StandaloneTaskTest.assertEquals((int)2, (int)((TaskEntity)task).getRevision());
        task.setDescription("second modification");
        this.taskService.saveTask(task);
        StandaloneTaskTest.assertEquals((int)3, (int)((TaskEntity)task).getRevision());
        this.taskService.deleteTask(task.getId(), true);
    }

    public void testSaveTaskWithGenericResourceId() {
        Task task = this.taskService.newTask("*");
        try {
            this.taskService.saveTask(task);
            StandaloneTaskTest.fail((String)"it should not be possible to save a task with the generic resource id *");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Entity Task[*] has an invalid id: id cannot be *. * is a reserved identifier", e.getMessage());
        }
    }
}

