/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.util.Date;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.FilterEntity;
import org.camunda.bpm.engine.impl.test.ResourceProcessEngineTestCase;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.task.TaskQuery;

public class TaskQueryDisabledStoredExpressionsTest
extends ResourceProcessEngineTestCase {
    protected static final String EXPECTED_STORED_QUERY_FAILURE_MESSAGE = "Expressions are forbidden in stored queries. This behavior can be toggled in the process engine configuration";
    public static final String STATE_MANIPULATING_EXPRESSION = "${''.getClass().forName('" + TaskQueryDisabledStoredExpressionsTest.class.getName() + "').getField('MUTABLE_FIELD').setLong(null, 42)}";
    public static long MUTABLE_FIELD = 0L;

    public TaskQueryDisabledStoredExpressionsTest() {
        super("org/camunda/bpm/engine/test/api/task/task-query-disabled-stored-expressions-test.camunda.cfg.xml");
    }

    protected void setUp() throws Exception {
        MUTABLE_FIELD = 0L;
    }

    public void testStoreFilterWithoutExpression() {
        TaskQuery taskQuery = this.taskService.createTaskQuery().dueAfter(new Date());
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)taskQuery);
        this.filterService.saveFilter(filter);
        TaskQueryDisabledStoredExpressionsTest.assertEquals((long)1L, (long)this.filterService.createFilterQuery().count());
        this.filterService.deleteFilter(filter.getId());
    }

    public void testStoreFilterWithExpression() {
        TaskQuery taskQuery = this.taskService.createTaskQuery().dueAfterExpression(STATE_MANIPULATING_EXPRESSION);
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)taskQuery);
        try {
            this.filterService.saveFilter(filter);
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent(EXPECTED_STORED_QUERY_FAILURE_MESSAGE, e.getMessage());
        }
        TaskQueryDisabledStoredExpressionsTest.assertTrue((boolean)this.fieldIsUnchanged());
    }

    public void testUpdateFilterWithExpression() {
        TaskQuery taskQuery = this.taskService.createTaskQuery().dueAfter(new Date());
        Filter filter = this.filterService.newTaskFilter("filter");
        filter.setQuery((Query)taskQuery);
        this.filterService.saveFilter(filter);
        filter.setQuery((Query)taskQuery.dueBeforeExpression(STATE_MANIPULATING_EXPRESSION));
        TaskQueryDisabledStoredExpressionsTest.assertEquals((long)1L, (long)this.filterService.createFilterQuery().count());
        try {
            this.filterService.saveFilter(filter);
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent(EXPECTED_STORED_QUERY_FAILURE_MESSAGE, e.getMessage());
        }
        TaskQueryDisabledStoredExpressionsTest.assertTrue((boolean)this.fieldIsUnchanged());
        this.filterService.deleteFilter(filter.getId());
    }

    public void testCannotExecuteStoredFilter() {
        final TaskQuery filterQuery = this.taskService.createTaskQuery().dueAfterExpression(STATE_MANIPULATING_EXPRESSION);
        String filterId = (String)this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<String>(){

            public String execute(CommandContext commandContext) {
                FilterEntity filter = new FilterEntity("Task");
                filter.setQuery((Query)filterQuery);
                filter.setName("filter");
                commandContext.getDbEntityManager().insert((DbEntity)filter);
                return filter.getId();
            }
        });
        this.extendFilterAndValidateFailingQuery(filterId, null);
        this.filterService.deleteFilter(filterId);
    }

    protected boolean fieldIsUnchanged() {
        return MUTABLE_FIELD == 0L;
    }

    protected void extendFilterAndValidateFailingQuery(String filterId, TaskQuery query) {
        try {
            this.filterService.list(filterId, (Query)query);
        }
        catch (BadUserRequestException e) {
            this.assertTextPresent(EXPECTED_STORED_QUERY_FAILURE_MESSAGE, e.getMessage());
        }
        TaskQueryDisabledStoredExpressionsTest.assertTrue((boolean)this.fieldIsUnchanged());
        try {
            this.filterService.count(filterId, (Query)query);
        }
        catch (BadUserRequestException e) {
            this.assertTextPresent(EXPECTED_STORED_QUERY_FAILURE_MESSAGE, e.getMessage());
        }
        TaskQueryDisabledStoredExpressionsTest.assertTrue((boolean)this.fieldIsUnchanged());
    }
}

