/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskAlreadyClaimedException;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.TaskServiceImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Comment;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.Event;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.SerializationDataFormat;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class TaskServiceTest {
    protected static final String TWO_TASKS_PROCESS = "org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml";
    protected ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(){

        @Override
        public ProcessEngineConfiguration configureEngine(ProcessEngineConfigurationImpl configuration) {
            configuration.setJavaSerializationFormatEnabled(true);
            return configuration;
        }
    };
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(this.bootstrapRule);
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.bootstrapRule).around((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private RuntimeService runtimeService;
    private TaskService taskService;
    private RepositoryService repositoryService;
    private HistoryService historyService;
    private CaseService caseService;
    private IdentityService identityService;
    private ProcessEngineConfigurationImpl processEngineConfiguration;
    private static final SimpleDateFormat SDF = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss.SSS");

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.taskService = this.engineRule.getTaskService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.historyService = this.engineRule.getHistoryService();
        this.caseService = this.engineRule.getCaseService();
        this.identityService = this.engineRule.getIdentityService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
    }

    @After
    public void tearDown() {
        ClockUtil.setCurrentTime((Date)new Date());
    }

    @Test
    public void testSaveTaskUpdate() throws Exception {
        HistoricTaskInstance historicTaskInstance;
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
        Task task = this.taskService.newTask();
        task.setDescription("description");
        task.setName("taskname");
        task.setPriority(0);
        task.setAssignee("taskassignee");
        task.setOwner("taskowner");
        Date dueDate = sdf.parse("01/02/2003 04:05:06");
        task.setDueDate(dueDate);
        task.setCaseInstanceId("taskcaseinstanceid");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        Assert.assertEquals((Object)"description", (Object)task.getDescription());
        Assert.assertEquals((Object)"taskname", (Object)task.getName());
        Assert.assertEquals((Object)"taskassignee", (Object)task.getAssignee());
        Assert.assertEquals((Object)"taskowner", (Object)task.getOwner());
        Assert.assertEquals((Object)dueDate, (Object)task.getDueDate());
        Assert.assertEquals((long)0L, (long)task.getPriority());
        Assert.assertEquals((Object)"taskcaseinstanceid", (Object)task.getCaseInstanceId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult();
            Assert.assertEquals((Object)"taskname", (Object)historicTaskInstance.getName());
            Assert.assertEquals((Object)"description", (Object)historicTaskInstance.getDescription());
            Assert.assertEquals((Object)"taskassignee", (Object)historicTaskInstance.getAssignee());
            Assert.assertEquals((Object)"taskowner", (Object)historicTaskInstance.getOwner());
            Assert.assertEquals((Object)dueDate, (Object)historicTaskInstance.getDueDate());
            Assert.assertEquals((long)0L, (long)historicTaskInstance.getPriority());
            Assert.assertEquals((Object)"taskcaseinstanceid", (Object)historicTaskInstance.getCaseInstanceId());
        }
        task.setName("updatedtaskname");
        task.setDescription("updateddescription");
        task.setPriority(1);
        task.setAssignee("updatedassignee");
        task.setOwner("updatedowner");
        dueDate = sdf.parse("01/02/2003 04:05:06");
        task.setDueDate(dueDate);
        task.setCaseInstanceId("updatetaskcaseinstanceid");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        Assert.assertEquals((Object)"updatedtaskname", (Object)task.getName());
        Assert.assertEquals((Object)"updateddescription", (Object)task.getDescription());
        Assert.assertEquals((Object)"updatedassignee", (Object)task.getAssignee());
        Assert.assertEquals((Object)"updatedowner", (Object)task.getOwner());
        Assert.assertEquals((Object)dueDate, (Object)task.getDueDate());
        Assert.assertEquals((long)1L, (long)task.getPriority());
        Assert.assertEquals((Object)"updatetaskcaseinstanceid", (Object)task.getCaseInstanceId());
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult();
            Assert.assertEquals((Object)"updatedtaskname", (Object)historicTaskInstance.getName());
            Assert.assertEquals((Object)"updateddescription", (Object)historicTaskInstance.getDescription());
            Assert.assertEquals((Object)"updatedassignee", (Object)historicTaskInstance.getAssignee());
            Assert.assertEquals((Object)"updatedowner", (Object)historicTaskInstance.getOwner());
            Assert.assertEquals((Object)dueDate, (Object)historicTaskInstance.getDueDate());
            Assert.assertEquals((long)1L, (long)historicTaskInstance.getPriority());
            Assert.assertEquals((Object)"updatetaskcaseinstanceid", (Object)historicTaskInstance.getCaseInstanceId());
        }
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    public void testSaveTaskSetParentTaskId() {
        Task parent = this.taskService.newTask("parent");
        this.taskService.saveTask(parent);
        Task task = this.taskService.newTask("subTask");
        task.setParentTaskId("parent");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId("subTask").singleResult();
        Assert.assertEquals((Object)parent.getId(), (Object)task.getParentTaskId());
        this.taskService.deleteTask("parent", true);
        this.taskService.deleteTask("subTask", true);
    }

    @Test
    public void testSaveTaskWithNonExistingParentTask() {
        Task task = this.taskService.newTask();
        task.setParentTaskId("non-existing");
        try {
            this.taskService.saveTask(task);
            Assert.fail((String)"It should not be possible to save a task with a non existing parent task.");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testTaskOwner() {
        Task task = this.taskService.newTask();
        task.setOwner("johndoe");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        Assert.assertEquals((Object)"johndoe", (Object)task.getOwner());
        task.setOwner("joesmoe");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        Assert.assertEquals((Object)"joesmoe", (Object)task.getOwner());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    public void testTaskComments() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Task task = this.taskService.newTask();
            task.setOwner("johndoe");
            this.taskService.saveTask(task);
            String taskId = task.getId();
            this.identityService.setAuthenticatedUserId("johndoe");
            Comment comment = this.taskService.createComment(taskId, null, "look at this \n       isn't this great? slkdjf sldkfjs ldkfjs ldkfjs ldkfj sldkfj sldkfj sldkjg laksfg sdfgsd;flgkj ksajdhf skjdfh ksjdhf skjdhf kalskjgh lskh dfialurhg kajsh dfuieqpgkja rzvkfnjviuqerhogiuvysbegkjz lkhf ais liasduh flaisduh ajiasudh vaisudhv nsfd");
            Assert.assertNotNull((Object)comment.getId());
            Assert.assertEquals((Object)"johndoe", (Object)comment.getUserId());
            Assert.assertEquals((Object)taskId, (Object)comment.getTaskId());
            Assert.assertNull((Object)comment.getProcessInstanceId());
            Assert.assertEquals((Object)"look at this isn't this great? slkdjf sldkfjs ldkfjs ldkfjs ldkfj sldkfj sldkfj sldkjg laksfg sdfgsd;flgkj ksajdhf skjdfh ksjdhf skjdhf kalskjgh lskh dfialurhg ...", (Object)((Event)comment).getMessage());
            Assert.assertEquals((Object)"look at this \n       isn't this great? slkdjf sldkfjs ldkfjs ldkfjs ldkfj sldkfj sldkfj sldkjg laksfg sdfgsd;flgkj ksajdhf skjdfh ksjdhf skjdhf kalskjgh lskh dfialurhg kajsh dfuieqpgkja rzvkfnjviuqerhogiuvysbegkjz lkhf ais liasduh flaisduh ajiasudh vaisudhv nsfd", (Object)comment.getFullMessage());
            Assert.assertNotNull((Object)comment.getTime());
            this.taskService.createComment(taskId, "pid", "one");
            this.taskService.createComment(taskId, "pid", "two");
            HashSet<String> expectedComments = new HashSet<String>();
            expectedComments.add("one");
            expectedComments.add("two");
            HashSet<String> comments = new HashSet<String>();
            for (Comment cmt : this.taskService.getProcessInstanceComments("pid")) {
                comments.add(cmt.getFullMessage());
            }
            Assert.assertEquals(expectedComments, comments);
            this.taskService.deleteTask(taskId, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddTaskCommentNull() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Task task = this.taskService.newTask("testId");
            this.taskService.saveTask(task);
            try {
                this.taskService.createComment(task.getId(), null, null);
                Assert.fail((String)"Expected process engine exception");
            }
            catch (ProcessEngineException processEngineException) {
            }
            finally {
                this.taskService.deleteTask(task.getId(), true);
            }
        }
    }

    @Test
    public void testAddTaskNullComment() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            try {
                this.taskService.createComment(null, null, "test");
                Assert.fail((String)"Expected process engine exception");
            }
            catch (ProcessEngineException processEngineException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testTaskAttachments() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Task task = this.taskService.newTask();
            task.setOwner("johndoe");
            this.taskService.saveTask(task);
            String taskId = task.getId();
            this.identityService.setAuthenticatedUserId("johndoe");
            this.taskService.createAttachment("web page", taskId, "someprocessinstanceid", "weatherforcast", "temperatures and more", "http://weather.com");
            Attachment attachment = (Attachment)this.taskService.getTaskAttachments(taskId).get(0);
            Assert.assertEquals((Object)"weatherforcast", (Object)attachment.getName());
            Assert.assertEquals((Object)"temperatures and more", (Object)attachment.getDescription());
            Assert.assertEquals((Object)"web page", (Object)attachment.getType());
            Assert.assertEquals((Object)taskId, (Object)attachment.getTaskId());
            Assert.assertEquals((Object)"someprocessinstanceid", (Object)attachment.getProcessInstanceId());
            Assert.assertEquals((Object)"http://weather.com", (Object)attachment.getUrl());
            Assert.assertNull((Object)this.taskService.getAttachmentContent(attachment.getId()));
            this.taskService.deleteTask(taskId);
            Assert.assertEquals((long)0L, (long)this.taskService.getTaskComments(taskId).size());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).list().size());
            this.taskService.deleteTask(taskId, true);
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testProcessAttachmentsOneProcessExecution() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Attachment attachment = this.taskService.createAttachment("web page", null, processInstance.getId(), "weatherforcast", "temperatures and more", "http://weather.com");
        Assert.assertEquals((Object)"weatherforcast", (Object)attachment.getName());
        Assert.assertEquals((Object)"temperatures and more", (Object)attachment.getDescription());
        Assert.assertEquals((Object)"web page", (Object)attachment.getType());
        Assert.assertNull((Object)attachment.getTaskId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)attachment.getProcessInstanceId());
        Assert.assertEquals((Object)"http://weather.com", (Object)attachment.getUrl());
        Assert.assertNull((Object)this.taskService.getAttachmentContent(attachment.getId()));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoParallelTasksProcess.bpmn20.xml"})
    public void testProcessAttachmentsTwoProcessExecutions() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoParallelTasksProcess");
        Attachment attachment = this.taskService.createAttachment("web page", null, processInstance.getId(), "weatherforcast", "temperatures and more", "http://weather.com");
        Assert.assertEquals((Object)"weatherforcast", (Object)attachment.getName());
        Assert.assertEquals((Object)"temperatures and more", (Object)attachment.getDescription());
        Assert.assertEquals((Object)"web page", (Object)attachment.getType());
        Assert.assertNull((Object)attachment.getTaskId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)attachment.getProcessInstanceId());
        Assert.assertEquals((Object)"http://weather.com", (Object)attachment.getUrl());
        Assert.assertNull((Object)this.taskService.getAttachmentContent(attachment.getId()));
    }

    @Test
    public void testSaveAttachment() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Task task = this.taskService.newTask();
            this.taskService.saveTask(task);
            String attachmentType = "someAttachment";
            String processInstanceId = "someProcessInstanceId";
            String attachmentName = "attachmentName";
            String attachmentDescription = "attachmentDescription";
            String url = "http://camunda.org";
            Attachment attachment = this.taskService.createAttachment(attachmentType, task.getId(), processInstanceId, attachmentName, attachmentDescription, url);
            attachment.setDescription("updatedDescription");
            attachment.setName("updatedName");
            this.taskService.saveAttachment(attachment);
            Attachment fetchedAttachment = this.taskService.getAttachment(attachment.getId());
            Assert.assertEquals((Object)attachment.getId(), (Object)fetchedAttachment.getId());
            Assert.assertEquals((Object)attachmentType, (Object)fetchedAttachment.getType());
            Assert.assertEquals((Object)task.getId(), (Object)fetchedAttachment.getTaskId());
            Assert.assertEquals((Object)processInstanceId, (Object)fetchedAttachment.getProcessInstanceId());
            Assert.assertEquals((Object)"updatedName", (Object)fetchedAttachment.getName());
            Assert.assertEquals((Object)"updatedDescription", (Object)fetchedAttachment.getDescription());
            Assert.assertEquals((Object)url, (Object)fetchedAttachment.getUrl());
            this.taskService.deleteTask(task.getId(), true);
        }
    }

    @Test
    public void testTaskDelegation() {
        Task task = this.taskService.newTask();
        task.setOwner("johndoe");
        task.delegate("joesmoe");
        this.taskService.saveTask(task);
        String taskId = task.getId();
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        Assert.assertEquals((Object)"johndoe", (Object)task.getOwner());
        Assert.assertEquals((Object)"joesmoe", (Object)task.getAssignee());
        Assert.assertEquals((Object)DelegationState.PENDING, (Object)task.getDelegationState());
        this.taskService.resolveTask(taskId);
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        Assert.assertEquals((Object)"johndoe", (Object)task.getOwner());
        Assert.assertEquals((Object)"johndoe", (Object)task.getAssignee());
        Assert.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
        task.setAssignee(null);
        task.setDelegationState(null);
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        Assert.assertEquals((Object)"johndoe", (Object)task.getOwner());
        Assert.assertNull((Object)task.getAssignee());
        Assert.assertNull((Object)task.getDelegationState());
        task.setAssignee("jackblack");
        task.setDelegationState(DelegationState.RESOLVED);
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        Assert.assertEquals((Object)"johndoe", (Object)task.getOwner());
        Assert.assertEquals((Object)"jackblack", (Object)task.getAssignee());
        Assert.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    public void testTaskDelegationThroughServiceCall() {
        Task task = this.taskService.newTask();
        task.setOwner("johndoe");
        this.taskService.saveTask(task);
        String taskId = task.getId();
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        this.taskService.delegateTask(taskId, "joesmoe");
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        Assert.assertEquals((Object)"johndoe", (Object)task.getOwner());
        Assert.assertEquals((Object)"joesmoe", (Object)task.getAssignee());
        Assert.assertEquals((Object)DelegationState.PENDING, (Object)task.getDelegationState());
        this.taskService.resolveTask(taskId);
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        Assert.assertEquals((Object)"johndoe", (Object)task.getOwner());
        Assert.assertEquals((Object)"johndoe", (Object)task.getAssignee());
        Assert.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    public void testTaskAssignee() {
        Task task = this.taskService.newTask();
        task.setAssignee("johndoe");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        Assert.assertEquals((Object)"johndoe", (Object)task.getAssignee());
        task.setAssignee("joesmoe");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        Assert.assertEquals((Object)"joesmoe", (Object)task.getAssignee());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    public void testSaveTaskNullTask() {
        try {
            this.taskService.saveTask(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("task is null", ae.getMessage());
        }
    }

    @Test
    public void testDeleteTaskNullTaskId() {
        try {
            this.taskService.deleteTask(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteTaskUnexistingTaskId() {
        this.taskService.deleteTask("unexistingtaskid");
    }

    @Test
    public void testDeleteTasksNullTaskIds() {
        try {
            this.taskService.deleteTasks(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteTasksTaskIdsUnexistingTaskId() {
        Task existingTask = this.taskService.newTask();
        this.taskService.saveTask(existingTask);
        this.taskService.deleteTasks(Arrays.asList("unexistingtaskid1", existingTask.getId()), true);
        existingTask = (Task)this.taskService.createTaskQuery().taskId(existingTask.getId()).singleResult();
        Assert.assertNull((Object)existingTask);
    }

    @Test
    public void testClaimNullArguments() {
        try {
            this.taskService.claim(null, "userid");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Test
    public void testClaimUnexistingTaskId() {
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        try {
            this.taskService.claim("unexistingtaskid", user.getId());
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("Cannot find task with id unexistingtaskid", ae.getMessage());
        }
        this.identityService.deleteUser(user.getId());
    }

    @Test
    public void testClaimAlreadyClaimedTaskByOtherUser() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        User secondUser = this.identityService.newUser("seconduser");
        this.identityService.saveUser(secondUser);
        this.taskService.claim(task.getId(), user.getId());
        try {
            this.taskService.claim(task.getId(), secondUser.getId());
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (TaskAlreadyClaimedException ae) {
            this.testRule.assertTextPresent("Task '" + task.getId() + "' is already claimed by someone else.", ae.getMessage());
        }
        this.taskService.deleteTask(task.getId(), true);
        this.identityService.deleteUser(user.getId());
        this.identityService.deleteUser(secondUser.getId());
    }

    @Test
    public void testClaimAlreadyClaimedTaskBySameUser() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        this.taskService.claim(task.getId(), user.getId());
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        this.taskService.claim(task.getId(), user.getId());
        this.taskService.deleteTask(task.getId(), true);
        this.identityService.deleteUser(user.getId());
    }

    @Test
    public void testUnClaimTask() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        this.taskService.claim(task.getId(), user.getId());
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        Assert.assertEquals((Object)user.getId(), (Object)task.getAssignee());
        this.taskService.claim(task.getId(), null);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        Assert.assertNull((Object)task.getAssignee());
        this.taskService.deleteTask(task.getId(), true);
        this.identityService.deleteUser(user.getId());
    }

    @Test
    public void testCompleteTaskNullTaskId() {
        try {
            this.taskService.complete(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Test
    public void testCompleteTaskUnexistingTaskId() {
        try {
            this.taskService.complete("unexistingtask");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("Cannot find task with id unexistingtask", ae.getMessage());
        }
    }

    @Test
    public void testCompleteTaskWithParametersNullTaskId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("myKey", "myValue");
        try {
            this.taskService.complete(null, variables);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Test
    public void testCompleteTaskWithParametersUnexistingTaskId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("myKey", "myValue");
        try {
            this.taskService.complete("unexistingtask", variables);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("Cannot find task with id unexistingtask", ae.getMessage());
        }
    }

    @Test
    public void testCompleteTaskWithParametersNullParameters() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.complete(taskId, null);
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            this.historyService.deleteHistoricTaskInstance(taskId);
        }
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        Assert.assertNull((Object)task);
    }

    @Test
    public void testCompleteTaskWithParametersEmptyParameters() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.complete(taskId, Collections.EMPTY_MAP);
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            this.historyService.deleteHistoricTaskInstance(taskId);
        }
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        Assert.assertNull((Object)task);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    @Test
    public void testCompleteWithParametersTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoTasksProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"First task", (Object)task.getName());
        HashMap<String, String> taskParams = new HashMap<String, String>();
        taskParams.put("myParam", "myValue");
        this.taskService.complete(task.getId(), taskParams);
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"Second task", (Object)task.getName());
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"myValue", variables.get("myParam"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/TaskServiceTest.testCompleteTaskWithVariablesInReturn.bpmn20.xml"})
    @Test
    public void testCompleteTaskWithVariablesInReturn() {
        String processVarName = "processVar";
        String processVarValue = "processVarValue";
        String taskVarName = "taskVar";
        String taskVarValue = "taskVarValue";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(processVarName, processVarValue);
        this.runtimeService.startProcessInstanceByKey("TaskServiceTest.testCompleteTaskWithVariablesInReturn", variables);
        Task firstUserTask = (Task)this.taskService.createTaskQuery().taskName("First User Task").singleResult();
        this.taskService.setVariable(firstUserTask.getId(), "x", (Object)1);
        this.taskService.setVariableLocal(firstUserTask.getId(), "localVar", (Object)"localVarValue");
        HashMap<String, Object> additionalVariables = new HashMap<String, Object>();
        additionalVariables.put(taskVarName, taskVarValue);
        VariableMap vars = this.taskService.completeWithVariablesInReturn(firstUserTask.getId(), additionalVariables);
        Assert.assertEquals((long)3L, (long)vars.size());
        Assert.assertEquals((Object)5, (Object)vars.get((Object)"x"));
        Assert.assertEquals((Object)ValueType.INTEGER, (Object)vars.getValueTyped("x").getType());
        Assert.assertEquals((Object)processVarValue, (Object)vars.get((Object)processVarName));
        Assert.assertEquals((Object)taskVarValue, (Object)vars.get((Object)taskVarName));
        Assert.assertEquals((Object)ValueType.STRING, (Object)vars.getValueTyped(taskVarName).getType());
        additionalVariables = new HashMap();
        additionalVariables.put("x", 7);
        Task secondUserTask = (Task)this.taskService.createTaskQuery().taskName("Second User Task").singleResult();
        vars = this.taskService.completeWithVariablesInReturn(secondUserTask.getId(), additionalVariables);
        Assert.assertEquals((long)3L, (long)vars.size());
        Assert.assertEquals((Object)7, (Object)vars.get((Object)"x"));
        Assert.assertEquals((Object)processVarValue, (Object)vars.get((Object)processVarName));
        Assert.assertEquals((Object)taskVarValue, (Object)vars.get((Object)taskVarName));
    }

    @Test
    @RequiredHistoryLevel(value="audit")
    public void testCompleteStandaloneTaskWithVariablesInReturn() {
        String taskVarName = "taskVar";
        String taskVarValue = "taskVarValue";
        String taskId = "myTask";
        Task standaloneTask = this.taskService.newTask(taskId);
        this.taskService.saveTask(standaloneTask);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(taskVarName, taskVarValue);
        VariableMap returnedVariables = this.taskService.completeWithVariablesInReturn(taskId, variables);
        Assert.assertEquals((long)0L, (long)returnedVariables.size());
        this.historyService.deleteHistoricTaskInstance(taskId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoParallelTasksProcess.bpmn20.xml"})
    @Test
    public void testCompleteTaskWithVariablesInReturnParallel() {
        String processVarName = "processVar";
        String processVarValue = "processVarValue";
        String task1VarName = "taskVar1";
        String task2VarName = "taskVar2";
        String task1VarValue = "taskVarValue1";
        String task2VarValue = "taskVarValue2";
        String additionalVar = "additionalVar";
        String additionalVarValue = "additionalVarValue";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(processVarName, processVarValue);
        this.runtimeService.startProcessInstanceByKey("twoParallelTasksProcess", variables);
        Task firstTask = (Task)this.taskService.createTaskQuery().taskName("First Task").singleResult();
        this.taskService.setVariable(firstTask.getId(), task1VarName, (Object)task1VarValue);
        Task secondTask = (Task)this.taskService.createTaskQuery().taskName("Second Task").singleResult();
        this.taskService.setVariable(secondTask.getId(), task2VarName, (Object)task2VarValue);
        VariableMap vars = this.taskService.completeWithVariablesInReturn(firstTask.getId(), null);
        Assert.assertEquals((long)3L, (long)vars.size());
        Assert.assertEquals((Object)processVarValue, vars.get(processVarName));
        Assert.assertEquals((Object)task1VarValue, vars.get(task1VarName));
        Assert.assertEquals((Object)task2VarValue, vars.get(task2VarName));
        HashMap<String, String> additionalVariables = new HashMap<String, String>();
        additionalVariables.put(additionalVar, additionalVarValue);
        vars = this.taskService.completeWithVariablesInReturn(secondTask.getId(), additionalVariables);
        Assert.assertEquals((long)4L, (long)vars.size());
        Assert.assertEquals((Object)processVarValue, vars.get(processVarName));
        Assert.assertEquals((Object)task1VarValue, vars.get(task1VarName));
        Assert.assertEquals((Object)task2VarValue, vars.get(task2VarName));
        Assert.assertEquals((Object)additionalVarValue, vars.get(additionalVar));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCompleteTaskWithVariablesInReturnCMMN() {
        String taskVariableName = "taskVar";
        String taskVariableValue = "taskVal";
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        Task task1 = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task1);
        this.taskService.setVariable(task1.getId(), taskVariableName, (Object)taskVariableValue);
        VariableMap vars = this.taskService.completeWithVariablesInReturn(task1.getId(), null);
        Assert.assertNull((Object)vars);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testCompleteTaskShouldCompleteCaseExecution() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNull((Object)task);
        CaseExecution caseExecution = (CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult();
        Assert.assertNull((Object)caseExecution);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        Assert.assertNotNull((Object)caseInstance);
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Test
    public void testResolveTaskNullTaskId() {
        try {
            this.taskService.resolveTask(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Test
    public void testResolveTaskUnexistingTaskId() {
        try {
            this.taskService.resolveTask("unexistingtask");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("Cannot find task with id unexistingtask", ae.getMessage());
        }
    }

    @Test
    public void testResolveTaskWithParametersNullParameters() {
        Task task = this.taskService.newTask();
        task.setDelegationState(DelegationState.PENDING);
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.resolveTask(taskId, null);
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            this.historyService.deleteHistoricTaskInstance(taskId);
        }
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        Assert.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    public void testResolveTaskWithParametersEmptyParameters() {
        Task task = this.taskService.newTask();
        task.setDelegationState(DelegationState.PENDING);
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.resolveTask(taskId, Collections.EMPTY_MAP);
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_AUDIT) {
            this.historyService.deleteHistoricTaskInstance(taskId);
        }
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        Assert.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
        this.taskService.deleteTask(taskId, true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    @Test
    public void testResolveWithParametersTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("twoTasksProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"First task", (Object)task.getName());
        task.delegate("johndoe");
        HashMap<String, String> taskParams = new HashMap<String, String>();
        taskParams.put("myParam", "myValue");
        this.taskService.resolveTask(task.getId(), taskParams);
        task = (Task)this.taskService.createTaskQuery().taskDelegationState(DelegationState.RESOLVED).singleResult();
        Assert.assertEquals((Object)"First task", (Object)task.getName());
        Map variables = this.runtimeService.getVariables(processInstance.getId());
        Assert.assertEquals((long)1L, (long)variables.size());
        Assert.assertEquals((Object)"myValue", variables.get("myParam"));
    }

    @Test
    public void testSetAssignee() {
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        Task task = this.taskService.newTask();
        Assert.assertNull((Object)task.getAssignee());
        this.taskService.saveTask(task);
        this.taskService.setAssignee(task.getId(), user.getId());
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        Assert.assertEquals((Object)user.getId(), (Object)task.getAssignee());
        this.identityService.deleteUser(user.getId());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    public void testSetAssigneeNullTaskId() {
        try {
            this.taskService.setAssignee(null, "userId");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Test
    public void testSetAssigneeUnexistingTask() {
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        try {
            this.taskService.setAssignee("unexistingTaskId", user.getId());
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("Cannot find task with id unexistingTaskId", ae.getMessage());
        }
        this.identityService.deleteUser(user.getId());
    }

    @Test
    public void testAddCandidateUserDuplicate() {
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.addCandidateUser(task.getId(), user.getId());
        this.taskService.addCandidateUser(task.getId(), user.getId());
        this.identityService.deleteUser(user.getId());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    public void testAddCandidateUserNullTaskId() {
        try {
            this.taskService.addCandidateUser(null, "userId");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Test
    public void testAddCandidateUserNullUserId() {
        try {
            this.taskService.addCandidateUser("taskId", null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("userId and groupId cannot both be null", ae.getMessage());
        }
    }

    @Test
    public void testAddCandidateUserUnexistingTask() {
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        try {
            this.taskService.addCandidateUser("unexistingTaskId", user.getId());
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("Cannot find task with id unexistingTaskId", ae.getMessage());
        }
        this.identityService.deleteUser(user.getId());
    }

    @Test
    public void testAddCandidateGroupNullTaskId() {
        try {
            this.taskService.addCandidateGroup(null, "groupId");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Test
    public void testAddCandidateGroupNullGroupId() {
        try {
            this.taskService.addCandidateGroup("taskId", null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("userId and groupId cannot both be null", ae.getMessage());
        }
    }

    @Test
    public void testAddCandidateGroupUnexistingTask() {
        Group group = this.identityService.newGroup("group");
        this.identityService.saveGroup(group);
        try {
            this.taskService.addCandidateGroup("unexistingTaskId", group.getId());
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("Cannot find task with id unexistingTaskId", ae.getMessage());
        }
        this.identityService.deleteGroup(group.getId());
    }

    @Test
    public void testAddGroupIdentityLinkNullTaskId() {
        try {
            this.taskService.addGroupIdentityLink(null, "groupId", "candidate");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Test
    public void testAddGroupIdentityLinkNullUserId() {
        try {
            this.taskService.addGroupIdentityLink("taskId", null, "candidate");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("userId and groupId cannot both be null", ae.getMessage());
        }
    }

    @Test
    public void testAddGroupIdentityLinkUnexistingTask() {
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        try {
            this.taskService.addGroupIdentityLink("unexistingTaskId", user.getId(), "candidate");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("Cannot find task with id unexistingTaskId", ae.getMessage());
        }
        this.identityService.deleteUser(user.getId());
    }

    @Test
    public void testAddUserIdentityLinkNullTaskId() {
        try {
            this.taskService.addUserIdentityLink(null, "userId", "candidate");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Test
    public void testAddUserIdentityLinkNullUserId() {
        try {
            this.taskService.addUserIdentityLink("taskId", null, "candidate");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("userId and groupId cannot both be null", ae.getMessage());
        }
    }

    @Test
    public void testAddUserIdentityLinkUnexistingTask() {
        User user = this.identityService.newUser("user");
        this.identityService.saveUser(user);
        try {
            this.taskService.addUserIdentityLink("unexistingTaskId", user.getId(), "candidate");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("Cannot find task with id unexistingTaskId", ae.getMessage());
        }
        this.identityService.deleteUser(user.getId());
    }

    @Test
    public void testGetIdentityLinksWithCandidateUser() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.taskService.addCandidateUser(taskId, "kermit");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        Assert.assertEquals((long)1L, (long)identityLinks.size());
        Assert.assertEquals((Object)"kermit", (Object)((IdentityLink)identityLinks.get(0)).getUserId());
        Assert.assertNull((Object)((IdentityLink)identityLinks.get(0)).getGroupId());
        Assert.assertEquals((Object)"candidate", (Object)((IdentityLink)identityLinks.get(0)).getType());
        this.taskService.deleteTask(taskId, true);
        this.identityService.deleteUser("kermit");
    }

    @Test
    public void testGetIdentityLinksWithCandidateGroup() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.identityService.saveGroup(this.identityService.newGroup("muppets"));
        this.taskService.addCandidateGroup(taskId, "muppets");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        Assert.assertEquals((long)1L, (long)identityLinks.size());
        Assert.assertEquals((Object)"muppets", (Object)((IdentityLink)identityLinks.get(0)).getGroupId());
        Assert.assertNull((Object)((IdentityLink)identityLinks.get(0)).getUserId());
        Assert.assertEquals((Object)"candidate", (Object)((IdentityLink)identityLinks.get(0)).getType());
        this.taskService.deleteTask(taskId, true);
        this.identityService.deleteGroup("muppets");
    }

    @Test
    public void testGetIdentityLinksWithAssignee() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.taskService.claim(taskId, "kermit");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        Assert.assertEquals((long)1L, (long)identityLinks.size());
        Assert.assertEquals((Object)"kermit", (Object)((IdentityLink)identityLinks.get(0)).getUserId());
        Assert.assertNull((Object)((IdentityLink)identityLinks.get(0)).getGroupId());
        Assert.assertEquals((Object)"assignee", (Object)((IdentityLink)identityLinks.get(0)).getType());
        this.taskService.deleteTask(taskId, true);
        this.identityService.deleteUser("kermit");
    }

    @Test
    public void testGetIdentityLinksWithNonExistingAssignee() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.claim(taskId, "nonExistingAssignee");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        Assert.assertEquals((long)1L, (long)identityLinks.size());
        Assert.assertEquals((Object)"nonExistingAssignee", (Object)((IdentityLink)identityLinks.get(0)).getUserId());
        Assert.assertNull((Object)((IdentityLink)identityLinks.get(0)).getGroupId());
        Assert.assertEquals((Object)"assignee", (Object)((IdentityLink)identityLinks.get(0)).getType());
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    public void testGetIdentityLinksWithOwner() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.identityService.saveUser(this.identityService.newUser("fozzie"));
        this.taskService.claim(taskId, "kermit");
        this.taskService.delegateTask(taskId, "fozzie");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        Assert.assertEquals((long)2L, (long)identityLinks.size());
        IdentityLink assignee = (IdentityLink)identityLinks.get(0);
        Assert.assertEquals((Object)"fozzie", (Object)assignee.getUserId());
        Assert.assertNull((Object)assignee.getGroupId());
        Assert.assertEquals((Object)"assignee", (Object)assignee.getType());
        IdentityLink owner = (IdentityLink)identityLinks.get(1);
        Assert.assertEquals((Object)"kermit", (Object)owner.getUserId());
        Assert.assertNull((Object)owner.getGroupId());
        Assert.assertEquals((Object)"owner", (Object)owner.getType());
        this.taskService.deleteTask(taskId, true);
        this.identityService.deleteUser("kermit");
        this.identityService.deleteUser("fozzie");
    }

    @Test
    public void testGetIdentityLinksWithNonExistingOwner() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        String taskId = task.getId();
        this.taskService.claim(taskId, "nonExistingOwner");
        this.taskService.delegateTask(taskId, "nonExistingAssignee");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        Assert.assertEquals((long)2L, (long)identityLinks.size());
        IdentityLink assignee = (IdentityLink)identityLinks.get(0);
        Assert.assertEquals((Object)"nonExistingAssignee", (Object)assignee.getUserId());
        Assert.assertNull((Object)assignee.getGroupId());
        Assert.assertEquals((Object)"assignee", (Object)assignee.getType());
        IdentityLink owner = (IdentityLink)identityLinks.get(1);
        Assert.assertEquals((Object)"nonExistingOwner", (Object)owner.getUserId());
        Assert.assertNull((Object)owner.getGroupId());
        Assert.assertEquals((Object)"owner", (Object)owner.getType());
        this.taskService.deleteTask(taskId, true);
    }

    @Test
    public void testSetPriority() {
        Task task = this.taskService.newTask();
        this.taskService.saveTask(task);
        this.taskService.setPriority(task.getId(), 12345);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        Assert.assertEquals((long)12345L, (long)task.getPriority());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    public void testSetPriorityUnexistingTaskId() {
        try {
            this.taskService.setPriority("unexistingtask", 12345);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("Cannot find task with id unexistingtask", ae.getMessage());
        }
    }

    @Test
    public void testSetPriorityNullTaskId() {
        try {
            this.taskService.setPriority(null, 12345);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Test
    public void testSetDelegationState() {
        Task task = this.taskService.newTask();
        task.setOwner("wuzh");
        task.delegate("other");
        this.taskService.saveTask(task);
        String taskId = task.getId();
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        Assert.assertEquals((Object)"wuzh", (Object)task.getOwner());
        Assert.assertEquals((Object)"other", (Object)task.getAssignee());
        Assert.assertEquals((Object)DelegationState.PENDING, (Object)task.getDelegationState());
        task.setDelegationState(DelegationState.RESOLVED);
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        Assert.assertEquals((Object)"wuzh", (Object)task.getOwner());
        Assert.assertEquals((Object)"other", (Object)task.getAssignee());
        Assert.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
        this.taskService.deleteTask(taskId, true);
    }

    private void checkHistoricVariableUpdateEntity(String variableName, String processInstanceId) {
        if (this.processEngineConfiguration.getHistoryLevel().getId() == ProcessEngineConfigurationImpl.HISTORYLEVEL_FULL) {
            boolean deletedVariableUpdateFound = false;
            List resultSet = this.historyService.createHistoricDetailQuery().processInstanceId(processInstanceId).list();
            for (HistoricDetail currentHistoricDetail : resultSet) {
                Assert.assertTrue((boolean)(currentHistoricDetail instanceof HistoricDetailVariableInstanceUpdateEntity));
                HistoricDetailVariableInstanceUpdateEntity historicVariableUpdate = (HistoricDetailVariableInstanceUpdateEntity)currentHistoricDetail;
                if (!historicVariableUpdate.getName().equals(variableName) || historicVariableUpdate.getValue() != null) continue;
                if (deletedVariableUpdateFound) {
                    Assert.fail((String)"Mismatch: A HistoricVariableUpdateEntity with a null value already found");
                    continue;
                }
                deletedVariableUpdateFound = true;
            }
            Assert.assertTrue((boolean)deletedVariableUpdateFound);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testRemoveVariable() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariable(currentTask.getId(), "variable1", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        Assert.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable1"));
        this.taskService.removeVariable(currentTask.getId(), "variable1");
        Assert.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
    }

    @Test
    public void testRemoveVariableNullTaskId() {
        try {
            this.taskService.removeVariable(null, "variable");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testRemoveVariables() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, String> varsToDelete = new HashMap<String, String>();
        varsToDelete.put("variable1", "value1");
        varsToDelete.put("variable2", "value2");
        this.taskService.setVariables(currentTask.getId(), varsToDelete);
        this.taskService.setVariable(currentTask.getId(), "variable3", (Object)"value3");
        Assert.assertEquals((Object)"value1", (Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        Assert.assertEquals((Object)"value2", (Object)this.taskService.getVariable(currentTask.getId(), "variable2"));
        Assert.assertEquals((Object)"value3", (Object)this.taskService.getVariable(currentTask.getId(), "variable3"));
        Assert.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable1"));
        Assert.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable2"));
        Assert.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable3"));
        this.taskService.removeVariables(currentTask.getId(), varsToDelete.keySet());
        Assert.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        Assert.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable2"));
        Assert.assertEquals((Object)"value3", (Object)this.taskService.getVariable(currentTask.getId(), "variable3"));
        Assert.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable1"));
        Assert.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable2"));
        Assert.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable3"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
        this.checkHistoricVariableUpdateEntity("variable2", processInstance.getId());
    }

    @Test
    public void testRemoveVariablesNullTaskId() {
        try {
            this.taskService.removeVariables(null, (Collection)Collections.EMPTY_LIST);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testRemoveVariableLocal() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.setVariableLocal(currentTask.getId(), "variable1", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        Assert.assertEquals((Object)"value1", (Object)this.taskService.getVariableLocal(currentTask.getId(), "variable1"));
        this.taskService.removeVariableLocal(currentTask.getId(), "variable1");
        Assert.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        Assert.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable1"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
    }

    @Test
    public void testRemoveVariableLocalNullTaskId() {
        try {
            this.taskService.removeVariableLocal(null, "variable");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testRemoveVariablesLocal() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, String> varsToDelete = new HashMap<String, String>();
        varsToDelete.put("variable1", "value1");
        varsToDelete.put("variable2", "value2");
        this.taskService.setVariablesLocal(currentTask.getId(), varsToDelete);
        this.taskService.setVariableLocal(currentTask.getId(), "variable3", (Object)"value3");
        Assert.assertEquals((Object)"value1", (Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        Assert.assertEquals((Object)"value2", (Object)this.taskService.getVariable(currentTask.getId(), "variable2"));
        Assert.assertEquals((Object)"value3", (Object)this.taskService.getVariable(currentTask.getId(), "variable3"));
        Assert.assertEquals((Object)"value1", (Object)this.taskService.getVariableLocal(currentTask.getId(), "variable1"));
        Assert.assertEquals((Object)"value2", (Object)this.taskService.getVariableLocal(currentTask.getId(), "variable2"));
        Assert.assertEquals((Object)"value3", (Object)this.taskService.getVariableLocal(currentTask.getId(), "variable3"));
        this.taskService.removeVariables(currentTask.getId(), varsToDelete.keySet());
        Assert.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        Assert.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable2"));
        Assert.assertEquals((Object)"value3", (Object)this.taskService.getVariable(currentTask.getId(), "variable3"));
        Assert.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable1"));
        Assert.assertNull((Object)this.taskService.getVariableLocal(currentTask.getId(), "variable2"));
        Assert.assertEquals((Object)"value3", (Object)this.taskService.getVariableLocal(currentTask.getId(), "variable3"));
        this.checkHistoricVariableUpdateEntity("variable1", processInstance.getId());
        this.checkHistoricVariableUpdateEntity("variable2", processInstance.getId());
    }

    @Test
    public void testRemoveVariablesLocalNullTaskId() {
        try {
            this.taskService.removeVariablesLocal(null, (Collection)Collections.EMPTY_LIST);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("taskId is null", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testUserTaskOptimisticLocking() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task1 = (Task)this.taskService.createTaskQuery().singleResult();
        Task task2 = (Task)this.taskService.createTaskQuery().singleResult();
        task1.setDescription("test description one");
        this.taskService.saveTask(task1);
        try {
            task2.setDescription("test description two");
            this.taskService.saveTask(task2);
            Assert.fail((String)"Expecting exception");
        }
        catch (OptimisticLockingException optimisticLockingException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteTaskWithDeleteReason() {
        if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_ACTIVITY) {
            Task task = this.taskService.newTask();
            task.setName("test task");
            this.taskService.saveTask(task);
            Assert.assertNotNull((Object)task.getId());
            this.taskService.deleteTask(task.getId(), "deleted for testing purposes");
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult();
            Assert.assertNotNull((Object)historicTaskInstance);
            Assert.assertEquals((Object)"deleted for testing purposes", (Object)historicTaskInstance.getDeleteReason());
            this.taskService.deleteTask(task.getId(), true);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteTaskPartOfProcess() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        try {
            this.taskService.deleteTask(task.getId());
        }
        catch (ProcessEngineException ae) {
            Assert.assertEquals((Object)"The task cannot be deleted because is part of a running process", (Object)ae.getMessage());
        }
        try {
            this.taskService.deleteTask(task.getId(), true);
        }
        catch (ProcessEngineException ae) {
            Assert.assertEquals((Object)"The task cannot be deleted because is part of a running process", (Object)ae.getMessage());
        }
        try {
            this.taskService.deleteTask(task.getId(), "test");
        }
        catch (ProcessEngineException ae) {
            Assert.assertEquals((Object)"The task cannot be deleted because is part of a running process", (Object)ae.getMessage());
        }
        try {
            this.taskService.deleteTasks(Arrays.asList(task.getId()));
        }
        catch (ProcessEngineException ae) {
            Assert.assertEquals((Object)"The task cannot be deleted because is part of a running process", (Object)ae.getMessage());
        }
        try {
            this.taskService.deleteTasks(Arrays.asList(task.getId()), true);
        }
        catch (ProcessEngineException ae) {
            Assert.assertEquals((Object)"The task cannot be deleted because is part of a running process", (Object)ae.getMessage());
        }
        try {
            this.taskService.deleteTasks(Arrays.asList(task.getId()), "test");
        }
        catch (ProcessEngineException ae) {
            Assert.assertEquals((Object)"The task cannot be deleted because is part of a running process", (Object)ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testDeleteTaskPartOfCaseInstance() {
        String caseDefinitionId = ((CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult()).getId();
        this.caseService.withCaseDefinition(caseDefinitionId).create();
        String caseExecutionId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        try {
            this.taskService.deleteTask(task.getId());
            Assert.fail((String)"Should not be possible to delete task");
        }
        catch (ProcessEngineException ae) {
            Assert.assertEquals((Object)"The task cannot be deleted because is part of a running case instance", (Object)ae.getMessage());
        }
        try {
            this.taskService.deleteTask(task.getId(), true);
            Assert.fail((String)"Should not be possible to delete task");
        }
        catch (ProcessEngineException ae) {
            Assert.assertEquals((Object)"The task cannot be deleted because is part of a running case instance", (Object)ae.getMessage());
        }
        try {
            this.taskService.deleteTask(task.getId(), "test");
            Assert.fail((String)"Should not be possible to delete task");
        }
        catch (ProcessEngineException ae) {
            Assert.assertEquals((Object)"The task cannot be deleted because is part of a running case instance", (Object)ae.getMessage());
        }
        try {
            this.taskService.deleteTasks(Arrays.asList(task.getId()));
            Assert.fail((String)"Should not be possible to delete task");
        }
        catch (ProcessEngineException ae) {
            Assert.assertEquals((Object)"The task cannot be deleted because is part of a running case instance", (Object)ae.getMessage());
        }
        try {
            this.taskService.deleteTasks(Arrays.asList(task.getId()), true);
            Assert.fail((String)"Should not be possible to delete task");
        }
        catch (ProcessEngineException ae) {
            Assert.assertEquals((Object)"The task cannot be deleted because is part of a running case instance", (Object)ae.getMessage());
        }
        try {
            this.taskService.deleteTasks(Arrays.asList(task.getId()), "test");
            Assert.fail((String)"Should not be possible to delete task");
        }
        catch (ProcessEngineException ae) {
            Assert.assertEquals((Object)"The task cannot be deleted because is part of a running case instance", (Object)ae.getMessage());
        }
    }

    @Test
    public void testGetTaskCommentByTaskIdAndCommentId() {
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Task task = this.taskService.newTask();
            this.taskService.saveTask(task);
            String taskId = task.getId();
            Comment comment = this.taskService.createComment(taskId, null, "look at this \n       isn't this great? slkdjf sldkfjs ldkfjs ldkfjs ldkfj sldkfj sldkfj sldkjg laksfg sdfgsd;flgkj ksajdhf skjdfh ksjdhf skjdhf kalskjgh lskh dfialurhg kajsh dfuieqpgkja rzvkfnjviuqerhogiuvysbegkjz lkhf ais liasduh flaisduh ajiasudh vaisudhv nsfd");
            comment = this.taskService.getTaskComment(taskId, comment.getId());
            Assert.assertNotNull((Object)comment.getId());
            Assert.assertEquals((Object)taskId, (Object)comment.getTaskId());
            Assert.assertNull((Object)comment.getProcessInstanceId());
            Assert.assertEquals((Object)"look at this isn't this great? slkdjf sldkfjs ldkfjs ldkfjs ldkfj sldkfj sldkfj sldkjg laksfg sdfgsd;flgkj ksajdhf skjdfh ksjdhf skjdhf kalskjgh lskh dfialurhg ...", (Object)((Event)comment).getMessage());
            Assert.assertEquals((Object)"look at this \n       isn't this great? slkdjf sldkfjs ldkfjs ldkfjs ldkfj sldkfj sldkfj sldkjg laksfg sdfgsd;flgkj ksajdhf skjdfh ksjdhf skjdhf kalskjgh lskh dfialurhg kajsh dfuieqpgkja rzvkfnjviuqerhogiuvysbegkjz lkhf ais liasduh flaisduh ajiasudh vaisudhv nsfd", (Object)comment.getFullMessage());
            Assert.assertNotNull((Object)comment.getTime());
            this.taskService.deleteTask(task.getId(), true);
        }
    }

    @Test
    public void testTaskAttachmentByTaskIdAndAttachmentId() throws ParseException {
        Date fixedDate = SDF.parse("01/01/2001 01:01:01.000");
        ClockUtil.setCurrentTime((Date)fixedDate);
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Task task = this.taskService.newTask();
            this.taskService.saveTask(task);
            String taskId = task.getId();
            Attachment attachment = this.taskService.createAttachment("web page", taskId, "someprocessinstanceid", "weatherforcast", "temperatures and more", "http://weather.com");
            String attachmentId = attachment.getId();
            attachment = this.taskService.getTaskAttachment(taskId, attachmentId);
            Assert.assertEquals((Object)"weatherforcast", (Object)attachment.getName());
            Assert.assertEquals((Object)"temperatures and more", (Object)attachment.getDescription());
            Assert.assertEquals((Object)"web page", (Object)attachment.getType());
            Assert.assertEquals((Object)taskId, (Object)attachment.getTaskId());
            Assert.assertEquals((Object)"someprocessinstanceid", (Object)attachment.getProcessInstanceId());
            Assert.assertEquals((Object)"http://weather.com", (Object)attachment.getUrl());
            Assert.assertNull((Object)this.taskService.getAttachmentContent(attachment.getId()));
            Assert.assertThat((Object)attachment.getCreateTime(), (Matcher)Is.is((Object)fixedDate));
            this.taskService.deleteTaskAttachment(taskId, attachmentId);
            Assert.assertNull((Object)this.taskService.getTaskAttachment(taskId, attachmentId));
            this.taskService.deleteTask(taskId, true);
        }
    }

    @Test
    public void testGetTaskAttachmentContentByTaskIdAndAttachmentId() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Task task = this.taskService.newTask();
            this.taskService.saveTask(task);
            String taskId = task.getId();
            Attachment attachment = this.taskService.createAttachment("web page", taskId, "someprocessinstanceid", "weatherforcast", "temperatures and more", (InputStream)new ByteArrayInputStream("someContent".getBytes()));
            String attachmentId = attachment.getId();
            InputStream taskAttachmentContent = this.taskService.getTaskAttachmentContent(taskId, attachmentId);
            Assert.assertNotNull((Object)taskAttachmentContent);
            byte[] byteContent = IoUtil.readInputStream((InputStream)taskAttachmentContent, (String)"weatherforcast");
            Assert.assertEquals((Object)"someContent", (Object)new String(byteContent));
            this.taskService.deleteTask(taskId, true);
        }
    }

    @Test
    public void testGetTaskAttachmentWithNullParameters() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Attachment attachment = this.taskService.getTaskAttachment(null, null);
            Assert.assertNull((Object)attachment);
        }
    }

    @Test
    public void testGetTaskAttachmentContentWithNullParameters() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            InputStream content = this.taskService.getTaskAttachmentContent(null, null);
            Assert.assertNull((Object)content);
        }
    }

    @RequiredHistoryLevel(value="audit")
    @Test
    public void testCreateTaskAttachmentWithNullTaskAndProcessInstance() {
        try {
            this.taskService.createAttachment("web page", null, null, "weatherforcast", "temperatures and more", (InputStream)new ByteArrayInputStream("someContent".getBytes()));
            Assert.fail((String)"expected process engine exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @RequiredHistoryLevel(value="audit")
    @Test
    public void testCreateTaskAttachmentWithNullTaskId() throws ParseException {
        Date fixedDate = SDF.parse("01/01/2001 01:01:01.000");
        ClockUtil.setCurrentTime((Date)fixedDate);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Attachment attachment = this.taskService.createAttachment("web page", null, processInstance.getId(), "weatherforcast", "temperatures and more", (InputStream)new ByteArrayInputStream("someContent".getBytes()));
        Attachment fetched = this.taskService.getAttachment(attachment.getId());
        Assert.assertThat((Object)fetched, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)fetched.getTaskId(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)fetched.getProcessInstanceId(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)fetched.getCreateTime(), (Matcher)Is.is((Object)fixedDate));
        this.taskService.deleteAttachment(attachment.getId());
    }

    @Test
    public void testDeleteTaskAttachmentWithNullParameters() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            try {
                this.taskService.deleteTaskAttachment(null, null);
                Assert.fail((String)"expected process engine exception");
            }
            catch (ProcessEngineException processEngineException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testDeleteTaskAttachmentWithTaskIdNull() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            try {
                this.taskService.deleteTaskAttachment(null, "myAttachmentId");
                Assert.fail((String)"expected process engine exception");
            }
            catch (ProcessEngineException processEngineException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGetTaskAttachmentsWithTaskIdNull() {
        int historyLevel = this.processEngineConfiguration.getHistoryLevel().getId();
        if (historyLevel > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Assert.assertEquals(Collections.emptyList(), (Object)this.taskService.getTaskAttachments(null));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    @Test
    public void testUpdateVariablesLocal() {
        HashMap<String, String> globalVars = new HashMap<String, String>();
        globalVars.put("variable4", "value4");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", globalVars);
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, String> localVars = new HashMap<String, String>();
        localVars.put("variable1", "value1");
        localVars.put("variable2", "value2");
        localVars.put("variable3", "value3");
        this.taskService.setVariablesLocal(currentTask.getId(), localVars);
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "anotherValue1");
        modifications.put("variable2", "anotherValue2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable2");
        deletions.add("variable3");
        deletions.add("variable4");
        ((TaskServiceImpl)this.taskService).updateVariablesLocal(currentTask.getId(), modifications, deletions);
        Assert.assertEquals((Object)"anotherValue1", (Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        Assert.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable2"));
        Assert.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable3"));
        Assert.assertEquals((Object)"value4", (Object)this.runtimeService.getVariable(processInstance.getId(), "variable4"));
    }

    @Test
    public void testUpdateVariablesLocalForNonExistingTaskId() {
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "anotherValue1");
        modifications.put("variable2", "anotherValue2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable2");
        deletions.add("variable3");
        deletions.add("variable4");
        try {
            ((TaskServiceImpl)this.taskService).updateVariablesLocal("nonExistingId", modifications, deletions);
            Assert.fail((String)"expected process engine exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateVariablesLocaForNullTaskId() {
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "anotherValue1");
        modifications.put("variable2", "anotherValue2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable2");
        deletions.add("variable3");
        deletions.add("variable4");
        try {
            ((TaskServiceImpl)this.taskService).updateVariablesLocal(null, modifications, deletions);
            Assert.fail((String)"expected process engine exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneSubProcess.bpmn20.xml"})
    @Test
    public void testUpdateVariables() {
        HashMap<String, String> globalVars = new HashMap<String, String>();
        globalVars.put("variable4", "value4");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("startSimpleSubProcess", globalVars);
        Task currentTask = (Task)this.taskService.createTaskQuery().singleResult();
        HashMap<String, String> localVars = new HashMap<String, String>();
        localVars.put("variable1", "value1");
        localVars.put("variable2", "value2");
        localVars.put("variable3", "value3");
        this.taskService.setVariablesLocal(currentTask.getId(), localVars);
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "anotherValue1");
        modifications.put("variable2", "anotherValue2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable2");
        deletions.add("variable3");
        deletions.add("variable4");
        ((TaskServiceImpl)this.taskService).updateVariables(currentTask.getId(), modifications, deletions);
        Assert.assertEquals((Object)"anotherValue1", (Object)this.taskService.getVariable(currentTask.getId(), "variable1"));
        Assert.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable2"));
        Assert.assertNull((Object)this.taskService.getVariable(currentTask.getId(), "variable3"));
        Assert.assertNull((Object)this.runtimeService.getVariable(processInstance.getId(), "variable4"));
    }

    @Test
    public void testUpdateVariablesForNonExistingTaskId() {
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "anotherValue1");
        modifications.put("variable2", "anotherValue2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable2");
        deletions.add("variable3");
        deletions.add("variable4");
        try {
            ((TaskServiceImpl)this.taskService).updateVariables("nonExistingId", modifications, deletions);
            Assert.fail((String)"expected process engine exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateVariablesForNullTaskId() {
        HashMap<String, String> modifications = new HashMap<String, String>();
        modifications.put("variable1", "anotherValue1");
        modifications.put("variable2", "anotherValue2");
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("variable2");
        deletions.add("variable3");
        deletions.add("variable4");
        try {
            ((TaskServiceImpl)this.taskService).updateVariables(null, modifications, deletions);
            Assert.fail((String)"expected process engine exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testTaskCaseInstanceId() {
        Task task = this.taskService.newTask();
        task.setCaseInstanceId("aCaseInstanceId");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        Assert.assertEquals((Object)"aCaseInstanceId", (Object)task.getCaseInstanceId());
        task.setCaseInstanceId("anotherCaseInstanceId");
        this.taskService.saveTask(task);
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        Assert.assertEquals((Object)"anotherCaseInstanceId", (Object)task.getCaseInstanceId());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testGetVariablesTyped() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", vars);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        VariableMap variablesTyped = this.taskService.getVariablesTyped(taskId);
        Assert.assertEquals(vars, (Object)variablesTyped);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testGetVariablesTypedDeserialize() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("broken", (Object)Variables.serializedObjectValue((String)"broken").serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).objectTypeName("unexisting").create()));
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        VariableMap variablesTyped = this.taskService.getVariablesTyped(taskId, false);
        Assert.assertNotNull((Object)variablesTyped.getValueTyped("broken"));
        variablesTyped = this.taskService.getVariablesTyped(taskId, Arrays.asList("broken"), false);
        Assert.assertNotNull((Object)variablesTyped.getValueTyped("broken"));
        try {
            this.taskService.getVariablesTyped(taskId);
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot deserialize object", e.getMessage());
        }
        try {
            this.taskService.getVariablesTyped(taskId, Arrays.asList("broken"), true);
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot deserialize object", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testGetVariablesLocalTyped() {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("variable1", "value1");
        vars.put("variable2", "value2");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariablesLocal(taskId, vars);
        VariableMap variablesTyped = this.taskService.getVariablesLocalTyped(taskId);
        Assert.assertEquals(vars, (Object)variablesTyped);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testGetVariablesLocalTypedDeserialize() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariablesLocal(taskId, (Map)Variables.createVariables().putValue("broken", (Object)Variables.serializedObjectValue((String)"broken").serializationDataFormat((SerializationDataFormat)Variables.SerializationDataFormats.JAVA).objectTypeName("unexisting").create()));
        VariableMap variablesTyped = this.taskService.getVariablesLocalTyped(taskId, false);
        Assert.assertNotNull((Object)variablesTyped.getValueTyped("broken"));
        variablesTyped = this.taskService.getVariablesLocalTyped(taskId, Arrays.asList("broken"), false);
        Assert.assertNotNull((Object)variablesTyped.getValueTyped("broken"));
        try {
            this.taskService.getVariablesLocalTyped(taskId);
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot deserialize object", e.getMessage());
        }
        try {
            this.taskService.getVariablesLocalTyped(taskId, Arrays.asList("broken"), true);
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Cannot deserialize object", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testHumanTaskCompleteWithVariables() {
        this.caseService.createCaseInstanceByKey("oneTaskCase");
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        String variableName = "aVariable";
        String variableValue = "aValue";
        this.taskService.complete(taskId, (Map)Variables.createVariables().putValue(variableName, (Object)variableValue));
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertEquals((Object)variable.getName(), (Object)variableName);
        Assert.assertEquals((Object)variable.getValue(), (Object)variableValue);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testHumanTaskWithLocalVariablesCompleteWithVariable() {
        this.caseService.createCaseInstanceByKey("oneTaskCase");
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String variableName = "aVariable";
        String variableValue = "aValue";
        String variableAnotherValue = "anotherValue";
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariableLocal(taskId, variableName, (Object)variableValue);
        this.taskService.complete(taskId, (Map)Variables.createVariables().putValue(variableName, (Object)variableAnotherValue));
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertEquals((Object)variable.getName(), (Object)variableName);
        Assert.assertEquals((Object)variable.getValue(), (Object)variableAnotherValue);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/twoTasksProcess.bpmn20.xml"})
    @Test
    public void testUserTaskWithLocalVariablesCompleteWithVariable() {
        this.runtimeService.startProcessInstanceByKey("twoTasksProcess");
        String variableName = "aVariable";
        String variableValue = "aValue";
        String variableAnotherValue = "anotherValue";
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariableLocal(taskId, variableName, (Object)variableValue);
        this.taskService.complete(taskId, (Map)Variables.createVariables().putValue(variableName, (Object)variableAnotherValue));
        VariableInstance variable = (VariableInstance)this.runtimeService.createVariableInstanceQuery().singleResult();
        Assert.assertEquals((Object)variable.getName(), (Object)variableName);
        Assert.assertEquals((Object)variable.getValue(), (Object)variableAnotherValue);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testHumanTaskLocalVariables() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        String humanTaskId = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String variableName = "aVariable";
        String variableValue = "aValue";
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setVariableLocal(taskId, variableName, (Object)variableValue);
        VariableInstance variableInstance = (VariableInstance)this.runtimeService.createVariableInstanceQuery().taskIdIn(new String[]{taskId}).singleResult();
        Assert.assertNotNull((Object)variableInstance);
        Assert.assertEquals((Object)caseInstanceId, (Object)variableInstance.getCaseInstanceId());
        Assert.assertEquals((Object)humanTaskId, (Object)variableInstance.getCaseExecutionId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariablesByEmptyList() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult()).getId();
        Map variables = this.taskService.getVariables(taskId, new ArrayList());
        Assert.assertNotNull((Object)variables);
        Assert.assertTrue((boolean)variables.isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariablesTypedByEmptyList() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult()).getId();
        VariableMap variables = this.taskService.getVariablesTyped(taskId, new ArrayList(), false);
        Assert.assertNotNull((Object)variables);
        Assert.assertTrue((boolean)variables.isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariablesLocalByEmptyList() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult()).getId();
        Map variables = this.taskService.getVariablesLocal(taskId, new ArrayList());
        Assert.assertNotNull((Object)variables);
        Assert.assertTrue((boolean)variables.isEmpty());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testGetVariablesLocalTypedByEmptyList() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("oneTaskProcess").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult()).getId();
        VariableMap variables = this.taskService.getVariablesLocalTyped(taskId, new ArrayList(), false);
        Assert.assertNotNull((Object)variables);
        Assert.assertTrue((boolean)variables.isEmpty());
    }
}

