/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.variables;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.variables.DeleteAndInsertVariableDelegate;
import org.camunda.bpm.engine.test.api.variables.InsertDeleteInsertVariableDelegate;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ModifyVariableInSameTransactionTest {
    @Rule
    public ProcessEngineRule engineRule = new ProcessEngineRule();
    @Rule
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);

    @Test
    @RequiredHistoryLevel(value="audit")
    public void testDeleteAndInsertTheSameVariableByteArray() {
        BpmnModelInstance bpmnModel = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"serviceTaskProcess").startEvent().userTask("userTask").serviceTask("service").camundaClass(DeleteAndInsertVariableDelegate.class)).userTask("userTask1").endEvent().done();
        ProcessDefinition processDefinition = this.testHelper.deployAndGetDefinition(bpmnModel);
        VariableMap variables = Variables.createVariables().putValue("listVar", Arrays.asList(new int[][]{{1, 2, 3}}));
        ProcessInstance instance = this.engineRule.getRuntimeService().startProcessInstanceById(processDefinition.getId(), (Map)variables);
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        this.engineRule.getTaskService().complete(task.getId());
        VariableInstance variable = (VariableInstance)this.engineRule.getRuntimeService().createVariableInstanceQuery().processInstanceIdIn(new String[]{instance.getId()}).variableName("listVar").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"stringValue", (Object)variable.getValue());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.engineRule.getHistoryService().createHistoricVariableInstanceQuery().singleResult();
        Assert.assertEquals((Object)variable.getName(), (Object)historicVariable.getName());
        Assert.assertEquals((Object)"CREATED", (Object)historicVariable.getState());
    }

    @Test
    @RequiredHistoryLevel(value="audit")
    public void testDeleteAndInsertTheSameVariable() {
        BpmnModelInstance bpmnModel = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"serviceTaskProcess").startEvent().userTask("userTask").serviceTask("service").camundaClass(DeleteAndInsertVariableDelegate.class)).userTask("userTask1").endEvent().done();
        ProcessDefinition processDefinition = this.testHelper.deployAndGetDefinition(bpmnModel);
        VariableMap variables = Variables.createVariables().putValue("foo", (Object)"firstValue");
        ProcessInstance instance = this.engineRule.getRuntimeService().startProcessInstanceById(processDefinition.getId(), (Map)variables);
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        this.engineRule.getTaskService().complete(task.getId());
        VariableInstance variable = (VariableInstance)this.engineRule.getRuntimeService().createVariableInstanceQuery().processInstanceIdIn(new String[]{instance.getId()}).variableName("foo").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"secondValue", (Object)variable.getValue());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.engineRule.getHistoryService().createHistoricVariableInstanceQuery().singleResult();
        Assert.assertEquals((Object)variable.getName(), (Object)historicVariable.getName());
        Assert.assertEquals((Object)"CREATED", (Object)historicVariable.getState());
    }

    @Test
    @RequiredHistoryLevel(value="audit")
    public void testInsertDeleteInsertTheSameVariable() {
        BpmnModelInstance bpmnModel = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"serviceTaskProcess").startEvent().userTask("userTask").serviceTask("service").camundaClass(InsertDeleteInsertVariableDelegate.class)).userTask("userTask1").endEvent().done();
        ProcessDefinition processDefinition = this.testHelper.deployAndGetDefinition(bpmnModel);
        VariableMap variables = Variables.createVariables().putValue("listVar", Arrays.asList(new int[][]{{1, 2, 3}}));
        ProcessInstance instance = this.engineRule.getRuntimeService().startProcessInstanceById(processDefinition.getId(), (Map)variables);
        Task task = (Task)this.engineRule.getTaskService().createTaskQuery().singleResult();
        this.engineRule.getTaskService().complete(task.getId());
        VariableInstance variable = (VariableInstance)this.engineRule.getRuntimeService().createVariableInstanceQuery().processInstanceIdIn(new String[]{instance.getId()}).variableName("foo").singleResult();
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"bar", (Object)variable.getValue());
        List historyVariables = this.engineRule.getHistoryService().createHistoricVariableInstanceQuery().list();
        for (HistoricVariableInstance historicVariable : historyVariables) {
            if (!variable.getName().equals(historicVariable.getName())) continue;
            Assert.assertEquals((Object)"CREATED", (Object)historicVariable.getState());
            break;
        }
    }
}

