/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.async;

import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.mail.EmailServiceTaskTest;
import org.camunda.bpm.engine.test.bpmn.mail.EmailTestCase;
import org.subethamail.wiser.WiserMessage;

public class AsyncEmailTaskTest
extends EmailTestCase {
    @Deployment
    public void testSimpleTextMail() throws Exception {
        String procId = this.runtimeService.startProcessInstanceByKey("simpleTextOnly").getId();
        List messages = this.wiser.getMessages();
        AsyncEmailTaskTest.assertEquals((int)0, (int)messages.size());
        this.waitForJobExecutorToProcessAllJobs(5000L);
        messages = this.wiser.getMessages();
        AsyncEmailTaskTest.assertEquals((int)1, (int)messages.size());
        WiserMessage message = (WiserMessage)messages.get(0);
        EmailServiceTaskTest.assertEmailSend(message, false, "Hello Kermit!", "This a text only e-mail.", "camunda@localhost", Arrays.asList("kermit@camunda.org"), null);
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testSimpleTextMailSendTask() throws Exception {
        this.runtimeService.startProcessInstanceByKey("simpleTextOnly");
        List messages = this.wiser.getMessages();
        AsyncEmailTaskTest.assertEquals((int)0, (int)messages.size());
        this.waitForJobExecutorToProcessAllJobs(5000L);
        messages = this.wiser.getMessages();
        AsyncEmailTaskTest.assertEquals((int)1, (int)messages.size());
        WiserMessage message = (WiserMessage)messages.get(0);
        EmailServiceTaskTest.assertEmailSend(message, false, "Hello Kermit!", "This a text only e-mail.", "camunda@localhost", Arrays.asList("kermit@camunda.org"), null);
    }
}

