/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.authorization;

import java.util.List;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.test.Deployment;

public class StartAuthorizationTest
extends PluggableProcessEngineTestCase {
    IdentityService identityService;
    User userInGroup1;
    User userInGroup2;
    User userInGroup3;
    Group group1;
    Group group2;
    Group group3;

    protected void setUpUsersAndGroups() throws Exception {
        this.identityService = this.processEngine.getIdentityService();
        this.identityService.saveUser(this.identityService.newUser("user1"));
        this.identityService.saveUser(this.identityService.newUser("user2"));
        this.identityService.saveUser(this.identityService.newUser("user3"));
        this.userInGroup1 = this.identityService.newUser("userInGroup1");
        this.identityService.saveUser(this.userInGroup1);
        this.userInGroup2 = this.identityService.newUser("userInGroup2");
        this.identityService.saveUser(this.userInGroup2);
        this.userInGroup3 = this.identityService.newUser("userInGroup3");
        this.identityService.saveUser(this.userInGroup3);
        this.group1 = this.identityService.newGroup("group1");
        this.identityService.saveGroup(this.group1);
        this.group2 = this.identityService.newGroup("group2");
        this.identityService.saveGroup(this.group2);
        this.group3 = this.identityService.newGroup("group3");
        this.identityService.saveGroup(this.group3);
        this.identityService.createMembership(this.userInGroup1.getId(), this.group1.getId());
        this.identityService.createMembership(this.userInGroup2.getId(), this.group2.getId());
        this.identityService.createMembership(this.userInGroup3.getId(), this.group3.getId());
    }

    protected void tearDownUsersAndGroups() throws Exception {
        this.identityService.deleteMembership(this.userInGroup1.getId(), this.group1.getId());
        this.identityService.deleteMembership(this.userInGroup2.getId(), this.group2.getId());
        this.identityService.deleteMembership(this.userInGroup3.getId(), this.group3.getId());
        this.identityService.deleteGroup(this.group1.getId());
        this.identityService.deleteGroup(this.group2.getId());
        this.identityService.deleteGroup(this.group3.getId());
        this.identityService.deleteUser(this.userInGroup1.getId());
        this.identityService.deleteUser(this.userInGroup2.getId());
        this.identityService.deleteUser(this.userInGroup3.getId());
        this.identityService.deleteUser("user1");
        this.identityService.deleteUser("user2");
        this.identityService.deleteUser("user3");
    }

    @Deployment
    public void testIdentityLinks() throws Exception {
        this.setUpUsersAndGroups();
        try {
            ProcessDefinition latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").singleResult();
            StartAuthorizationTest.assertNotNull((Object)latestProcessDef);
            List links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            StartAuthorizationTest.assertEquals((int)0, (int)links.size());
            latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").singleResult();
            StartAuthorizationTest.assertNotNull((Object)latestProcessDef);
            links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            StartAuthorizationTest.assertEquals((int)2, (int)links.size());
            StartAuthorizationTest.assertEquals((boolean)true, (boolean)this.containsUserOrGroup("user1", null, links));
            StartAuthorizationTest.assertEquals((boolean)true, (boolean)this.containsUserOrGroup("user2", null, links));
            latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process3").singleResult();
            StartAuthorizationTest.assertNotNull((Object)latestProcessDef);
            links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            StartAuthorizationTest.assertEquals((int)1, (int)links.size());
            StartAuthorizationTest.assertEquals((String)"user1", (String)((IdentityLink)links.get(0)).getUserId());
            latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process4").singleResult();
            StartAuthorizationTest.assertNotNull((Object)latestProcessDef);
            links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            StartAuthorizationTest.assertEquals((int)4, (int)links.size());
            StartAuthorizationTest.assertEquals((boolean)true, (boolean)this.containsUserOrGroup("userInGroup2", null, links));
            StartAuthorizationTest.assertEquals((boolean)true, (boolean)this.containsUserOrGroup(null, "group1", links));
            StartAuthorizationTest.assertEquals((boolean)true, (boolean)this.containsUserOrGroup(null, "group2", links));
            StartAuthorizationTest.assertEquals((boolean)true, (boolean)this.containsUserOrGroup(null, "group3", links));
        }
        finally {
            this.tearDownUsersAndGroups();
        }
    }

    @Deployment
    public void testAddAndRemoveIdentityLinks() throws Exception {
        this.setUpUsersAndGroups();
        try {
            ProcessDefinition latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("potentialStarterNoDefinition").singleResult();
            StartAuthorizationTest.assertNotNull((Object)latestProcessDef);
            List links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            StartAuthorizationTest.assertEquals((int)0, (int)links.size());
            this.repositoryService.addCandidateStarterGroup(latestProcessDef.getId(), "group1");
            links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            StartAuthorizationTest.assertEquals((int)1, (int)links.size());
            StartAuthorizationTest.assertEquals((String)"group1", (String)((IdentityLink)links.get(0)).getGroupId());
            this.repositoryService.addCandidateStarterUser(latestProcessDef.getId(), "user1");
            links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            StartAuthorizationTest.assertEquals((int)2, (int)links.size());
            StartAuthorizationTest.assertEquals((boolean)true, (boolean)this.containsUserOrGroup(null, "group1", links));
            StartAuthorizationTest.assertEquals((boolean)true, (boolean)this.containsUserOrGroup("user1", null, links));
            this.repositoryService.deleteCandidateStarterGroup(latestProcessDef.getId(), "nonexisting");
            links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            StartAuthorizationTest.assertEquals((int)2, (int)links.size());
            this.repositoryService.deleteCandidateStarterGroup(latestProcessDef.getId(), "group1");
            links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            StartAuthorizationTest.assertEquals((int)1, (int)links.size());
            StartAuthorizationTest.assertEquals((String)"user1", (String)((IdentityLink)links.get(0)).getUserId());
            this.repositoryService.deleteCandidateStarterUser(latestProcessDef.getId(), "user1");
            links = this.repositoryService.getIdentityLinksForProcessDefinition(latestProcessDef.getId());
            StartAuthorizationTest.assertEquals((int)0, (int)links.size());
        }
        finally {
            this.tearDownUsersAndGroups();
        }
    }

    private boolean containsUserOrGroup(String userId, String groupId, List<IdentityLink> links) {
        boolean found = false;
        for (IdentityLink identityLink : links) {
            if (userId != null && userId.equals(identityLink.getUserId())) {
                found = true;
                break;
            }
            if (groupId == null || !groupId.equals(identityLink.getGroupId())) continue;
            found = true;
            break;
        }
        return found;
    }

    @Deployment
    public void testPotentialStarter() throws Exception {
        this.setUpUsersAndGroups();
        try {
            this.identityService.setAuthenticatedUserId("unauthorizedUser");
            try {
                this.runtimeService.startProcessInstanceByKey("potentialStarter");
            }
            catch (Exception e) {
                StartAuthorizationTest.fail((String)("No StartAuthorizationException expected, " + e.getClass().getName() + " caught."));
            }
            this.identityService.setAuthenticatedUserId("user1");
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("potentialStarter");
            this.assertProcessEnded(processInstance.getId());
            StartAuthorizationTest.assertTrue((boolean)processInstance.isEnded());
        }
        finally {
            this.tearDownUsersAndGroups();
        }
    }

    @Deployment
    public void testPotentialStarterNoDefinition() throws Exception {
        this.identityService = this.processEngine.getIdentityService();
        this.identityService.setAuthenticatedUserId("someOneFromMars");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("potentialStarterNoDefinition");
        StartAuthorizationTest.assertNotNull((Object)processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
        StartAuthorizationTest.assertTrue((boolean)processInstance.isEnded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment
    public void testProcessDefinitionList() throws Exception {
        this.setUpUsersAndGroups();
        try {
            ProcessDefinition latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process1").singleResult();
            List authorizedUsers = this.identityService.createUserQuery().potentialStarter(latestProcessDef.getId()).list();
            StartAuthorizationTest.assertEquals((int)0, (int)authorizedUsers.size());
            latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").singleResult();
            authorizedUsers = ((UserQuery)this.identityService.createUserQuery().potentialStarter(latestProcessDef.getId()).orderByUserId().asc()).list();
            StartAuthorizationTest.assertEquals((int)2, (int)authorizedUsers.size());
            StartAuthorizationTest.assertEquals((String)"user1", (String)((User)authorizedUsers.get(0)).getId());
            StartAuthorizationTest.assertEquals((String)"user2", (String)((User)authorizedUsers.get(1)).getId());
            latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process2").singleResult();
            List authorizedGroups = this.identityService.createGroupQuery().potentialStarter(latestProcessDef.getId()).list();
            StartAuthorizationTest.assertEquals((int)0, (int)authorizedGroups.size());
            latestProcessDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("process4").singleResult();
            authorizedGroups = ((GroupQuery)this.identityService.createGroupQuery().potentialStarter(latestProcessDef.getId()).orderByGroupId().asc()).list();
            StartAuthorizationTest.assertEquals((int)3, (int)authorizedGroups.size());
            StartAuthorizationTest.assertEquals((String)"group1", (String)((Group)authorizedGroups.get(0)).getId());
            StartAuthorizationTest.assertEquals((String)"group2", (String)((Group)authorizedGroups.get(1)).getId());
            StartAuthorizationTest.assertEquals((String)"group3", (String)((Group)authorizedGroups.get(2)).getId());
            List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionName().asc()).list();
            StartAuthorizationTest.assertEquals((int)4, (int)processDefinitions.size());
            StartAuthorizationTest.assertEquals((String)"process1", (String)((ProcessDefinition)processDefinitions.get(0)).getKey());
            StartAuthorizationTest.assertEquals((String)"process2", (String)((ProcessDefinition)processDefinitions.get(1)).getKey());
            StartAuthorizationTest.assertEquals((String)"process3", (String)((ProcessDefinition)processDefinitions.get(2)).getKey());
            StartAuthorizationTest.assertEquals((String)"process4", (String)((ProcessDefinition)processDefinitions.get(3)).getKey());
            processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionName().asc()).startableByUser("user1").list();
            StartAuthorizationTest.assertEquals((int)2, (int)processDefinitions.size());
            StartAuthorizationTest.assertEquals((String)"process2", (String)((ProcessDefinition)processDefinitions.get(0)).getKey());
            StartAuthorizationTest.assertEquals((String)"process3", (String)((ProcessDefinition)processDefinitions.get(1)).getKey());
            processDefinitions = this.repositoryService.createProcessDefinitionQuery().startableByUser("user2").list();
            StartAuthorizationTest.assertEquals((int)1, (int)processDefinitions.size());
            StartAuthorizationTest.assertEquals((String)"process2", (String)((ProcessDefinition)processDefinitions.get(0)).getKey());
            processDefinitions = this.repositoryService.createProcessDefinitionQuery().startableByUser("user4").list();
            StartAuthorizationTest.assertEquals((int)0, (int)processDefinitions.size());
            processDefinitions = this.repositoryService.createProcessDefinitionQuery().startableByUser("userInGroup3").list();
            StartAuthorizationTest.assertEquals((int)1, (int)processDefinitions.size());
            StartAuthorizationTest.assertEquals((String)"process4", (String)((ProcessDefinition)processDefinitions.get(0)).getKey());
            processDefinitions = this.repositoryService.createProcessDefinitionQuery().startableByUser("userInGroup2").list();
            StartAuthorizationTest.assertEquals((int)1, (int)processDefinitions.size());
            StartAuthorizationTest.assertEquals((String)"process4", (String)((ProcessDefinition)processDefinitions.get(0)).getKey());
        }
        finally {
            this.tearDownUsersAndGroups();
        }
    }
}

