/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.escalation;

import java.util.HashMap;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class EscalationEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testThrowEscalationEventFromEmbeddedSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    public void testThrowEscalationEventHierarchical() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation inside subprocess").count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.nonInterruptingEscalationBoundaryEventOnCallActivity.bpmn20.xml"})
    public void testThrowEscalationEventFromCallActivity() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        EscalationEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after thrown escalation").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml"})
    public void testThrowEscalationEventNotCaught() {
        this.runtimeService.startProcessInstanceByKey("throwEscalationProcess");
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after thrown escalation").count());
    }

    @Deployment
    public void testBoundaryEventWithEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation 1").count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    public void testBoundaryEventWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    public void testBoundaryEventWithEmptyEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    public void testBoundaryEventWithoutEscalationRef() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    public void testInterruptingEscalationBoundaryEventOnMultiInstanceSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
    }

    @Deployment
    public void testNonInterruptingEscalationBoundaryEventOnMultiInstanceSubprocess() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventTest.assertEquals((long)10L, (long)this.taskService.createTaskQuery().count());
        EscalationEventTest.assertEquals((long)5L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventTest.assertEquals((long)5L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    public void FAILING_testImplicitNonInterruptingEscalationBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    public void testInterruptingEscalationBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.interruptingEscalationBoundaryEventOnCallActivity.bpmn20.xml"})
    public void testInterruptingEscalationBoundaryEventOnCallActivity() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
    }

    @Deployment
    public void testParallelEscalationEndEvent() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task in subprocess").count());
    }

    @Deployment
    public void testEscalationEndEvent() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testPropagateOutputVariablesWhileCatchEscalationOnCallActivity.bpmn20.xml"})
    public void testPropagateOutputVariablesWhileCatchEscalationOnCallActivity() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("catchEscalationProcess", variables).getId();
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventTest.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testPropagateOutputVariablesWhileCatchEscalationOnCallActivity.bpmn20.xml"})
    public void testPropagateOutputVariablesTwoTimes() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("catchEscalationProcess", variables).getId();
        Task taskInSuperProcess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        EscalationEventTest.assertNotNull((Object)taskInSuperProcess);
        EscalationEventTest.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
        Task taskInSubProcess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.runtimeService.setVariable(taskInSubProcess.getProcessInstanceId(), "input", (Object)999);
        this.taskService.complete(taskInSubProcess.getId());
        EscalationEventTest.assertEquals((Object)999, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testPropagateOutputVariablesWhileCatchInterruptingEscalationOnCallActivity.bpmn20.xml"})
    public void testPropagateOutputVariablesWhileCatchInterruptingEscalationOnCallActivity() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("catchEscalationProcess", variables).getId();
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventTest.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testPropagateOutputVariablesWithoutCatchEscalation.bpmn20.xml"})
    public void testPropagateOutputVariablesWithoutCatchEscalation() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("catchEscalationProcess", variables).getId();
        EscalationEventTest.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
    }

    @Deployment
    public void testRetrieveEscalationCodeVariableOnBoundaryEvent() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskName("task after catched escalation").singleResult();
        EscalationEventTest.assertNotNull((Object)task);
        EscalationEventTest.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment
    public void testRetrieveEscalationCodeVariableOnBoundaryEventWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("escalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskName("task after catched escalation").singleResult();
        EscalationEventTest.assertNotNull((Object)task);
        EscalationEventTest.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testInterruptingRetrieveEscalationCodeInSuperProcess.bpmn20.xml"})
    public void testInterruptingRetrieveEscalationCodeInSuperProcess() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        EscalationEventTest.assertNotNull((Object)task);
        EscalationEventTest.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testInterruptingRetrieveEscalationCodeInSuperProcessWithoutEscalationCode.bpmn20.xml"})
    public void testInterruptingRetrieveEscalationCodeInSuperProcessWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        EscalationEventTest.assertNotNull((Object)task);
        EscalationEventTest.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testNonInterruptingRetrieveEscalationCodeInSuperProcess.bpmn20.xml"})
    public void testNonInterruptingRetrieveEscalationCodeInSuperProcess() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        EscalationEventTest.assertNotNull((Object)task);
        EscalationEventTest.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.throwEscalationEvent.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testNonInterruptingRetrieveEscalationCodeInSuperProcessWithoutEscalationCode.bpmn20.xml"})
    public void testNonInterruptingRetrieveEscalationCodeInSuperProcessWithoutEscalationCode() {
        this.runtimeService.startProcessInstanceByKey("catchEscalationProcess");
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskAfterCatchedEscalation").singleResult();
        EscalationEventTest.assertNotNull((Object)task);
        EscalationEventTest.assertEquals((Object)"escalationCode", (Object)this.runtimeService.getVariable(task.getExecutionId(), "escalationCodeVar"));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/testOutputVariablesWhileThrowEscalation.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.escalationParent.bpmn20.xml"})
    public void testPropagateOutputVariablesWhileThrowEscalation() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("EscalationParentProcess", variables).getId();
        String id = ((Task)this.taskService.createTaskQuery().taskName("ut2").singleResult()).getId();
        this.taskService.complete(id);
        this.checkOutput(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/testOutputVariablesWhileThrowEscalationTwoLevels.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.escalationParent.bpmn20.xml"})
    public void testPropagateOutputVariablesWhileThrowEscalationTwoLevels() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("EscalationParentProcess", variables).getId();
        String id = ((Task)this.taskService.createTaskQuery().taskName("ut2").singleResult()).getId();
        this.taskService.complete(id);
        this.checkOutput(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/testOutputVariablesWhileThrowEscalationThreeLevels.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.escalationParent.bpmn20.xml"})
    public void testPropagateOutputVariablesWhileThrowEscalationThreeLevels() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("EscalationParentProcess", variables).getId();
        String id = ((Task)this.taskService.createTaskQuery().taskName("ut2").singleResult()).getId();
        this.taskService.complete(id);
        this.checkOutput(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/testOutputVariablesWhileThrowEscalationInSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.escalationParent.bpmn20.xml"})
    public void testPropagateOutputVariablesWhileThrowEscalationInSubProcess() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("EscalationParentProcess", variables).getId();
        String id = ((Task)this.taskService.createTaskQuery().taskName("ut2").singleResult()).getId();
        this.taskService.complete(id);
        this.checkOutput(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/testOutputVariablesWhileThrowEscalationInSubProcessThreeLevels.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.escalationParent.bpmn20.xml"})
    public void testPropagateOutputVariablesWhileThrowEscalationInSubProcessThreeLevels() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("EscalationParentProcess", variables).getId();
        String id = ((Task)this.taskService.createTaskQuery().taskName("ut2").singleResult()).getId();
        this.taskService.complete(id);
        this.checkOutput(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/testOutputVariablesWhileThrowEscalation2.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.escalationParent.bpmn20.xml"})
    public void testPropagateOutputVariablesWhileThrowEscalation2() {
        HashMap<String, Integer> variables = new HashMap<String, Integer>();
        variables.put("input", 42);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("EscalationParentProcess", variables).getId();
        String id = ((Task)this.taskService.createTaskQuery().taskName("inside subprocess").singleResult()).getId();
        this.taskService.complete(id);
        this.checkOutput(processInstanceId);
    }

    protected void checkOutput(String processInstanceId) {
        EscalationEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("task after catched escalation").count());
        EscalationEventTest.assertNotNull((Object)this.runtimeService.getVariable(processInstanceId, "cancelReason"));
        EscalationEventTest.assertEquals((Object)42, (Object)this.runtimeService.getVariable(processInstanceId, "output"));
    }
}

