/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.signal;

import java.util.Arrays;
import java.util.Collection;
import junit.framework.AssertionFailedError;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SignalEventParseInvalidProcessTest {
    private static final String PROCESS_DEFINITION_DIRECTORY = "org/camunda/bpm/engine/test/bpmn/event/signal/";
    @Parameterized.Parameter(value=0)
    public String processDefinitionResource;
    @Parameterized.Parameter(value=1)
    public String expectedErrorMessage;
    @Rule
    public ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected RepositoryService repositoryService;

    @Parameterized.Parameters(name="{index}: process definition = {0}, expected error message = {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"InvalidProcessWithDuplicateSignalNames.bpmn20.xml", "duplicate signal name"}, {"InvalidProcessWithNoSignalName.bpmn20.xml", "signal with id 'alertSignal' has no name"}, {"InvalidProcessWithSignalNoId.bpmn20.xml", "signal must have an id"}, {"InvalidProcessWithSignalNoRef.bpmn20.xml", "signalEventDefinition does not have required property 'signalRef'"}, {"InvalidProcessWithMultipleSignalStartEvents.bpmn20.xml", "Cannot have more than one signal event subscription with name 'signal'"}, {"InvalidProcessWithMultipleInterruptingSignalEventSubProcesses.bpmn20.xml", "Cannot have more than one signal event subscription with name 'alert'"});
    }

    @Before
    public void initServices() {
        this.repositoryService = this.rule.getRepositoryService();
    }

    @Test
    public void testParseInvalidProcessDefinition() {
        try {
            this.repositoryService.createDeployment().addClasspathResource(PROCESS_DEFINITION_DIRECTORY + this.processDefinitionResource).deploy();
            Assert.fail((String)("exception expected: " + this.expectedErrorMessage));
        }
        catch (Exception e) {
            this.assertTextPresent(this.expectedErrorMessage, e.getMessage());
        }
    }

    public void assertTextPresent(String expected, String actual) {
        if (actual == null || !actual.contains(expected)) {
            throw new AssertionFailedError("expected presence of [" + expected + "], but was [" + actual + "]");
        }
    }
}

