/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.signal;

import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class SignalEventReceivedBuilderTest
extends PluggableProcessEngineTestCase {
    protected BpmnModelInstance signalStartProcess(String processId) {
        return ((StartEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().signal("signal")).userTask().endEvent().done();
    }

    protected BpmnModelInstance signalCatchProcess(String processId) {
        return ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().intermediateCatchEvent().signal("signal")).userTask().endEvent().done();
    }

    public void testSendSignalToStartEvent() {
        this.deployment(new BpmnModelInstance[]{this.signalStartProcess("signalStart")});
        this.runtimeService.createSignalEvent("signal").send();
        Assert.assertThat((Object)this.taskService.createTaskQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSendSignalToIntermediateCatchEvent() {
        this.deployment(new BpmnModelInstance[]{this.signalCatchProcess("signalCatch")});
        this.runtimeService.startProcessInstanceByKey("signalCatch");
        this.runtimeService.createSignalEvent("signal").send();
        Assert.assertThat((Object)this.taskService.createTaskQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSendSignalToStartAndIntermediateCatchEvent() {
        this.deployment(new BpmnModelInstance[]{this.signalStartProcess("signalStart"), this.signalCatchProcess("signalCatch")});
        this.runtimeService.startProcessInstanceByKey("signalCatch");
        this.runtimeService.createSignalEvent("signal").send();
        Assert.assertThat((Object)this.taskService.createTaskQuery().count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testSendSignalToMultipleStartEvents() {
        this.deployment(new BpmnModelInstance[]{this.signalStartProcess("signalStart"), this.signalStartProcess("signalStart2")});
        this.runtimeService.createSignalEvent("signal").send();
        Assert.assertThat((Object)this.taskService.createTaskQuery().count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testSendSignalToMultipleIntermediateCatchEvents() {
        this.deployment(new BpmnModelInstance[]{this.signalCatchProcess("signalCatch"), this.signalCatchProcess("signalCatch2")});
        this.runtimeService.startProcessInstanceByKey("signalCatch");
        this.runtimeService.startProcessInstanceByKey("signalCatch2");
        this.runtimeService.createSignalEvent("signal").send();
        Assert.assertThat((Object)this.taskService.createTaskQuery().count(), (Matcher)CoreMatchers.is((Object)2L));
    }

    public void testSendSignalWithExecutionId() {
        this.deployment(new BpmnModelInstance[]{this.signalCatchProcess("signalCatch"), this.signalCatchProcess("signalCatch2")});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("signalCatch");
        this.runtimeService.startProcessInstanceByKey("signalCatch2");
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().processInstanceId(processInstance.getId()).singleResult();
        String executionId = eventSubscription.getExecutionId();
        this.runtimeService.createSignalEvent("signal").executionId(executionId).send();
        Assert.assertThat((Object)this.taskService.createTaskQuery().count(), (Matcher)CoreMatchers.is((Object)1L));
    }

    public void testSendSignalToStartEventWithVariables() {
        this.deployment(new BpmnModelInstance[]{this.signalStartProcess("signalStart")});
        VariableMap variables = Variables.createVariables().putValue("var1", (Object)"a").putValue("var2", (Object)"b");
        this.runtimeService.createSignalEvent("signal").setVariables((Map)variables).send();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        Assert.assertThat((Object)this.runtimeService.getVariables(execution.getId()), (Matcher)CoreMatchers.is((Object)variables));
    }

    public void testSendSignalToIntermediateCatchEventWithVariables() {
        this.deployment(new BpmnModelInstance[]{this.signalCatchProcess("signalCatch")});
        this.runtimeService.startProcessInstanceByKey("signalCatch");
        VariableMap variables = Variables.createVariables().putValue("var1", (Object)"a").putValue("var2", (Object)"b");
        this.runtimeService.createSignalEvent("signal").setVariables((Map)variables).send();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        Assert.assertThat((Object)this.runtimeService.getVariables(execution.getId()), (Matcher)CoreMatchers.is((Object)variables));
    }

    public void testNoSignalEventSubscription() {
        this.runtimeService.createSignalEvent("signal").send();
    }

    public void testNonExistingExecutionId() {
        try {
            this.runtimeService.createSignalEvent("signal").executionId("nonExisting").send();
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Cannot find execution with id 'nonExisting'"));
        }
    }

    public void testNoSignalEventSubscriptionWithExecutionId() {
        this.deployment(new BpmnModelInstance[]{Bpmn.createExecutableProcess((String)"noSignal").startEvent().userTask().endEvent().done()});
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("noSignal");
        String executionId = processInstance.getId();
        try {
            this.runtimeService.createSignalEvent("signal").executionId(executionId).send();
        }
        catch (ProcessEngineException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)("Execution '" + executionId + "' has not subscribed to a signal event with name 'signal'")));
        }
    }
}

