/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.timer;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.TimerEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;

public class BoundaryTimerNonInterruptingEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testMultipleTimersOnUserTask() {
        Date startTime = new Date();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingTimersOnUserTask");
        Task task1 = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"First Task", (String)task1.getName());
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        BoundaryTimerNonInterruptingEventTest.assertEquals((int)2, (int)jobs.size());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 3605000L));
        this.waitForJobExecutorToProcessAllJobs(5000L);
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)1L, (long)jobQuery.count());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().desc()).list();
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"First Task", (String)((Task)taskList.get(0)).getName());
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"Escalation Task 1", (String)((Task)taskList.get(1)).getName());
        this.taskService.complete(((Task)taskList.get(1)).getId());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"First Task", (String)((Task)this.taskService.createTaskQuery().singleResult()).getName());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 7205000L));
        this.waitForJobExecutorToProcessAllJobs(5000L);
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)0L, (long)jobQuery.count());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        taskList = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().desc()).list();
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"First Task", (String)((Task)taskList.get(0)).getName());
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"Escalation Task 2", (String)((Task)taskList.get(1)).getName());
        this.taskService.complete(((Task)taskList.get(0)).getId());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task escalationTask = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"Escalation Task 2", (String)escalationTask.getName());
        this.taskService.complete(escalationTask.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testTimerOnMiUserTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingTimersOnUserTask");
        List taskList = this.taskService.createTaskQuery().list();
        BoundaryTimerNonInterruptingEventTest.assertEquals((int)5, (int)taskList.size());
        for (Task task : taskList) {
            BoundaryTimerNonInterruptingEventTest.assertEquals((String)"First Task", (String)task.getName());
        }
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(pi.getId()).singleResult();
        BoundaryTimerNonInterruptingEventTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        taskList = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        BoundaryTimerNonInterruptingEventTest.assertEquals((int)6, (int)taskList.size());
        Task escalationTask = (Task)taskList.remove(0);
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"Escalation Task 1", (String)escalationTask.getName());
        this.taskService.complete(escalationTask.getId());
        for (Task task : taskList) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testJoin() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testJoin");
        Task task1 = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"Main Task", (String)task1.getName());
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(pi.getId()).singleResult();
        BoundaryTimerNonInterruptingEventTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        this.taskService.complete(task1.getId());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task task2 = (Task)this.taskService.createTaskQuery().singleResult();
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"Escalation Task", (String)task2.getName());
        this.taskService.complete(task2.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testTimerOnConcurrentMiTasks() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("timerOnConcurrentMiTasks");
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().desc()).list();
        BoundaryTimerNonInterruptingEventTest.assertEquals((int)6, (int)taskList.size());
        Task secondTask = (Task)taskList.remove(0);
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"Second Task", (String)secondTask.getName());
        for (Task task : taskList) {
            BoundaryTimerNonInterruptingEventTest.assertEquals((String)"First Task", (String)task.getName());
        }
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(pi.getId()).singleResult();
        BoundaryTimerNonInterruptingEventTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        taskList = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc()).list();
        BoundaryTimerNonInterruptingEventTest.assertEquals((int)7, (int)taskList.size());
        Task escalationTask = (Task)taskList.remove(0);
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"Escalation Task 1", (String)escalationTask.getName());
        this.taskService.complete(escalationTask.getId());
        for (Task task : taskList) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testTimerOnConcurrentTasks() {
        String procId = this.runtimeService.startProcessInstanceByKey("nonInterruptingOnConcurrentTasks").getId();
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)3L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask").singleResult();
        this.taskService.complete(task.getId());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        for (Task t : this.taskService.createTaskQuery().list()) {
            this.taskService.complete(t.getId());
        }
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/BoundaryTimerNonInterruptingEventTest.testTimerOnConcurrentTasks.bpmn20.xml"})
    public void testTimerOnConcurrentTasks2() {
        String procId = this.runtimeService.startProcessInstanceByKey("nonInterruptingOnConcurrentTasks").getId();
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)3L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("firstTask").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("secondTask").singleResult();
        this.taskService.complete(task.getId());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment
    public void testTimerWithCycle() throws Exception {
        this.runtimeService.startProcessInstanceByKey("nonInterruptingCycle").getId();
        TaskQuery tq = this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask");
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)0L, (long)tq.count());
        this.moveByHours(1);
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)1L, (long)tq.count());
        this.moveByHours(1);
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)2L, (long)tq.count());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        this.moveByHours(1);
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)2L, (long)tq.count());
    }

    @Deployment
    public void testTimerOnEmbeddedSubprocess() {
        String id = this.runtimeService.startProcessInstanceByKey("nonInterruptingTimerOnEmbeddedSubprocess").getId();
        TaskQuery tq = this.taskService.createTaskQuery().taskAssignee("kermit");
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)1L, (long)tq.count());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        tq = this.taskService.createTaskQuery().taskAssignee("kermit");
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)2L, (long)tq.count());
        List tasks = tq.list();
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.assertProcessEnded(id);
    }

    @Deployment
    public void testReceiveTaskWithBoundaryTimer() {
        Date startTime = new Date();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("timeCycle", "R/PT1H");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingCycle", variables);
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        List jobs = jobQuery.list();
        BoundaryTimerNonInterruptingEventTest.assertEquals((int)1, (int)jobs.size());
        List executions = this.runtimeService.createExecutionQuery().activityId("task").list();
        BoundaryTimerNonInterruptingEventTest.assertEquals((int)1, (int)executions.size());
        List activeActivityIds = this.runtimeService.getActiveActivityIds(((Execution)executions.get(0)).getId());
        BoundaryTimerNonInterruptingEventTest.assertEquals((int)1, (int)activeActivityIds.size());
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"task", (String)((String)activeActivityIds.get(0)));
        this.runtimeService.signal(((Execution)executions.get(0)).getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testTimerOnConcurrentSubprocess() {
        String procId = this.runtimeService.startProcessInstanceByKey("testTimerOnConcurrentSubprocess").getId();
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)4L, (long)this.taskService.createTaskQuery().count());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)5L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("sub1task1").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("sub1task2").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("sub2task1").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("sub2task2").singleResult();
        this.taskService.complete(task.getId());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask").singleResult();
        this.taskService.complete(task.getId());
        this.assertProcessEnded(procId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/BoundaryTimerNonInterruptingEventTest.testTimerOnConcurrentSubprocess.bpmn20.xml"})
    public void testTimerOnConcurrentSubprocess2() {
        String procId = this.runtimeService.startProcessInstanceByKey("testTimerOnConcurrentSubprocess").getId();
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)4L, (long)this.taskService.createTaskQuery().count());
        Job timer = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(timer.getId());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)5L, (long)this.taskService.createTaskQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("sub1task1").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("sub1task2").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("sub2task1").singleResult();
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("sub2task2").singleResult();
        this.taskService.complete(task.getId());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        this.assertProcessEnded(procId);
    }

    private void moveByHours(int hours) throws Exception {
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + (long)(hours * 60 * 1000 * 60 + 5000)));
        JobExecutor jobExecutor = this.processEngineConfiguration.getJobExecutor();
        jobExecutor.start();
        Thread.sleep(1000L);
        jobExecutor.shutdown();
    }

    @Deployment
    public void testMultipleOutgoingSequenceFlows() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingTimer");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        BoundaryTimerNonInterruptingEventTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)3L, (long)taskQuery.count());
        List tasks = taskQuery.list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testMultipleOutgoingSequenceFlowsOnSubprocess() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingTimer");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        BoundaryTimerNonInterruptingEventTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask1").singleResult();
        BoundaryTimerNonInterruptingEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask2").singleResult();
        BoundaryTimerNonInterruptingEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask1").singleResult();
        BoundaryTimerNonInterruptingEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask2").singleResult();
        BoundaryTimerNonInterruptingEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
        pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingTimer");
        job = (Job)this.managementService.createJobQuery().singleResult();
        BoundaryTimerNonInterruptingEventTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask1").singleResult();
        BoundaryTimerNonInterruptingEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("timerFiredTask2").singleResult();
        BoundaryTimerNonInterruptingEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask1").singleResult();
        BoundaryTimerNonInterruptingEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("innerTask2").singleResult();
        BoundaryTimerNonInterruptingEventTest.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testMultipleOutgoingSequenceFlowsOnSubprocessMi() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("nonInterruptingTimer");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        BoundaryTimerNonInterruptingEventTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)10L, (long)taskQuery.count());
        List tasks = taskQuery.list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(pi.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/BoundaryTimerNonInterruptingEventTest.testTimerWithCycle.bpmn20.xml"})
    public void testTimeCycle() throws Exception {
        this.runtimeService.startProcessInstanceByKey("nonInterruptingCycle");
        JobQuery jobQuery = this.managementService.createJobQuery();
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)1L, (long)jobQuery.count());
        String jobId = ((Job)jobQuery.singleResult()).getId();
        this.managementService.executeJob(jobId);
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)1L, (long)jobQuery.count());
        String anotherJobId = ((Job)jobQuery.singleResult()).getId();
        BoundaryTimerNonInterruptingEventTest.assertFalse((boolean)jobId.equals(anotherJobId));
    }

    @Deployment
    public void testFailingTimeCycle() {
        this.runtimeService.startProcessInstanceByKey("process");
        JobQuery failedJobQuery = this.managementService.createJobQuery();
        JobQuery jobQuery = this.managementService.createJobQuery();
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)1L, (long)jobQuery.count());
        String jobId = ((Job)jobQuery.singleResult()).getId();
        failedJobQuery.jobId(jobId);
        try {
            this.managementService.executeJob(jobId);
            BoundaryTimerNonInterruptingEventTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Job failedJob = (Job)failedJobQuery.singleResult();
        BoundaryTimerNonInterruptingEventTest.assertEquals((int)2, (int)failedJob.getRetries());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)2L, (long)jobQuery.count());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)2L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        failedJob = (Job)failedJobQuery.singleResult();
        BoundaryTimerNonInterruptingEventTest.assertEquals((int)1, (int)failedJob.getRetries());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)2L, (long)jobQuery.count());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().withException().count());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().noRetriesLeft().count());
        BoundaryTimerNonInterruptingEventTest.assertEquals((long)2L, (long)this.managementService.createJobQuery().withRetriesLeft().count());
    }

    @Deployment
    public void testUpdateTimerRepeat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        Calendar currentTime = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)currentTime.getTime());
        this.runtimeService.startProcessInstanceByKey("timerRepeat");
        List tasks = this.taskService.createTaskQuery().list();
        BoundaryTimerNonInterruptingEventTest.assertEquals((int)1, (int)tasks.size());
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"User Waiting", (String)((Task)tasks.get(0)).getName());
        TimerEntity timerJob = (TimerEntity)this.managementService.createJobQuery().singleResult();
        BoundaryTimerNonInterruptingEventTest.assertNotNull((Object)timerJob);
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)("R5/" + sdf.format(ClockUtil.getCurrentTime()) + "/PT1H"), (String)timerJob.getRepeat());
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                TimerEntity timerEntity = (TimerEntity)commandContext.getProcessEngineConfiguration().getManagementService().createJobQuery().singleResult();
                timerEntity.setRepeat("R3/PT3H");
                return null;
            }
        });
        TimerEntity updatedTimerJob = (TimerEntity)this.managementService.createJobQuery().singleResult();
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"R3/PT3H", (String)updatedTimerJob.getRepeat());
        currentTime.add(10, 1);
        ClockUtil.setCurrentTime((Date)currentTime.getTime());
        this.managementService.executeJob(timerJob.getId());
        tasks = ((TaskQuery)this.taskService.createTaskQuery().orderByTaskCreateTime().asc()).list();
        BoundaryTimerNonInterruptingEventTest.assertEquals((int)2, (int)tasks.size());
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"User Waiting", (String)((Task)tasks.get(0)).getName());
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"Timer Fired", (String)((Task)tasks.get(1)).getName());
        TimerEntity secondTimerJob = (TimerEntity)this.managementService.createJobQuery().singleResult();
        currentTime.add(10, 3);
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)"R3/PT3H", (String)secondTimerJob.getRepeat());
        BoundaryTimerNonInterruptingEventTest.assertEquals((String)sdf.format(currentTime.getTime()), (String)sdf.format(secondTimerJob.getDuedate()));
    }
}

