/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.timer;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.joda.time.LocalDateTime;
import org.junit.Assert;

public class IntermediateTimerEventTest
extends PluggableProcessEngineTestCase {
    @Deployment
    public void testCatchingTimerEvent() throws Exception {
        Date startTime = new Date();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("intermediateTimerEventExample");
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi.getId());
        IntermediateTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        ClockUtil.setCurrentTime((Date)new Date(startTime.getTime() + 3005000L));
        this.waitForJobExecutorToProcessAllJobs(5000L);
        IntermediateTimerEventTest.assertEquals((long)0L, (long)jobQuery.count());
        this.assertProcessEnded(pi.getProcessInstanceId());
    }

    @Deployment
    public void testExpression() {
        HashMap<String, Date> variables1 = new HashMap<String, Date>();
        variables1.put("dueDate", new Date());
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("dueDate", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date()));
        ProcessInstance pi1 = this.runtimeService.startProcessInstanceByKey("intermediateTimerEventExample", variables1);
        ProcessInstance pi2 = this.runtimeService.startProcessInstanceByKey("intermediateTimerEventExample", variables2);
        IntermediateTimerEventTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().processInstanceId(pi1.getId()).count());
        IntermediateTimerEventTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().processInstanceId(pi2.getId()).count());
        List jobs = this.managementService.createJobQuery().executable().list();
        IntermediateTimerEventTest.assertEquals((int)2, (int)jobs.size());
        for (Job job : jobs) {
            this.managementService.executeJob(job.getId());
        }
        IntermediateTimerEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().processInstanceId(pi1.getId()).count());
        IntermediateTimerEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().processInstanceId(pi2.getId()).count());
        this.assertProcessEnded(pi1.getProcessInstanceId());
        this.assertProcessEnded(pi2.getProcessInstanceId());
    }

    @Deployment
    public void testExpressionRecalculateCurrentDateBased() throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("duration", "PT1H");
        ProcessInstanceWithVariables pi1 = (ProcessInstanceWithVariables)this.runtimeService.startProcessInstanceByKey("intermediateTimerEventExample", variables);
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi1.getId());
        IntermediateTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        Job job = (Job)jobQuery.singleResult();
        Date firstDate = job.getDuedate();
        this.moveByMinutes(1);
        Date currentTime = ClockUtil.getCurrentTime();
        this.runtimeService.setVariable(pi1.getProcessInstanceId(), "duration", (Object)"PT15M");
        this.processEngine.getManagementService().recalculateJobDuedate(job.getId(), false);
        IntermediateTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        job = (Job)jobQuery.singleResult();
        Assert.assertNotEquals((Object)firstDate, (Object)job.getDuedate());
        IntermediateTimerEventTest.assertTrue((boolean)firstDate.after(job.getDuedate()));
        Date expectedDate = LocalDateTime.fromDateFields((Date)currentTime).plusMinutes(15).toDate();
        Assertions.assertThat((Date)job.getDuedate()).isCloseTo(expectedDate, 1000L);
        ClockUtil.setCurrentTime((Date)new Date(firstDate.getTime() + TimeUnit.MINUTES.toMillis(16L)));
        this.waitForJobExecutorToProcessAllJobs(5000L);
        IntermediateTimerEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().processInstanceId(pi1.getId()).count());
        this.assertProcessEnded(pi1.getProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/IntermediateTimerEventTest.testExpressionRecalculateCurrentDateBased.bpmn20.xml"})
    public void testExpressionRecalculateCreationDateBased() throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("duration", "PT1H");
        ProcessInstanceWithVariables pi1 = (ProcessInstanceWithVariables)this.runtimeService.startProcessInstanceByKey("intermediateTimerEventExample", variables);
        JobQuery jobQuery = this.managementService.createJobQuery().processInstanceId(pi1.getId());
        IntermediateTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        Job job = (Job)jobQuery.singleResult();
        Date firstDate = job.getDuedate();
        this.moveByMinutes(65);
        this.runtimeService.setVariable(pi1.getProcessInstanceId(), "duration", (Object)"PT15M");
        this.processEngine.getManagementService().recalculateJobDuedate(job.getId(), true);
        IntermediateTimerEventTest.assertEquals((long)1L, (long)jobQuery.count());
        job = (Job)jobQuery.singleResult();
        Assert.assertNotEquals((Object)firstDate, (Object)job.getDuedate());
        IntermediateTimerEventTest.assertTrue((boolean)firstDate.after(job.getDuedate()));
        Date expectedDate = LocalDateTime.fromDateFields((Date)job.getCreateTime()).plusMinutes(15).toDate();
        IntermediateTimerEventTest.assertEquals((Object)expectedDate, (Object)job.getDuedate());
        ClockUtil.setCurrentTime((Date)new Date(firstDate.getTime() + TimeUnit.MINUTES.toMillis(16L)));
        this.waitForJobExecutorToProcessAllJobs(5000L);
        IntermediateTimerEventTest.assertEquals((long)0L, (long)this.managementService.createJobQuery().processInstanceId(pi1.getId()).count());
        this.assertProcessEnded(pi1.getProcessInstanceId());
    }

    @Deployment
    public void testTimeCycle() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        JobQuery query = this.managementService.createJobQuery();
        IntermediateTimerEventTest.assertEquals((long)1L, (long)query.count());
        String jobId = ((Job)query.singleResult()).getId();
        this.managementService.executeJob(jobId);
        IntermediateTimerEventTest.assertEquals((long)0L, (long)query.count());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment
    public void testRecalculateTimeCycleExpressionCurrentDateBased() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("cycle", "R/PT15M");
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process", variables).getId();
        JobQuery query = this.managementService.createJobQuery();
        IntermediateTimerEventTest.assertEquals((long)1L, (long)query.count());
        Job job = (Job)query.singleResult();
        Date oldDuedate = job.getDuedate();
        String jobId = job.getId();
        this.runtimeService.setVariable(processInstanceId, "cycle", (Object)"R/PT10M");
        this.managementService.recalculateJobDuedate(jobId, false);
        IntermediateTimerEventTest.assertEquals((long)1L, (long)query.count());
        IntermediateTimerEventTest.assertTrue((boolean)oldDuedate.after(((Job)query.singleResult()).getDuedate()));
        this.managementService.executeJob(jobId);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        this.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/IntermediateTimerEventTest.testRecalculateTimeCycleExpressionCurrentDateBased.bpmn20.xml"})
    public void testRecalculateTimeCycleExpressionCreationDateBased() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("cycle", "R/PT15M");
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process", variables).getId();
        JobQuery query = this.managementService.createJobQuery();
        IntermediateTimerEventTest.assertEquals((long)1L, (long)query.count());
        Job job = (Job)query.singleResult();
        Date oldDuedate = job.getDuedate();
        String jobId = job.getId();
        this.runtimeService.setVariable(processInstanceId, "cycle", (Object)"R/PT10M");
        this.managementService.recalculateJobDuedate(jobId, true);
        IntermediateTimerEventTest.assertEquals((long)1L, (long)query.count());
        Date newDuedate = ((Job)query.singleResult()).getDuedate();
        IntermediateTimerEventTest.assertTrue((boolean)oldDuedate.after(newDuedate));
        Date expectedDate = LocalDateTime.fromDateFields((Date)job.getCreateTime()).plusMinutes(10).toDate();
        IntermediateTimerEventTest.assertEquals((Object)expectedDate, (Object)newDuedate);
        this.managementService.executeJob(jobId);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        this.assertProcessEnded(processInstanceId);
    }

    private void moveByMinutes(int minutes) throws Exception {
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + (long)(minutes * 60 * 1000 + 5000)));
    }
}

