/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.external;

import java.util.HashMap;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.test.Deployment;

public class ExternalTaskParseTest
extends PluggableProcessEngineTestCase {
    public void testParseExternalTaskWithoutTopic() {
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/external/ExternalTaskParseTest.testParseExternalTaskWithoutTopic.bpmn20.xml");
        try {
            deploymentBuilder.deploy();
            ExternalTaskParseTest.fail((String)"exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("External tasks must specify a 'topic' attribute in the camunda namespace", e.getMessage());
        }
    }

    @Deployment
    public void testParseExternalTaskWithExpressionTopic() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("topicName", "testTopicExpression");
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithExpressionTopicProcess", variables);
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        ExternalTaskParseTest.assertEquals((String)"testTopicExpression", (String)task.getTopicName());
    }

    @Deployment
    public void testParseExternalTaskWithStringTopic() {
        HashMap variables = new HashMap();
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskWithStringTopicProcess", variables);
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        ExternalTaskParseTest.assertEquals((String)"testTopicString", (String)task.getTopicName());
    }
}

